/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.StandardFlowFileEvent;
import org.apache.nifi.controller.repository.StandardRepositoryStatusReport;

public class RingBufferEventRepository
implements FlowFileEventRepository {
    private final int numMinutes;
    private final ConcurrentMap<String, EventContainer> componentEventMap = new ConcurrentHashMap<String, EventContainer>();

    public RingBufferEventRepository(int numMinutes) {
        this.numMinutes = numMinutes;
    }

    public void close() throws IOException {
    }

    public void updateRepository(FlowFileEvent event) {
        EventContainer oldEventContainer;
        String componentId = event.getComponentIdentifier();
        EventContainer eventContainer = (EventContainer)this.componentEventMap.get(componentId);
        if (eventContainer == null && (oldEventContainer = this.componentEventMap.putIfAbsent(componentId, eventContainer = new SecondPrecisionEventContainer(this.numMinutes))) != null) {
            eventContainer = oldEventContainer;
        }
        eventContainer.addEvent(event);
    }

    public StandardRepositoryStatusReport reportTransferEvents(long sinceEpochMillis) {
        StandardRepositoryStatusReport report = new StandardRepositoryStatusReport();
        for (Map.Entry entry : this.componentEventMap.entrySet()) {
            String consumerId = (String)entry.getKey();
            EventContainer container = (EventContainer)entry.getValue();
            FlowFileEvent reportEntry = container.generateReport(consumerId, sinceEpochMillis);
            report.addReportEntry(reportEntry);
        }
        return report;
    }

    public void purgeTransferEvents(long cutoffEpochMilliseconds) {
        for (EventContainer container : this.componentEventMap.values()) {
            container.purgeEvents(cutoffEpochMilliseconds);
        }
    }

    private class SecondPrecisionEventContainer
    implements EventContainer {
        private final int numBins;
        private final EventSum[] sums;

        public SecondPrecisionEventContainer(int numMinutes) {
            this.numBins = 1 + numMinutes * 60;
            this.sums = new EventSum[this.numBins];
            for (int i = 0; i < this.numBins; ++i) {
                this.sums[i] = new EventSum();
            }
        }

        @Override
        public void addEvent(FlowFileEvent event) {
            int second = (int)(System.currentTimeMillis() / 1000L);
            int binIdx = second % this.numBins;
            EventSum sum = this.sums[binIdx];
            sum.addOrReset(event);
        }

        @Override
        public void purgeEvents(long cutoffEpochMilliseconds) {
        }

        @Override
        public FlowFileEvent generateReport(String consumerId, long sinceEpochMillis) {
            int flowFilesIn = 0;
            int flowFilesOut = 0;
            int flowFilesRemoved = 0;
            long contentSizeIn = 0L;
            long contentSizeOut = 0L;
            long contentSizeRemoved = 0L;
            long bytesRead = 0L;
            long bytesWritten = 0L;
            int invocations = 0;
            long processingNanos = 0L;
            long aggregateLineageMillis = 0L;
            int flowFilesReceived = 0;
            int flowFilesSent = 0;
            long bytesReceived = 0L;
            long bytesSent = 0L;
            long second = sinceEpochMillis / 1000L;
            int startBinIdx = (int)(second % (long)this.numBins);
            for (int i = 0; i < this.numBins; ++i) {
                int binIdx = (startBinIdx + i) % this.numBins;
                EventSum sum = this.sums[binIdx];
                EventSumValue sumValue = sum.getValue();
                if (sumValue.getTimestamp() < sinceEpochMillis) continue;
                flowFilesIn += sumValue.getFlowFilesIn();
                flowFilesOut += sumValue.getFlowFilesOut();
                flowFilesRemoved += sumValue.getFlowFilesRemoved();
                contentSizeIn += sumValue.getContentSizeIn();
                contentSizeOut += sumValue.getContentSizeOut();
                contentSizeRemoved += sumValue.getContentSizeRemoved();
                bytesRead += sumValue.getBytesRead();
                bytesWritten += sumValue.getBytesWritten();
                flowFilesReceived += sumValue.getFlowFilesReceived();
                bytesReceived += sumValue.getBytesReceived();
                flowFilesSent += sumValue.getFlowFilesSent();
                bytesSent += sumValue.getBytesSent();
                invocations += sumValue.getInvocations();
                processingNanos += sumValue.getProcessingNanoseconds();
                aggregateLineageMillis += sumValue.getAggregateLineageMillis();
            }
            return new StandardFlowFileEvent(consumerId, flowFilesIn, contentSizeIn, flowFilesOut, contentSizeOut, flowFilesRemoved, contentSizeRemoved, bytesRead, bytesWritten, flowFilesReceived, bytesReceived, flowFilesSent, bytesSent, invocations, aggregateLineageMillis, processingNanos);
        }
    }

    private static class EventSumValue {
        private final int flowFilesIn;
        private final int flowFilesOut;
        private final int flowFilesRemoved;
        private final long contentSizeIn;
        private final long contentSizeOut;
        private final long contentSizeRemoved;
        private final long bytesRead;
        private final long bytesWritten;
        private final int flowFilesReceived;
        private final int flowFilesSent;
        private final long bytesReceived;
        private final long bytesSent;
        private final long processingNanos;
        private final long aggregateLineageMillis;
        private final int invocations;
        private final long minuteTimestamp;
        private final long millisecondTimestamp;

        public EventSumValue() {
            this.flowFilesRemoved = 0;
            this.flowFilesOut = 0;
            this.flowFilesIn = 0;
            this.contentSizeRemoved = 0L;
            this.contentSizeOut = 0L;
            this.contentSizeIn = 0L;
            this.bytesWritten = 0L;
            this.bytesRead = 0L;
            this.flowFilesSent = 0;
            this.flowFilesReceived = 0;
            this.bytesSent = 0L;
            this.bytesReceived = 0L;
            this.invocations = 0;
            this.processingNanos = 0;
            this.aggregateLineageMillis = 0L;
            this.millisecondTimestamp = System.currentTimeMillis();
            this.minuteTimestamp = this.millisecondTimestamp / 60000L;
        }

        public EventSumValue(EventSumValue base, int flowFilesIn, int flowFilesOut, int flowFilesRemoved, long contentSizeIn, long contentSizeOut, long contentSizeRemoved, long bytesRead, long bytesWritten, int flowFilesReceived, long bytesReceived, int flowFilesSent, long bytesSent, long processingNanos, int invocations, long aggregateLineageMillis) {
            this.flowFilesIn = base.flowFilesIn + flowFilesIn;
            this.flowFilesOut = base.flowFilesOut + flowFilesOut;
            this.flowFilesRemoved = base.flowFilesRemoved + flowFilesRemoved;
            this.contentSizeIn = base.contentSizeIn + contentSizeIn;
            this.contentSizeOut = base.contentSizeOut + contentSizeOut;
            this.contentSizeRemoved = base.contentSizeRemoved + contentSizeRemoved;
            this.bytesRead = base.bytesRead + bytesRead;
            this.bytesWritten = base.bytesWritten + bytesWritten;
            this.flowFilesReceived = base.flowFilesReceived + flowFilesReceived;
            this.bytesReceived = base.bytesReceived + bytesReceived;
            this.flowFilesSent = base.flowFilesSent + flowFilesSent;
            this.bytesSent = base.bytesSent + bytesSent;
            this.processingNanos = base.processingNanos + processingNanos;
            this.invocations = base.invocations + invocations;
            this.aggregateLineageMillis = base.aggregateLineageMillis + aggregateLineageMillis;
            this.millisecondTimestamp = System.currentTimeMillis();
            this.minuteTimestamp = this.millisecondTimestamp / 60000L;
        }

        public long getTimestamp() {
            return this.millisecondTimestamp;
        }

        public long getMinuteTimestamp() {
            return this.minuteTimestamp;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public int getFlowFilesIn() {
            return this.flowFilesIn;
        }

        public int getFlowFilesOut() {
            return this.flowFilesOut;
        }

        public long getContentSizeIn() {
            return this.contentSizeIn;
        }

        public long getContentSizeOut() {
            return this.contentSizeOut;
        }

        public int getFlowFilesRemoved() {
            return this.flowFilesRemoved;
        }

        public long getContentSizeRemoved() {
            return this.contentSizeRemoved;
        }

        public long getProcessingNanoseconds() {
            return this.processingNanos;
        }

        public int getInvocations() {
            return this.invocations;
        }

        public long getAggregateLineageMillis() {
            return this.aggregateLineageMillis;
        }

        public int getFlowFilesReceived() {
            return this.flowFilesReceived;
        }

        public int getFlowFilesSent() {
            return this.flowFilesSent;
        }

        public long getBytesReceived() {
            return this.bytesReceived;
        }

        public long getBytesSent() {
            return this.bytesSent;
        }
    }

    private class EventSum {
        private final AtomicReference<EventSumValue> ref = new AtomicReference<EventSumValue>(new EventSumValue());

        private EventSum() {
        }

        private void add(FlowFileEvent event) {
            EventSumValue newValue;
            EventSumValue value;
            while (!this.ref.compareAndSet(value = this.ref.get(), newValue = new EventSumValue(value, event.getFlowFilesIn(), event.getFlowFilesOut(), event.getFlowFilesRemoved(), event.getContentSizeIn(), event.getContentSizeOut(), event.getContentSizeRemoved(), event.getBytesRead(), event.getBytesWritten(), event.getFlowFilesReceived(), event.getBytesReceived(), event.getFlowFilesSent(), event.getBytesSent(), event.getProcessingNanoseconds(), event.getInvocations(), event.getAggregateLineageMillis()))) {
            }
        }

        public EventSumValue getValue() {
            return this.ref.get();
        }

        public void addOrReset(FlowFileEvent event) {
            long expectedMinute = System.currentTimeMillis() / 60000L;
            EventSumValue curValue = this.ref.get();
            if (curValue.getMinuteTimestamp() != expectedMinute) {
                this.ref.compareAndSet(curValue, new EventSumValue());
            }
            this.add(event);
        }
    }

    private static interface EventContainer {
        public void addEvent(FlowFileEvent var1);

        public void purgeEvents(long var1);

        public FlowFileEvent generateReport(String var1, long var2);
    }
}

