/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.events.BulletinProcessingStrategy;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.util.RingBuffer;

public class VolatileBulletinRepository
implements BulletinRepository {
    private static final int CONTROLLER_BUFFER_SIZE = 10;
    private static final int COMPONENT_BUFFER_SIZE = 5;
    private static final String CONTROLLER_BULLETIN_STORE_KEY = "CONTROLLER";
    private static final String SERVICE_BULLETIN_STORE_KEY = "SERVICE";
    private static final String REPORTING_TASK_BULLETIN_STORE_KEY = "REPORTING_TASK";
    private final ConcurrentMap<String, ConcurrentMap<String, RingBuffer<Bulletin>>> bulletinStoreMap = new ConcurrentHashMap<String, ConcurrentMap<String, RingBuffer<Bulletin>>>();
    private volatile BulletinProcessingStrategy processingStrategy = new DefaultBulletinProcessingStrategy();

    public void addBulletin(Bulletin bulletin) {
        this.processingStrategy.update(bulletin);
    }

    public int getControllerBulletinCapacity() {
        return 10;
    }

    public int getComponentBulletinCapacity() {
        return 5;
    }

    public List<Bulletin> findBulletins(final BulletinQuery bulletinQuery) {
        RingBuffer.Filter<Bulletin> filter = new RingBuffer.Filter<Bulletin>(){

            public boolean select(Bulletin bulletin) {
                long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
                if (bulletin.getTimestamp().getTime() < fiveMinutesAgo) {
                    return false;
                }
                if (bulletinQuery.getAfter() != null && bulletin.getId() <= bulletinQuery.getAfter()) {
                    return false;
                }
                if (!(bulletinQuery.getGroupIdPattern() == null || bulletin.getGroupId() != null && bulletinQuery.getGroupIdPattern().matcher(bulletin.getGroupId()).find())) {
                    return false;
                }
                if (!(bulletinQuery.getMessagePattern() == null || bulletin.getMessage() != null && bulletinQuery.getMessagePattern().matcher(bulletin.getMessage()).find())) {
                    return false;
                }
                if (!(bulletinQuery.getNamePattern() == null || bulletin.getSourceName() != null && bulletinQuery.getNamePattern().matcher(bulletin.getSourceName()).find())) {
                    return false;
                }
                if (!(bulletinQuery.getSourceIdPattern() == null || bulletin.getSourceId() != null && bulletinQuery.getSourceIdPattern().matcher(bulletin.getSourceId()).find())) {
                    return false;
                }
                return bulletinQuery.getSourceType() == null || bulletin.getSourceType() != null && bulletinQuery.getSourceType().equals((Object)bulletin.getSourceType());
            }
        };
        ArrayList<Bulletin> selected = new ArrayList<Bulletin>();
        int max = bulletinQuery.getLimit() == null ? Integer.MAX_VALUE : bulletinQuery.getLimit();
        block0: for (ConcurrentMap componentMap : this.bulletinStoreMap.values()) {
            for (RingBuffer ringBuffer : componentMap.values()) {
                List bulletinsForComponent = ringBuffer.getSelectedElements((RingBuffer.Filter)filter, max);
                selected.addAll(bulletinsForComponent);
                if ((max -= bulletinsForComponent.size()) > 0) continue;
                continue block0;
            }
        }
        Collections.sort(selected);
        return selected;
    }

    public List<Bulletin> findBulletinsForSource(String sourceId) {
        return this.findBulletins(new BulletinQuery.Builder().sourceIdMatches(sourceId).limit(Integer.valueOf(5)).build());
    }

    public List<Bulletin> findBulletinsForGroupBySource(String groupId) {
        return this.findBulletinsForGroupBySource(groupId, 5);
    }

    public List<Bulletin> findBulletinsForGroupBySource(String groupId, int maxPerComponent) {
        final long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
        ConcurrentMap componentMap = (ConcurrentMap)this.bulletinStoreMap.get(groupId);
        if (componentMap == null) {
            return Collections.emptyList();
        }
        ArrayList<Bulletin> allComponentBulletins = new ArrayList<Bulletin>();
        for (RingBuffer ringBuffer : componentMap.values()) {
            allComponentBulletins.addAll(ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<Bulletin>(){

                public boolean select(Bulletin bulletin) {
                    return bulletin.getTimestamp().getTime() >= fiveMinutesAgo;
                }
            }, maxPerComponent));
        }
        return allComponentBulletins;
    }

    public List<Bulletin> findBulletinsForController() {
        return this.findBulletinsForController(10);
    }

    public List<Bulletin> findBulletinsForController(int max) {
        RingBuffer buffer;
        final long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
        RingBuffer.Filter<Bulletin> filter = new RingBuffer.Filter<Bulletin>(){

            public boolean select(Bulletin bulletin) {
                return bulletin.getTimestamp().getTime() >= fiveMinutesAgo;
            }
        };
        ArrayList<Bulletin> controllerBulletins = new ArrayList<Bulletin>();
        ConcurrentMap controllerBulletinMap = (ConcurrentMap)this.bulletinStoreMap.get(CONTROLLER_BULLETIN_STORE_KEY);
        if (controllerBulletinMap != null && (buffer = (RingBuffer)controllerBulletinMap.get(CONTROLLER_BULLETIN_STORE_KEY)) != null) {
            controllerBulletins.addAll(buffer.getSelectedElements((RingBuffer.Filter)filter, max));
        }
        for (String key : new String[]{SERVICE_BULLETIN_STORE_KEY, REPORTING_TASK_BULLETIN_STORE_KEY}) {
            ConcurrentMap bulletinMap = (ConcurrentMap)this.bulletinStoreMap.get(key);
            if (bulletinMap == null) continue;
            for (RingBuffer buffer2 : bulletinMap.values()) {
                controllerBulletins.addAll(buffer2.getSelectedElements((RingBuffer.Filter)filter, max));
            }
        }
        Collections.sort(controllerBulletins);
        if (controllerBulletins.size() > max) {
            return controllerBulletins.subList(0, max);
        }
        return controllerBulletins;
    }

    private List<RingBuffer<Bulletin>> getBulletinBuffers(Bulletin bulletin) {
        RingBuffer existingBuffer;
        RingBuffer bulletinBuffer;
        ConcurrentMap existing;
        String storageKey = this.getBulletinStoreKey(bulletin);
        ConcurrentMap<String, RingBuffer> componentMap = (ConcurrentHashMap)this.bulletinStoreMap.get(storageKey);
        if (componentMap == null && (existing = (ConcurrentMap)this.bulletinStoreMap.putIfAbsent(storageKey, componentMap = new ConcurrentHashMap())) != null) {
            componentMap = existing;
        }
        ArrayList<RingBuffer<Bulletin>> buffers = new ArrayList<RingBuffer<Bulletin>>(2);
        if (this.isControllerBulletin(bulletin)) {
            bulletinBuffer = (RingBuffer)componentMap.get(CONTROLLER_BULLETIN_STORE_KEY);
            if (bulletinBuffer == null && (existingBuffer = componentMap.putIfAbsent(CONTROLLER_BULLETIN_STORE_KEY, bulletinBuffer = new RingBuffer(10))) != null) {
                bulletinBuffer = existingBuffer;
            }
            buffers.add((RingBuffer<Bulletin>)bulletinBuffer);
        }
        if (bulletin.getSourceType() != ComponentType.FLOW_CONTROLLER) {
            bulletinBuffer = (RingBuffer)componentMap.get(bulletin.getSourceId());
            if (bulletinBuffer == null) {
                bulletinBuffer = new RingBuffer(5);
                existingBuffer = componentMap.putIfAbsent(bulletin.getSourceId(), bulletinBuffer);
                if (existingBuffer != null) {
                    bulletinBuffer = existingBuffer;
                }
            }
            buffers.add((RingBuffer<Bulletin>)bulletinBuffer);
        }
        return buffers;
    }

    private String getBulletinStoreKey(Bulletin bulletin) {
        switch (bulletin.getSourceType()) {
            case FLOW_CONTROLLER: {
                return CONTROLLER_BULLETIN_STORE_KEY;
            }
            case CONTROLLER_SERVICE: {
                return SERVICE_BULLETIN_STORE_KEY;
            }
            case REPORTING_TASK: {
                return REPORTING_TASK_BULLETIN_STORE_KEY;
            }
        }
        return bulletin.getGroupId();
    }

    private boolean isControllerBulletin(Bulletin bulletin) {
        switch (bulletin.getSourceType()) {
            case FLOW_CONTROLLER: 
            case CONTROLLER_SERVICE: 
            case REPORTING_TASK: {
                return true;
            }
        }
        return false;
    }

    private class DefaultBulletinProcessingStrategy
    implements BulletinProcessingStrategy {
        private DefaultBulletinProcessingStrategy() {
        }

        public void update(Bulletin bulletin) {
            for (RingBuffer bulletinBuffer : VolatileBulletinRepository.this.getBulletinBuffers(bulletin)) {
                bulletinBuffer.add((Object)bulletin);
            }
        }
    }
}

