/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.List;
import java.util.Set;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.processor.Relationship;

public class Connectables {
    public static boolean flowFilesQueued(Connectable connectable) {
        for (Connection conn : connectable.getIncomingConnections()) {
            if (conn.getFlowFileQueue().isActiveQueueEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean anyRelationshipAvailable(Connectable connectable) {
        for (Relationship relationship : connectable.getRelationships()) {
            Set connections = connectable.getConnections(relationship);
            boolean available = true;
            for (Connection connection : connections) {
                if (!connection.getFlowFileQueue().isFull()) continue;
                available = false;
                break;
            }
            if (!available) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNonLoopConnection(Connectable connectable) {
        List connections = connectable.getIncomingConnections();
        for (Connection connection : connections) {
            if (connection.getSource().equals(connectable)) continue;
            return true;
        }
        return false;
    }
}

