/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.ArrayList;
import java.util.Set;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.remote.cluster.ClusterNodeInformation;
import org.apache.nifi.remote.cluster.NodeInformant;
import org.apache.nifi.remote.cluster.NodeInformation;

public class ClusterCoordinatorNodeInformant
implements NodeInformant {
    private final ClusterCoordinator clusterCoordinator;

    public ClusterCoordinatorNodeInformant(ClusterCoordinator coordinator) {
        this.clusterCoordinator = coordinator;
    }

    public ClusterNodeInformation getNodeInformation() {
        ArrayList<NodeInformation> nodeInfoCollection = new ArrayList<NodeInformation>();
        Set nodeIds = this.clusterCoordinator.getNodeIdentifiers(new NodeConnectionState[]{NodeConnectionState.CONNECTED});
        for (NodeIdentifier nodeId : nodeIds) {
            NodeInformation nodeInfo = new NodeInformation(nodeId.getSiteToSiteAddress(), nodeId.getSiteToSitePort(), nodeId.getSiteToSiteHttpApiPort(), nodeId.getApiPort(), nodeId.isSiteToSiteSecure(), 0);
            nodeInfoCollection.add(nodeInfo);
        }
        ClusterNodeInformation nodeInfo = new ClusterNodeInformation();
        nodeInfo.setNodeInformation(nodeInfoCollection);
        return nodeInfo;
    }
}

