/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class ByteCountingInputStream
extends InputStream {
    private final AtomicLong bytesReadHolder;
    private final InputStream in;
    private long bytesSkipped = 0L;

    public ByteCountingInputStream(InputStream in, AtomicLong longHolder) {
        this.in = in;
        this.bytesReadHolder = longHolder;
    }

    @Override
    public int read() throws IOException {
        int fromSuper = this.in.read();
        if (fromSuper >= 0) {
            this.bytesReadHolder.getAndIncrement();
        }
        return fromSuper;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int fromSuper = this.in.read(b, off, len);
        if (fromSuper >= 0) {
            this.bytesReadHolder.getAndAdd(fromSuper);
        }
        return fromSuper;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.bytesSkipped += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public long getBytesRead() {
        return this.bytesReadHolder.get();
    }

    public long getBytesSkipped() {
        return this.bytesSkipped;
    }

    public long getStreamLocation() {
        return this.getBytesRead() + this.getBytesSkipped();
    }
}

