/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.Connectables;

public class StandardProcessContext
implements ProcessContext,
ControllerServiceLookup {
    private final ProcessorNode procNode;
    private final ControllerServiceProvider controllerServiceProvider;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final StringEncryptor encryptor;
    private final StateManager stateManager;
    private final VariableRegistry variableRegistry;

    public StandardProcessContext(ProcessorNode processorNode, ControllerServiceProvider controllerServiceProvider, StringEncryptor encryptor, StateManager stateManager, VariableRegistry variableRegistry) {
        this.procNode = processorNode;
        this.controllerServiceProvider = controllerServiceProvider;
        this.encryptor = encryptor;
        this.stateManager = stateManager;
        this.variableRegistry = variableRegistry;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry entry : this.procNode.getProperties().entrySet()) {
            PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.getProperty(descriptor.getName());
    }

    public PropertyValue getProperty(String propertyName) {
        Processor processor = this.procNode.getProcessor();
        PropertyDescriptor descriptor = processor.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return null;
        }
        String setPropertyValue = this.procNode.getProperty(descriptor);
        String propValue = setPropertyValue == null ? descriptor.getDefaultValue() : setPropertyValue;
        return new StandardPropertyValue(propValue, (ControllerServiceLookup)this, this.preparedQueries.get(descriptor), this.variableRegistry);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new StandardPropertyValue(rawValue, (ControllerServiceLookup)this, Query.prepare((String)rawValue), this.variableRegistry);
    }

    public void yield() {
        this.procNode.yield();
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerServiceForComponent(serviceIdentifier, this.procNode.getIdentifier());
    }

    public int getMaxConcurrentTasks() {
        return this.procNode.getMaxConcurrentTasks();
    }

    public String getAnnotationData() {
        return this.procNode.getAnnotationData();
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.procNode.getProperties();
    }

    public String encrypt(String unencrypted) {
        return this.encryptor.encrypt(unencrypted);
    }

    public String decrypt(String encrypted) {
        return this.encryptor.decrypt(encrypted);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        if (!serviceType.isInterface()) {
            throw new IllegalArgumentException("ControllerServices may be referenced only via their interfaces; " + serviceType + " is not an interface");
        }
        return this.controllerServiceProvider.getControllerServiceIdentifiers(serviceType, this.procNode.getProcessGroup().getIdentifier());
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.controllerServiceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public Set<Relationship> getAvailableRelationships() {
        HashSet<Relationship> set = new HashSet<Relationship>();
        for (Relationship relationship : this.procNode.getRelationships()) {
            Set connections = this.procNode.getConnections(relationship);
            if (connections.isEmpty()) {
                set.add(relationship);
                continue;
            }
            boolean available = true;
            for (Connection connection : connections) {
                if (!connection.getFlowFileQueue().isFull()) continue;
                available = false;
            }
            if (!available) continue;
            set.add(relationship);
        }
        return set;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerServiceName(serviceIdentifier);
    }

    public boolean hasIncomingConnection() {
        return this.procNode.hasIncomingConnection();
    }

    public boolean hasNonLoopConnection() {
        return Connectables.hasNonLoopConnection((Connectable)this.procNode);
    }

    public boolean hasConnection(Relationship relationship) {
        Set connections = this.procNode.getConnections(relationship);
        return connections != null && !connections.isEmpty();
    }

    public boolean isExpressionLanguagePresent(PropertyDescriptor property) {
        if (property == null || !property.isExpressionLanguageSupported()) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.getProperty(property).getValue());
        return elRanges != null && !elRanges.isEmpty();
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getName() {
        return this.procNode.getName();
    }
}

