/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.ComponentSpecificControllerServiceLookup;
import org.apache.nifi.registry.VariableRegistry;

public class StandardValidationContext
implements ValidationContext {
    private final ControllerServiceProvider controllerServiceProvider;
    private final Map<PropertyDescriptor, String> properties;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final Map<String, Boolean> expressionLanguageSupported;
    private final String annotationData;
    private final Set<String> serviceIdentifiersToNotValidate;
    private final VariableRegistry variableRegistry;
    private final String groupId;
    private final String componentId;

    public StandardValidationContext(ControllerServiceProvider controllerServiceProvider, Map<PropertyDescriptor, String> properties, String annotationData, String groupId, String componentId, VariableRegistry variableRegistry) {
        this(controllerServiceProvider, Collections.emptySet(), properties, annotationData, groupId, componentId, variableRegistry);
    }

    public StandardValidationContext(ControllerServiceProvider controllerServiceProvider, Set<String> serviceIdentifiersToNotValidate, Map<PropertyDescriptor, String> properties, String annotationData, String groupId, String componentId, VariableRegistry variableRegistry) {
        this.controllerServiceProvider = controllerServiceProvider;
        this.properties = new HashMap<PropertyDescriptor, String>(properties);
        this.annotationData = annotationData;
        this.serviceIdentifiersToNotValidate = serviceIdentifiersToNotValidate;
        this.variableRegistry = variableRegistry;
        this.groupId = groupId;
        this.componentId = componentId;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>(properties.size());
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
        this.expressionLanguageSupported = new HashMap<String, Boolean>(properties.size());
        for (PropertyDescriptor descriptor : properties.keySet()) {
            this.expressionLanguageSupported.put(descriptor.getName(), descriptor.isExpressionLanguageSupported());
        }
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new StandardPropertyValue(rawValue, (ControllerServiceLookup)this.controllerServiceProvider, Query.prepare((String)rawValue), this.variableRegistry);
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler(this.variableRegistry);
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        ControllerServiceNode serviceNode = this.controllerServiceProvider.getControllerServiceNode(controllerService.getIdentifier());
        ProcessGroup serviceGroup = serviceNode.getProcessGroup();
        String serviceGroupId = serviceGroup == null ? null : serviceGroup.getIdentifier();
        return new StandardValidationContext(this.controllerServiceProvider, serviceNode.getProperties(), serviceNode.getAnnotationData(), serviceGroupId, serviceNode.getIdentifier(), this.variableRegistry);
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.properties.get(property);
        return new StandardPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, (ControllerServiceLookup)this.controllerServiceProvider, this.preparedQueries.get(property), this.variableRegistry);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return new ComponentSpecificControllerServiceLookup(this.controllerServiceProvider, this.componentId, this.groupId);
    }

    public boolean isValidationRequired(ControllerService service) {
        return !this.serviceIdentifiersToNotValidate.contains(service.getIdentifier());
    }

    public boolean isExpressionLanguagePresent(String value) {
        if (value == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)value);
        return elRanges != null && !elRanges.isEmpty();
    }

    public boolean isExpressionLanguageSupported(String propertyName) {
        Boolean supported = this.expressionLanguageSupported.get(propertyName);
        return Boolean.TRUE.equals(supported);
    }

    public String getProcessGroupIdentifier() {
        return this.groupId;
    }
}

