/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.cluster;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.HeartbeatPayload;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;
import org.apache.nifi.cluster.protocol.message.HeartbeatResponseMessage;
import org.apache.nifi.controller.cluster.Heartbeater;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterProtocolHeartbeater
implements Heartbeater {
    private static final Logger logger = LoggerFactory.getLogger(ClusterProtocolHeartbeater.class);
    private final NodeProtocolSender protocolSender;
    private final LeaderElectionManager electionManager;
    private final ClusterCoordinator clusterCoordinator;

    public ClusterProtocolHeartbeater(NodeProtocolSender protocolSender, ClusterCoordinator clusterCoordinator, LeaderElectionManager electionManager) {
        this.protocolSender = protocolSender;
        this.clusterCoordinator = clusterCoordinator;
        this.electionManager = electionManager;
    }

    @Override
    public String getHeartbeatAddress() throws IOException {
        String heartbeatAddress = this.electionManager.getLeader("Cluster Coordinator");
        if (heartbeatAddress == null) {
            throw new ProtocolException("Cannot send heartbeat because there is no Cluster Coordinator currently elected");
        }
        return heartbeatAddress;
    }

    @Override
    public synchronized void send(HeartbeatMessage heartbeatMessage) throws IOException {
        String heartbeatAddress = this.getHeartbeatAddress();
        HeartbeatResponseMessage responseMessage = this.protocolSender.heartbeat(heartbeatMessage, heartbeatAddress);
        byte[] payloadBytes = heartbeatMessage.getHeartbeat().getPayload();
        HeartbeatPayload payload = HeartbeatPayload.unmarshal((byte[])payloadBytes);
        List nodeStatusList = payload.getClusterStatus();
        Map<NodeIdentifier, Long> updateIdMap = nodeStatusList.stream().collect(Collectors.toMap(status -> status.getNodeIdentifier(), status -> status.getUpdateIdentifier()));
        List updatedStatuses = responseMessage.getUpdatedNodeStatuses();
        if (updatedStatuses != null) {
            Iterator iterator = updatedStatuses.iterator();
            while (iterator.hasNext()) {
                NodeConnectionStatus updatedStatus;
                NodeIdentifier nodeId = (updatedStatus = (NodeConnectionStatus)iterator.next()).getNodeIdentifier();
                Long updateId = updateIdMap.get(nodeId);
                boolean updated = this.clusterCoordinator.resetNodeStatus(updatedStatus, updateId == null ? -1L : updateId);
                if (updated) {
                    logger.info("After receiving heartbeat response, updated status of {} to {}", (Object)updatedStatus.getNodeIdentifier(), (Object)updatedStatus);
                    continue;
                }
                logger.debug("After receiving heartbeat response, did not update status of {} to {} because the update is out-of-date", (Object)updatedStatus.getNodeIdentifier(), (Object)updatedStatus);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

