/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.claim;

import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.StandardResourceClaimManager;

public class StandardResourceClaim
implements ResourceClaim,
Comparable<ResourceClaim> {
    private final StandardResourceClaimManager claimManager;
    private final String id;
    private final String container;
    private final String section;
    private final boolean lossTolerant;
    private final int hashCode;
    private volatile boolean writable = true;

    public StandardResourceClaim(StandardResourceClaimManager claimManager, String container, String section, String id, boolean lossTolerant) {
        this.claimManager = claimManager;
        this.container = container.intern();
        this.section = section.intern();
        this.id = id;
        this.lossTolerant = lossTolerant;
        this.hashCode = 17 + 19 * id.hashCode() + 19 * container.hashCode() + 19 * section.hashCode();
    }

    public boolean isLossTolerant() {
        return this.lossTolerant;
    }

    public String getId() {
        return this.id;
    }

    public String getContainer() {
        return this.container;
    }

    public String getSection() {
        return this.section;
    }

    @Override
    public int compareTo(ResourceClaim other) {
        int idComparison = this.id.compareTo(other.getId());
        if (idComparison != 0) {
            return idComparison;
        }
        int containerComparison = this.container.compareTo(other.getContainer());
        if (containerComparison != 0) {
            return containerComparison;
        }
        return this.section.compareTo(other.getSection());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hashCode != other.hashCode()) {
            return false;
        }
        if (!(other instanceof ResourceClaim)) {
            return false;
        }
        ResourceClaim otherClaim = (ResourceClaim)other;
        return this.id.equals(otherClaim.getId()) && this.container.equals(otherClaim.getContainer()) && this.section.equals(otherClaim.getSection());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "StandardResourceClaim[id=" + this.id + ", container=" + this.container + ", section=" + this.section + "]";
    }

    public boolean isWritable() {
        return this.writable;
    }

    void freeze() {
        this.writable = false;
    }

    public boolean isInUse() {
        return this.isWritable() || this.claimManager.getClaimantCount(this) > 0;
    }
}

