/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.scheduling.ScheduleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.engine.FlowEngine;

abstract class AbstractSchedulingAgent
implements SchedulingAgent {
    protected final FlowEngine flowEngine;

    protected AbstractSchedulingAgent(FlowEngine flowEngine) {
        this.flowEngine = flowEngine;
    }

    public void schedule(Connectable connectable, ScheduleState scheduleState) {
        scheduleState.setScheduled(true);
        this.doSchedule(connectable, scheduleState);
    }

    public void unschedule(Connectable connectable, ScheduleState scheduleState) {
        scheduleState.setScheduled(false);
        this.doUnschedule(connectable, scheduleState);
    }

    public void schedule(ReportingTaskNode taskNode, ScheduleState scheduleState) {
        scheduleState.setScheduled(true);
        this.doSchedule(taskNode, scheduleState);
    }

    public void unschedule(ReportingTaskNode taskNode, ScheduleState scheduleState) {
        scheduleState.setScheduled(false);
        this.doUnschedule(taskNode, scheduleState);
    }

    protected abstract void doSchedule(Connectable var1, ScheduleState var2);

    protected abstract void doUnschedule(Connectable var1, ScheduleState var2);

    protected abstract void doSchedule(ReportingTaskNode var1, ScheduleState var2);

    protected abstract void doUnschedule(ReportingTaskNode var1, ScheduleState var2);
}

