/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.engine;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowEngine
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FlowEngine.class);

    public FlowEngine(int corePoolSize, String threadNamePrefix) {
        this(corePoolSize, threadNamePrefix, false);
    }

    public FlowEngine(int corePoolSize, final String threadNamePrefix, final boolean daemon) {
        super(corePoolSize);
        final AtomicInteger threadIndex = new AtomicInteger(0);
        final ThreadFactory defaultThreadFactory = this.getThreadFactory();
        this.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = defaultThreadFactory.newThread(r);
                if (daemon) {
                    t.setDaemon(true);
                }
                t.setName(threadNamePrefix + " Thread-" + threadIndex.incrementAndGet());
                return t;
            }
        });
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        thread.setContextClassLoader((ClassLoader)NarThreadContextClassLoader.getInstance());
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        block10: {
            super.afterExecute(runnable, throwable);
            if (runnable instanceof FutureTask) {
                FutureTask task = (FutureTask)runnable;
                try {
                    if (!task.isDone()) break block10;
                    if (task.isCancelled()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("A flow controller execution task '{}' has been cancelled.", (Object)runnable);
                        }
                        break block10;
                    }
                    task.get();
                    logger.debug("A Flow Controller execution task '{}' has completed.", (Object)runnable);
                }
                catch (CancellationException ce) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("A flow controller execution task '{}' has been cancelled.", (Object)runnable);
                    }
                }
                catch (InterruptedException ie) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("A flow controller execution task has been interrupted.", (Throwable)ie);
                    }
                }
                catch (ExecutionException ee) {
                    logger.error("A flow controller task execution stopped abnormally", (Throwable)ee);
                }
            } else {
                logger.debug("A flow controller execution task '{}' has finished.", (Object)runnable);
            }
        }
    }

    @Override
    protected void terminated() {
        super.terminated();
    }
}

