/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.fingerprint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.fingerprint.FingerprintException;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class FingerprintFactory {
    public static final String NO_VALUE = "NO_VALUE";
    private static final String FLOW_CONFIG_XSD = "/FlowConfiguration.xsd";
    private static final Schema FLOW_CONFIG_SCHEMA;
    private static final DocumentBuilder FLOW_CONFIG_DOC_BUILDER;
    private static final String ENCRYPTED_VALUE_PREFIX = "enc{";
    private static final String ENCRYPTED_VALUE_SUFFIX = "}";
    private final StringEncryptor encryptor;
    private static final Logger logger;

    public FingerprintFactory(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public String createFingerprint(byte[] flowBytes, FlowController controller) throws FingerprintException {
        try {
            return this.createFingerprint(this.parseFlow(flowBytes), controller);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FingerprintException(e);
        }
    }

    private String createFingerprint(Document flowDoc, FlowController controller) throws NoSuchAlgorithmException {
        if (flowDoc == null) {
            return "";
        }
        StringBuilder fingerprintBuilder = new StringBuilder();
        Element flowControllerElem = flowDoc.getDocumentElement();
        if (flowControllerElem == null) {
            logger.warn("Unable to create fingerprint because no 'flowController' element found in XML.");
            return "";
        }
        this.addFlowControllerFingerprint(fingerprintBuilder, flowControllerElem, controller);
        return fingerprintBuilder.toString();
    }

    private Document parseFlow(byte[] flow) throws FingerprintException {
        if (flow == null || flow.length == 0) {
            return null;
        }
        try {
            return FLOW_CONFIG_DOC_BUILDER.parse(new ByteArrayInputStream(flow));
        }
        catch (IOException | SAXException ex) {
            throw new FingerprintException(ex);
        }
    }

    private StringBuilder addFlowControllerFingerprint(StringBuilder builder, Element flowControllerElem, FlowController controller) {
        Element reportingTasksElem;
        Element rootGroupElem = (Element)DomUtils.getChildNodesByTagName(flowControllerElem, "rootGroup").item(0);
        this.addProcessGroupFingerprint(builder, rootGroupElem, controller);
        Element controllerServicesElem = DomUtils.getChild(flowControllerElem, "controllerServices");
        if (controllerServicesElem != null) {
            ArrayList<ControllerServiceDTO> serviceDtos = new ArrayList<ControllerServiceDTO>();
            for (Element serviceElem : DomUtils.getChildElementsByTagName(controllerServicesElem, "controllerService")) {
                ControllerServiceDTO controllerServiceDTO = FlowFromDOMFactory.getControllerService(serviceElem, this.encryptor);
                serviceDtos.add(controllerServiceDTO);
            }
            Collections.sort(serviceDtos, new Comparator<ControllerServiceDTO>(){

                @Override
                public int compare(ControllerServiceDTO o1, ControllerServiceDTO o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (ControllerServiceDTO dto : serviceDtos) {
                this.addControllerServiceFingerprint(builder, dto, controller);
            }
        }
        if ((reportingTasksElem = DomUtils.getChild(flowControllerElem, "reportingTasks")) != null) {
            ArrayList<ReportingTaskDTO> reportingTaskDtos = new ArrayList<ReportingTaskDTO>();
            for (Element element : DomUtils.getChildElementsByTagName(reportingTasksElem, "reportingTask")) {
                ReportingTaskDTO dto = FlowFromDOMFactory.getReportingTask(element, this.encryptor);
                reportingTaskDtos.add(dto);
            }
            Collections.sort(reportingTaskDtos, new Comparator<ReportingTaskDTO>(){

                @Override
                public int compare(ReportingTaskDTO o1, ReportingTaskDTO o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (ReportingTaskDTO reportingTaskDTO : reportingTaskDtos) {
                this.addReportingTaskFingerprint(builder, reportingTaskDTO, controller);
            }
        }
        return builder;
    }

    private StringBuilder addSnippetFingerprint(StringBuilder builder, FlowSnippetDTO snippet, FlowController controller) {
        Comparator<ComponentDTO> componentComparator = new Comparator<ComponentDTO>(){

            @Override
            public int compare(ComponentDTO o1, ComponentDTO o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getId().compareTo(o2.getId());
            }
        };
        Set connections = snippet.getConnections();
        if (connections == null || connections.isEmpty()) {
            builder.append("NO_CONNECTIONS");
        } else {
            ArrayList sortedConnections = new ArrayList(connections);
            Collections.sort(sortedConnections, componentComparator);
            for (Object connection : sortedConnections) {
                this.addConnectionFingerprint(builder, (ConnectionDTO)connection);
            }
        }
        Set funnels = snippet.getFunnels();
        if (funnels == null || funnels.isEmpty()) {
            builder.append("NO_FUNNELS");
        } else {
            ArrayList sortedFunnels = new ArrayList(funnels);
            Collections.sort(sortedFunnels, componentComparator);
            for (Object funnel : sortedFunnels) {
                this.addFunnelFingerprint(builder, (FunnelDTO)funnel);
            }
        }
        Set inputPorts = snippet.getInputPorts();
        if (inputPorts == null || inputPorts.isEmpty()) {
            builder.append("NO_INPUT_PORTS");
        } else {
            ArrayList sortedInputPorts = new ArrayList(inputPorts);
            Collections.sort(sortedInputPorts, componentComparator);
            for (Object port : sortedInputPorts) {
                this.addPortFingerprint(builder, (PortDTO)port);
            }
        }
        Set outputPorts = snippet.getOutputPorts();
        if (outputPorts == null || outputPorts.isEmpty()) {
            builder.append("NO_OUTPUT_PORTS");
        } else {
            ArrayList sortedOutputPorts = new ArrayList(outputPorts);
            Collections.sort(sortedOutputPorts, componentComparator);
            for (Object port : sortedOutputPorts) {
                this.addPortFingerprint(builder, (PortDTO)port);
            }
        }
        Set labels = snippet.getLabels();
        if (labels == null || labels.isEmpty()) {
            builder.append("NO_LABELS");
        } else {
            ArrayList sortedLabels = new ArrayList(labels);
            Collections.sort(sortedLabels, componentComparator);
            for (Object label : sortedLabels) {
                this.addLabelFingerprint(builder, (LabelDTO)label);
            }
        }
        Set procGroups = snippet.getProcessGroups();
        if (procGroups == null || procGroups.isEmpty()) {
            builder.append("NO_PROCESS_GROUPS");
        } else {
            ArrayList sortedProcGroups = new ArrayList(procGroups);
            Collections.sort(sortedProcGroups, componentComparator);
            for (Object procGroup : sortedProcGroups) {
                this.addProcessGroupFingerprint(builder, (ProcessGroupDTO)procGroup, controller);
            }
        }
        Set processors = snippet.getProcessors();
        if (processors == null || processors.isEmpty()) {
            builder.append("NO_PROCESSORS");
        } else {
            ArrayList sortedProcessors = new ArrayList(processors);
            Collections.sort(sortedProcessors, componentComparator);
            for (Object proc : sortedProcessors) {
                this.addProcessorFingerprint(builder, (ProcessorDTO)proc, controller);
            }
        }
        Set remoteGroups = snippet.getRemoteProcessGroups();
        if (remoteGroups == null || remoteGroups.isEmpty()) {
            builder.append("NO_REMOTE_PROCESS_GROUPS");
        } else {
            ArrayList sortedRemoteGroups = new ArrayList(remoteGroups);
            Collections.sort(sortedRemoteGroups, componentComparator);
            for (RemoteProcessGroupDTO remoteGroup : sortedRemoteGroups) {
                this.addRemoteProcessGroupFingerprint(builder, remoteGroup);
            }
        }
        Set services = snippet.getControllerServices();
        if (services == null || services.isEmpty()) {
            builder.append("NO_CONTROLLER_SERVICES");
        } else {
            ArrayList sortedServices = new ArrayList(services);
            Collections.sort(sortedServices, componentComparator);
            for (ControllerServiceDTO service : sortedServices) {
                this.addControllerServiceFingerprint(builder, service, controller);
            }
        }
        return builder;
    }

    private StringBuilder addProcessGroupFingerprint(StringBuilder builder, Element processGroupElem, FlowController controller) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processGroupElem, "id"));
        List<Element> processorElems = DomUtils.getChildElementsByTagName(processGroupElem, "processor");
        Collections.sort(processorElems, this.getIdsComparator());
        for (Element processorElem : processorElems) {
            this.addFlowFileProcessorFingerprint(builder, processorElem, controller);
        }
        NodeList inputPortElems = DomUtils.getChildNodesByTagName(processGroupElem, "inputPort");
        List<Element> sortedInputPortElems = this.sortElements(inputPortElems, this.getIdsComparator());
        for (Element inputPortElem : sortedInputPortElems) {
            this.addPortFingerprint(builder, inputPortElem);
        }
        NodeList labelElems = DomUtils.getChildNodesByTagName(processGroupElem, "label");
        List<Element> sortedLabels = this.sortElements(labelElems, this.getIdsComparator());
        for (Element labelElem : sortedLabels) {
            this.addLabelFingerprint(builder, labelElem);
        }
        NodeList outputPortElems = DomUtils.getChildNodesByTagName(processGroupElem, "outputPort");
        List<Element> sortedOutputPortElems = this.sortElements(outputPortElems, this.getIdsComparator());
        for (Element outputPortElem : sortedOutputPortElems) {
            this.addPortFingerprint(builder, outputPortElem);
        }
        NodeList nestedProcessGroupElems = DomUtils.getChildNodesByTagName(processGroupElem, "processGroup");
        List<Element> sortedNestedProcessGroupElems = this.sortElements(nestedProcessGroupElems, this.getIdsComparator());
        for (Element nestedProcessGroupElem : sortedNestedProcessGroupElems) {
            this.addProcessGroupFingerprint(builder, nestedProcessGroupElem, controller);
        }
        NodeList remoteProcessGroupElems = DomUtils.getChildNodesByTagName(processGroupElem, "remoteProcessGroup");
        List<Element> sortedRemoteProcessGroupElems = this.sortElements(remoteProcessGroupElems, this.getIdsComparator());
        for (Element remoteProcessGroupElem : sortedRemoteProcessGroupElems) {
            this.addRemoteProcessGroupFingerprint(builder, remoteProcessGroupElem);
        }
        NodeList connectionElems = DomUtils.getChildNodesByTagName(processGroupElem, "connection");
        List<Element> sortedConnectionElems = this.sortElements(connectionElems, this.getIdsComparator());
        for (Element connectionElem : sortedConnectionElems) {
            this.addConnectionFingerprint(builder, connectionElem);
        }
        NodeList funnelElems = DomUtils.getChildNodesByTagName(processGroupElem, "funnel");
        List<Element> sortedFunnelElems = this.sortElements(funnelElems, this.getIdsComparator());
        for (Element funnelElem : sortedFunnelElems) {
            this.addFunnelFingerprint(builder, funnelElem);
        }
        return builder;
    }

    private StringBuilder addProcessGroupFingerprint(StringBuilder builder, ProcessGroupDTO group, FlowController controller) {
        builder.append(group.getId());
        builder.append(group.getName());
        builder.append(group.getParentGroupId());
        FlowSnippetDTO contents = group.getContents();
        this.addSnippetFingerprint(builder, contents, controller);
        return builder;
    }

    private StringBuilder addFlowFileProcessorFingerprint(StringBuilder builder, Element processorElem, FlowController controller) throws FingerprintException {
        Processor processor;
        block5: {
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "id"));
            NodeList childNodes = DomUtils.getChildNodesByTagName(processorElem, "class");
            String className = childNodes.item(0).getTextContent();
            this.appendFirstValue(builder, childNodes);
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "annotationData"));
            processor = null;
            try {
                if (controller != null) {
                    processor = controller.createProcessor(className, UUID.randomUUID().toString(), false).getProcessor();
                }
            }
            catch (ProcessorInstantiationException e) {
                logger.warn("Unable to create Processor of type {} due to {}; its default properties will be fingerprinted instead of being ignored.", (Object)className, (Object)e.toString());
                if (!logger.isDebugEnabled()) break block5;
                logger.warn("", (Throwable)e);
            }
        }
        NodeList propertyElems = DomUtils.getChildNodesByTagName(processorElem, "property");
        List<Element> sortedPropertyElems = this.sortElements(propertyElems, this.getProcessorPropertiesComparator());
        for (Element propertyElem : sortedPropertyElems) {
            String propName = DomUtils.getChildElementsByTagName(propertyElem, "name").get(0).getTextContent();
            String propValue = this.getFirstValue(DomUtils.getChildNodesByTagName(propertyElem, "value"), null);
            this.addPropertyFingerprint(builder, (ConfigurableComponent)processor, propName, propValue);
        }
        NodeList autoTerminateElems = DomUtils.getChildNodesByTagName(processorElem, "autoTerminatedRelationship");
        List<Element> sortedAutoTerminateElems = this.sortElements(autoTerminateElems, this.getElementTextComparator());
        for (Element autoTerminateElem : sortedAutoTerminateElems) {
            builder.append(autoTerminateElem.getTextContent());
        }
        return builder;
    }

    private StringBuilder addProcessorFingerprint(StringBuilder builder, ProcessorDTO processor, FlowController controller) {
        Processor processorInstance;
        ProcessorConfigDTO config;
        block6: {
            config = processor.getConfig();
            builder.append(processor.getId());
            builder.append(processor.getClass().getName());
            builder.append(processor.getName());
            builder.append(config.getBulletinLevel());
            builder.append(config.getComments());
            builder.append(config.getSchedulingPeriod());
            builder.append(config.getSchedulingStrategy());
            builder.append(config.getYieldDuration());
            builder.append(config.getConcurrentlySchedulableTaskCount());
            builder.append(config.getPenaltyDuration());
            builder.append(config.getAnnotationData());
            processorInstance = null;
            try {
                if (controller != null) {
                    processorInstance = controller.createProcessor(processor.getType(), UUID.randomUUID().toString(), false).getProcessor();
                }
            }
            catch (ProcessorInstantiationException e) {
                logger.warn("Unable to create Processor of type {} due to {}; its default properties will be fingerprinted instead of being ignored.", (Object)processor.getType(), (Object)e.toString());
                if (!logger.isDebugEnabled()) break block6;
                logger.warn("", (Throwable)e);
            }
        }
        this.addPropertiesFingerprint(builder, (ConfigurableComponent)processorInstance, config.getProperties());
        Set autoTerm = config.getAutoTerminatedRelationships();
        if (autoTerm == null || autoTerm.isEmpty()) {
            builder.append("NO_AUTO_TERMINATED_RELATIONSHIPS");
        } else {
            ArrayList sortedAutoTerm = new ArrayList(autoTerm);
            Collections.sort(sortedAutoTerm);
            for (String rel : sortedAutoTerm) {
                builder.append(rel);
            }
        }
        return builder;
    }

    private StringBuilder addPropertyFingerprint(StringBuilder builder, ConfigurableComponent component, String propName, String propValue) throws FingerprintException {
        PropertyDescriptor descriptor;
        if (component != null && (descriptor = component.getPropertyDescriptor(propName)) != null && propValue != null && propValue.equals(descriptor.getDefaultValue())) {
            return builder;
        }
        if (propValue == null) {
            return builder;
        }
        builder.append(propName).append("=");
        if (this.isEncrypted(propValue)) {
            builder.append(this.decrypt(propValue));
        } else {
            builder.append(this.getValue(propValue, NO_VALUE));
        }
        return builder;
    }

    private StringBuilder addPortFingerprint(StringBuilder builder, Element portElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(portElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(portElem, "name"));
        NodeList userAccessControlNodeList = DomUtils.getChildNodesByTagName(portElem, "userAccessControl");
        if (userAccessControlNodeList == null || userAccessControlNodeList.getLength() == 0) {
            builder.append("NO_USER_ACCESS_CONTROL");
        } else {
            ArrayList<String> sortedAccessControl = new ArrayList<String>();
            for (int i = 0; i < userAccessControlNodeList.getLength(); ++i) {
                sortedAccessControl.add(userAccessControlNodeList.item(i).getTextContent());
            }
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        NodeList groupAccessControlNodeList = DomUtils.getChildNodesByTagName(portElem, "userAccessControl");
        if (groupAccessControlNodeList == null || groupAccessControlNodeList.getLength() == 0) {
            builder.append("NO_GROUP_ACCESS_CONTROL");
        } else {
            ArrayList<String> sortedAccessControl = new ArrayList<String>();
            for (int i = 0; i < groupAccessControlNodeList.getLength(); ++i) {
                sortedAccessControl.add(groupAccessControlNodeList.item(i).getTextContent());
            }
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        return builder;
    }

    private StringBuilder addPortFingerprint(StringBuilder builder, PortDTO port) {
        builder.append(port.getId());
        builder.append(port.getName());
        Set userAccessControl = port.getUserAccessControl();
        if (userAccessControl == null || userAccessControl.isEmpty()) {
            builder.append("NO_USER_ACCESS_CONTROL");
        } else {
            ArrayList sortedAccessControl = new ArrayList(userAccessControl);
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        Set groupAccessControl = port.getGroupAccessControl();
        if (groupAccessControl == null || groupAccessControl.isEmpty()) {
            builder.append("NO_GROUP_ACCESS_CONTROL");
        } else {
            ArrayList sortedAccessControl = new ArrayList(groupAccessControl);
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        return builder;
    }

    private StringBuilder addLabelFingerprint(StringBuilder builder, Element labelElem) {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(labelElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(labelElem, "value"));
        return builder;
    }

    private StringBuilder addLabelFingerprint(StringBuilder builder, LabelDTO label) {
        builder.append(label.getId());
        builder.append(label.getLabel());
        return builder;
    }

    private StringBuilder addRemoteProcessGroupFingerprint(StringBuilder builder, Element remoteProcessGroupElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(remoteProcessGroupElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(remoteProcessGroupElem, "url"));
        NodeList inputPortList = DomUtils.getChildNodesByTagName(remoteProcessGroupElem, "inputPort");
        NodeList outputPortList = DomUtils.getChildNodesByTagName(remoteProcessGroupElem, "outputPort");
        Comparator<Element> portComparator = new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                NodeList nameList1 = DomUtils.getChildNodesByTagName(o1, "name");
                NodeList nameList2 = DomUtils.getChildNodesByTagName(o2, "name");
                if (nameList1.getLength() == 0 && nameList2.getLength() == 0) {
                    return 0;
                }
                if (nameList1.getLength() == 0) {
                    return 1;
                }
                if (nameList2.getLength() == 0) {
                    return -1;
                }
                return nameList1.item(0).getTextContent().compareTo(nameList2.item(0).getTextContent());
            }
        };
        ArrayList<Element> sortedInputPorts = new ArrayList<Element>(inputPortList.getLength());
        for (int i = 0; i < inputPortList.getLength(); ++i) {
            sortedInputPorts.add((Element)inputPortList.item(i));
        }
        Collections.sort(sortedInputPorts, portComparator);
        ArrayList<Element> sortedOutputPorts = new ArrayList<Element>(outputPortList.getLength());
        for (int i = 0; i < outputPortList.getLength(); ++i) {
            sortedOutputPorts.add((Element)outputPortList.item(i));
        }
        Collections.sort(sortedOutputPorts, portComparator);
        for (Element inputPortElement : sortedInputPorts) {
            this.addRemoteGroupPortFingerprint(builder, inputPortElement);
        }
        for (Element outputPortElement : sortedOutputPorts) {
            this.addRemoteGroupPortFingerprint(builder, outputPortElement);
        }
        return builder;
    }

    private StringBuilder addRemoteGroupPortFingerprint(StringBuilder builder, Element remoteGroupPortElement) {
        for (String childName : new String[]{"id", "maxConcurrentTasks", "useCompression"}) {
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(remoteGroupPortElement, childName));
        }
        return builder;
    }

    private StringBuilder addRemoteGroupPortFingerprint(StringBuilder builder, RemoteProcessGroupPortDTO port) {
        builder.append(port.getId());
        builder.append(port.getConcurrentlySchedulableTaskCount());
        builder.append(port.getUseCompression());
        return builder;
    }

    private StringBuilder addRemoteProcessGroupFingerprint(StringBuilder builder, RemoteProcessGroupDTO remoteGroup) {
        builder.append(remoteGroup.getId());
        builder.append(remoteGroup.getTargetUri());
        Comparator<RemoteProcessGroupPortDTO> comparator = new Comparator<RemoteProcessGroupPortDTO>(){

            @Override
            public int compare(RemoteProcessGroupPortDTO o1, RemoteProcessGroupPortDTO o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        };
        RemoteProcessGroupContentsDTO contents = remoteGroup.getContents();
        if (contents != null) {
            if (contents.getInputPorts() != null) {
                ArrayList sortedInputPorts = new ArrayList(contents.getInputPorts());
                Collections.sort(sortedInputPorts, comparator);
                for (RemoteProcessGroupPortDTO port : sortedInputPorts) {
                    if (!port.isConnected().booleanValue()) continue;
                    this.addRemoteGroupPortFingerprint(builder, port);
                }
            }
            if (contents.getOutputPorts() != null) {
                ArrayList sortedOutputPorts = new ArrayList(contents.getOutputPorts());
                Collections.sort(sortedOutputPorts, comparator);
                for (RemoteProcessGroupPortDTO port : sortedOutputPorts) {
                    if (!port.isConnected().booleanValue()) continue;
                    this.addRemoteGroupPortFingerprint(builder, port);
                }
            }
        }
        return builder;
    }

    private StringBuilder addConnectionFingerprint(StringBuilder builder, Element connectionElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "sourceId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "sourceGroupId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "sourceType"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "destinationId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "destinationGroupId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "destinationType"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "name"));
        NodeList relationshipElems = DomUtils.getChildNodesByTagName(connectionElem, "relationship");
        List<Element> sortedRelationshipElems = this.sortElements(relationshipElems, this.getConnectionRelationshipsComparator());
        for (Element relationshipElem : sortedRelationshipElems) {
            builder.append(this.getValue(relationshipElem, NO_VALUE));
        }
        return builder;
    }

    private StringBuilder addConnectionFingerprint(StringBuilder builder, ConnectionDTO connection) throws FingerprintException {
        builder.append(connection.getId());
        builder.append(connection.getSource().getId());
        builder.append(connection.getSource().getGroupId());
        builder.append(connection.getSource().getType());
        builder.append(connection.getDestination().getId());
        builder.append(connection.getDestination().getGroupId());
        builder.append(connection.getDestination().getType());
        if (connection.getSelectedRelationships() != null) {
            ArrayList sortedSelectedRelationships = new ArrayList(connection.getSelectedRelationships());
            Collections.sort(sortedSelectedRelationships);
            for (String rel : sortedSelectedRelationships) {
                builder.append(rel);
            }
        }
        return builder;
    }

    private StringBuilder addFunnelFingerprint(StringBuilder builder, Element funnelElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(funnelElem, "id"));
        return builder;
    }

    private StringBuilder addFunnelFingerprint(StringBuilder builder, FunnelDTO funnel) {
        builder.append(funnel.getId());
        return builder;
    }

    private void addControllerServiceFingerprint(StringBuilder builder, ControllerServiceDTO dto, FlowController controller) {
        ControllerService controllerService;
        block3: {
            builder.append(dto.getId());
            builder.append(dto.getType());
            builder.append(dto.getName());
            builder.append(dto.getComments());
            builder.append(dto.getAnnotationData());
            builder.append(dto.getState());
            controllerService = null;
            try {
                if (controller != null) {
                    controllerService = controller.createControllerService(dto.getType(), UUID.randomUUID().toString(), false).getControllerServiceImplementation();
                }
            }
            catch (Exception e) {
                logger.warn("Unable to create ControllerService of type {} due to {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType(), (Object)e.toString());
                if (!logger.isDebugEnabled()) break block3;
                logger.warn("", (Throwable)e);
            }
        }
        this.addPropertiesFingerprint(builder, (ConfigurableComponent)controllerService, dto.getProperties());
    }

    private void addPropertiesFingerprint(StringBuilder builder, ConfigurableComponent component, Map<String, String> properties) {
        if (properties == null) {
            builder.append("NO_PROPERTIES");
        } else {
            TreeMap<String, String> sortedProps = new TreeMap<String, String>(properties);
            for (Map.Entry entry : sortedProps.entrySet()) {
                this.addPropertyFingerprint(builder, component, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void addReportingTaskFingerprint(StringBuilder builder, ReportingTaskDTO dto, FlowController controller) {
        ReportingTask reportingTask;
        block3: {
            builder.append(dto.getId());
            builder.append(dto.getType());
            builder.append(dto.getName());
            builder.append(dto.getComments());
            builder.append(dto.getSchedulingPeriod());
            builder.append(dto.getSchedulingStrategy());
            builder.append(dto.getAnnotationData());
            reportingTask = null;
            try {
                if (controller != null) {
                    reportingTask = controller.createReportingTask(dto.getType(), UUID.randomUUID().toString(), false, false).getReportingTask();
                }
            }
            catch (Exception e) {
                logger.warn("Unable to create ReportingTask of type {} due to {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType(), (Object)e.toString());
                if (!logger.isDebugEnabled()) break block3;
                logger.warn("", (Throwable)e);
            }
        }
        this.addPropertiesFingerprint(builder, (ConfigurableComponent)reportingTask, dto.getProperties());
    }

    private Comparator<Element> getIdsComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                String e1Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e1, "id"));
                String e2Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e2, "id"));
                return e1Id.compareTo(e2Id);
            }
        };
    }

    private Comparator<Element> getProcessorPropertiesComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                String e1PropName = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e1, "name"));
                String e1PropValue = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e1, "value"));
                if (FingerprintFactory.this.isEncrypted(e1PropValue)) {
                    e1PropValue = FingerprintFactory.this.decrypt(e1PropValue);
                }
                String e1CombinedValue = e1PropName + e1PropValue;
                String e2PropName = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e2, "name"));
                String e2PropValue = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e2, "value"));
                if (FingerprintFactory.this.isEncrypted(e2PropValue)) {
                    e2PropValue = FingerprintFactory.this.decrypt(e2PropValue);
                }
                String e2CombinedValue = e2PropName + e2PropValue;
                return e1CombinedValue.compareTo(e2CombinedValue);
            }
        };
    }

    private Comparator<Element> getConnectionRelationshipsComparator() {
        return this.getSingleChildComparator("relationship");
    }

    private Comparator<Element> getSingleChildComparator(final String childElementName) {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                if (e2 == null) {
                    return -1;
                }
                if (e1 == null) {
                    return 1;
                }
                String e1Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e1, childElementName));
                if (e1Id == null) {
                    return 1;
                }
                String e2Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e2, childElementName));
                if (e2Id == null) {
                    return -1;
                }
                return e1Id.compareTo(e2Id);
            }
        };
    }

    private Comparator<Element> getElementTextComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                if (e2 == null) {
                    return -1;
                }
                if (e1 == null) {
                    return 1;
                }
                return e1.getTextContent().compareTo(e2.getTextContent());
            }
        };
    }

    private List<Element> sortElements(NodeList nodeList, Comparator<Element> comparator) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add((Element)nodeList.item(i));
        }
        Collections.sort(result, comparator);
        return result;
    }

    private String getValue(Node node) {
        return this.getValue(node, NO_VALUE);
    }

    private String getValue(Node node, String defaultValue) {
        String value = node.getTextContent() == null || StringUtils.isBlank((CharSequence)node.getTextContent()) ? defaultValue : node.getTextContent().trim();
        return value;
    }

    private String getValue(String value, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    private String getFirstValue(NodeList nodeList) {
        return this.getFirstValue(nodeList, NO_VALUE);
    }

    private String getFirstValue(NodeList nodeList, String defaultValue) {
        String value = nodeList == null || nodeList.getLength() == 0 ? defaultValue : this.getValue(nodeList.item(0));
        return value;
    }

    private StringBuilder appendFirstValue(StringBuilder builder, NodeList nodeList) {
        return this.appendFirstValue(builder, nodeList, NO_VALUE);
    }

    private StringBuilder appendFirstValue(StringBuilder builder, NodeList nodeList, String defaultValue) {
        return builder.append(this.getFirstValue(nodeList, defaultValue));
    }

    private boolean isEncrypted(String value) {
        return value.startsWith(ENCRYPTED_VALUE_PREFIX) && value.endsWith(ENCRYPTED_VALUE_SUFFIX);
    }

    private String decrypt(String value) throws FingerprintException {
        int decryptStartIdx = ENCRYPTED_VALUE_PREFIX.length();
        int decryptEndIdx = value.length() - ENCRYPTED_VALUE_SUFFIX.length();
        return this.encryptor.decrypt(value.substring(decryptStartIdx, decryptEndIdx));
    }

    static {
        logger = LoggerFactory.getLogger(FingerprintFactory.class);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            FLOW_CONFIG_SCHEMA = schemaFactory.newSchema(FingerprintFactory.class.getResource(FLOW_CONFIG_XSD));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse schema for file flow configuration.", e);
        }
        try {
            documentBuilderFactory.setSchema(FLOW_CONFIG_SCHEMA);
            FLOW_CONFIG_DOC_BUILDER = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create document builder for flow configuration.", e);
        }
    }
}

