/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProcessLogger
implements ComponentLog {
    private final Logger logger;
    private final LogRepository logRepository;
    private final Object component;

    public SimpleProcessLogger(String componentId, Object component) {
        this.logger = LoggerFactory.getLogger(component.getClass());
        this.logRepository = LogRepositoryFactory.getRepository((String)componentId);
        this.component = component;
    }

    private Object[] addProcessor(Object[] originalArgs) {
        return this.prependToArgs(originalArgs, this.component);
    }

    private Object[] prependToArgs(Object[] originalArgs, Object ... toAdd) {
        Object[] newArgs = new Object[originalArgs.length + toAdd.length];
        System.arraycopy(toAdd, 0, newArgs, 0, toAdd.length);
        System.arraycopy(originalArgs, 0, newArgs, toAdd.length, originalArgs.length);
        return newArgs;
    }

    private Object[] translateException(Object[] os) {
        if (os != null && os.length > 0 && os[os.length - 1] instanceof Throwable) {
            Object[] osCopy = new Object[os.length];
            osCopy[osCopy.length - 1] = os[os.length - 1].toString();
            System.arraycopy(os, 0, osCopy, 0, os.length - 1);
            return osCopy;
        }
        return os;
    }

    private boolean lastArgIsException(Object[] os) {
        return os != null && os.length > 0 && os[os.length - 1] instanceof Throwable;
    }

    public void warn(String msg, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component, t.toString(), t};
        this.logger.warn(msg, os);
        this.logRepository.addLogMessage(LogLevel.WARN, msg, os, t);
    }

    public void warn(String msg, Object[] os) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.lastArgIsException(os)) {
            this.warn(msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            msg = "{} " + msg;
            os = this.addProcessor(os);
            this.logger.warn(msg, os);
            this.logRepository.addLogMessage(LogLevel.WARN, msg, os);
        }
    }

    public void warn(String msg, Object[] os, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.warn(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.warn("", t);
        }
        this.logRepository.addLogMessage(LogLevel.WARN, msg, os, t);
    }

    public void warn(String msg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.warn(msg, this.component);
        this.logRepository.addLogMessage(LogLevel.WARN, msg, os);
    }

    public void trace(String msg, Throwable t) {
        if (!this.isTraceEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component, t.toString(), t};
        this.logger.trace(msg, os);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os, t);
    }

    public void trace(String msg, Object[] os) {
        if (!this.isTraceEnabled()) {
            return;
        }
        msg = "{} " + msg;
        os = this.addProcessor(os);
        this.logger.trace(msg, os);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os);
    }

    public void trace(String msg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.trace(msg, os);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os);
    }

    public void trace(String msg, Object[] os, Throwable t) {
        if (!this.isTraceEnabled()) {
            return;
        }
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.trace(msg, os);
        this.logger.trace("", t);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os, t);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled() || this.logRepository.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled() || this.logRepository.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled() || this.logRepository.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled() || this.logRepository.isErrorEnabled();
    }

    public void info(String msg, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component, t.toString()};
        this.logger.info(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os, t);
    }

    public void info(String msg, Object[] os) {
        if (!this.isInfoEnabled()) {
            return;
        }
        msg = "{} " + msg;
        os = this.addProcessor(os);
        this.logger.info(msg, os);
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os);
    }

    public void info(String msg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.info(msg, os);
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os);
    }

    public void info(String msg, Object[] os, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.info(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os, t);
    }

    public String getName() {
        return this.logger.getName();
    }

    public void error(String msg, Throwable t) {
        Object[] objectArray;
        if (!this.isErrorEnabled()) {
            return;
        }
        msg = "{} " + msg;
        if (t == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.component;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this.component;
            objectArray = objectArray3;
            objectArray3[1] = t.toString();
        }
        Object[] os = objectArray;
        this.logger.error(msg, os);
        if (t != null) {
            this.logger.error("", t);
            this.logRepository.addLogMessage(LogLevel.ERROR, msg, os, t);
        } else {
            this.logRepository.addLogMessage(LogLevel.ERROR, msg, os);
        }
    }

    public void error(String msg, Object[] os) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.lastArgIsException(os)) {
            this.error(msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            os = this.addProcessor(os);
            msg = "{} " + msg;
            this.logger.error(msg, os);
            this.logRepository.addLogMessage(LogLevel.ERROR, msg, os);
        }
    }

    public void error(String msg) {
        this.error(msg, (Throwable)null);
    }

    public void error(String msg, Object[] os, Throwable t) {
        if (!this.isErrorEnabled()) {
            return;
        }
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.error(msg, os);
        this.logger.error("", t);
        this.logRepository.addLogMessage(LogLevel.ERROR, msg, os, t);
    }

    private Object[] addProcessorAndThrowable(Object[] os, Throwable t) {
        Object[] modifiedArgs = new Object[os.length + 2];
        modifiedArgs[0] = this.component.toString();
        for (int i = 0; i < os.length; ++i) {
            modifiedArgs[i + 1] = os[i];
        }
        modifiedArgs[modifiedArgs.length - 1] = t == null ? "" : t.toString();
        return modifiedArgs;
    }

    public void debug(String msg, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.debug(msg, (Object)os, (Object)t);
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os, t);
    }

    public void debug(String msg, Object[] os) {
        if (!this.isDebugEnabled()) {
            return;
        }
        os = this.addProcessor(os);
        msg = "{} " + msg;
        this.logger.debug(msg, os);
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os);
    }

    public void debug(String msg, Object[] os, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.debug(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("", t);
        }
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os, t);
    }

    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.debug(msg, os);
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os);
    }

    public void log(LogLevel level, String msg, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, t);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, t);
                break;
            }
            case INFO: {
                this.info(msg, t);
                break;
            }
            case TRACE: {
                this.trace(msg, t);
                break;
            }
            case WARN: {
                this.warn(msg, t);
            }
        }
    }

    public void log(LogLevel level, String msg, Object[] os) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, os);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, os);
                break;
            }
            case INFO: {
                this.info(msg, os);
                break;
            }
            case TRACE: {
                this.trace(msg, os);
                break;
            }
            case WARN: {
                this.warn(msg, os);
            }
        }
    }

    public void log(LogLevel level, String msg) {
        switch (level) {
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg);
                break;
            }
            case INFO: {
                this.info(msg);
                break;
            }
            case TRACE: {
                this.trace(msg);
                break;
            }
            case WARN: {
                this.warn(msg);
            }
        }
    }

    public void log(LogLevel level, String msg, Object[] os, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, os, t);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, os, t);
                break;
            }
            case INFO: {
                this.info(msg, os, t);
                break;
            }
            case TRACE: {
                this.trace(msg, os, t);
                break;
            }
            case WARN: {
                this.warn(msg, os, t);
            }
        }
    }
}

