/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;

public class GhostReportingTask
implements ReportingTask {
    private String id;
    private String canonicalClassName;

    public void setIdentifier(String id) {
        this.id = id;
    }

    public void setCanonicalClassName(String canonicalClassName) {
        this.canonicalClassName = canonicalClassName;
    }

    public Collection<ValidationResult> validate(ValidationContext context) {
        return Collections.singleton(new ValidationResult.Builder().input("Any Property").subject("Missing Reporting Task").valid(false).explanation("Reporting Task is of type " + this.canonicalClassName + ", but this is not a valid Reporting Task type").build());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.buildDescriptor(name);
    }

    private PropertyDescriptor buildDescriptor(String propertyName) {
        return new PropertyDescriptor.Builder().name(propertyName).description(propertyName).required(true).sensitive(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    public String getIdentifier() {
        return this.id;
    }

    public String toString() {
        return "GhostReportingTask[id=" + this.id + "]";
    }

    public void initialize(ReportingInitializationContext config) throws InitializationException {
    }

    public void onTrigger(ReportingContext context) {
        throw new ProcessException("Unable to instantiate ReportingTask class");
    }
}

