/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordSerde;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.schema.ContentClaimFieldMap;
import org.apache.nifi.controller.repository.schema.ContentClaimSchema;
import org.apache.nifi.controller.repository.schema.RepositoryRecordFieldMap;
import org.apache.nifi.controller.repository.schema.RepositoryRecordSchema;
import org.apache.nifi.controller.repository.schema.RepositoryRecordUpdate;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SchemaRecordReader;
import org.apache.nifi.repository.schema.SchemaRecordWriter;
import org.apache.nifi.repository.schema.SimpleRecordField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.SerDe;
import org.wali.UpdateType;

public class SchemaRepositoryRecordSerde
extends RepositoryRecordSerde
implements SerDe<RepositoryRecord> {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRepositoryRecordSerde.class);
    private static final int MAX_ENCODING_VERSION = 1;
    private final RecordSchema writeSchema = RepositoryRecordSchema.REPOSITORY_RECORD_SCHEMA_V1;
    private final RecordSchema contentClaimSchema = ContentClaimSchema.CONTENT_CLAIM_SCHEMA_V1;
    private final ResourceClaimManager resourceClaimManager;
    private volatile RecordSchema recoverySchema;

    public SchemaRepositoryRecordSerde(ResourceClaimManager resourceClaimManager) {
        this.resourceClaimManager = resourceClaimManager;
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        this.writeSchema.writeTo((OutputStream)out);
    }

    public void serializeEdit(RepositoryRecord previousRecordState, RepositoryRecord newRecordState, DataOutputStream out) throws IOException {
        this.serializeRecord(newRecordState, out);
    }

    public void serializeRecord(RepositoryRecord record, DataOutputStream out) throws IOException {
        RecordSchema schema;
        switch (record.getType()) {
            case CREATE: 
            case UPDATE: {
                schema = RepositoryRecordSchema.CREATE_OR_UPDATE_SCHEMA_V1;
                break;
            }
            case CONTENTMISSING: 
            case DELETE: {
                schema = RepositoryRecordSchema.DELETE_SCHEMA_V1;
                break;
            }
            case SWAP_IN: {
                schema = RepositoryRecordSchema.SWAP_IN_SCHEMA_V1;
                break;
            }
            case SWAP_OUT: {
                schema = RepositoryRecordSchema.SWAP_OUT_SCHEMA_V1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Received Repository Record with unknown Update Type: " + record.getType());
            }
        }
        RepositoryRecordFieldMap fieldMap = new RepositoryRecordFieldMap(record, schema, this.contentClaimSchema);
        RepositoryRecordUpdate update = new RepositoryRecordUpdate(fieldMap, RepositoryRecordSchema.REPOSITORY_RECORD_SCHEMA_V1);
        new SchemaRecordWriter().writeRecord((Record)update, (OutputStream)out);
    }

    public void readHeader(DataInputStream in) throws IOException {
        this.recoverySchema = RecordSchema.readFrom((InputStream)in);
    }

    public RepositoryRecord deserializeEdit(DataInputStream in, Map<Object, RepositoryRecord> currentRecordStates, int version) throws IOException {
        return this.deserializeRecord(in, version);
    }

    public RepositoryRecord deserializeRecord(DataInputStream in, int version) throws IOException {
        SchemaRecordReader reader = SchemaRecordReader.fromSchema((RecordSchema)this.recoverySchema);
        Record updateRecord = reader.readRecord((InputStream)in);
        Record record = (Record)updateRecord.getFieldValue("Repository Record Update");
        String actionType = (String)record.getFieldValue(RepositoryRecordSchema.ACTION_TYPE_FIELD);
        UpdateType updateType = UpdateType.valueOf((String)actionType);
        switch (updateType) {
            case CREATE: {
                return this.createRecord(record);
            }
            case DELETE: {
                return this.deleteRecord(record);
            }
            case SWAP_IN: {
                return this.swapInRecord(record);
            }
            case SWAP_OUT: {
                return this.swapOutRecord(record);
            }
            case UPDATE: {
                return this.updateRecord(record);
            }
        }
        throw new IOException("Found unrecognized Update Type '" + actionType + "'");
    }

    private StandardRepositoryRecord createRecord(Record record) {
        StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder();
        ffBuilder.id((Long)record.getFieldValue("Record ID"));
        ffBuilder.entryDate((Long)record.getFieldValue("Entry Date"));
        Long lastQueueDate = (Long)record.getFieldValue("Queued Date");
        Long queueDateIndex = (Long)record.getFieldValue("Queued Date Index");
        ffBuilder.lastQueued(lastQueueDate, queueDateIndex);
        Long lineageStartDate = (Long)record.getFieldValue("Lineage Start Date");
        Long lineageStartIndex = (Long)record.getFieldValue("Lineage Start Index");
        ffBuilder.lineageStart(lineageStartDate, lineageStartIndex);
        this.populateContentClaim(ffBuilder, record);
        ffBuilder.size((Long)record.getFieldValue("FlowFile Size"));
        ffBuilder.addAttributes((Map)record.getFieldValue("Attributes"));
        FlowFileRecord flowFileRecord = ffBuilder.build();
        String queueId = (String)record.getFieldValue("Queue Identifier");
        FlowFileQueue queue = this.getFlowFileQueue(queueId);
        StandardRepositoryRecord repoRecord = new StandardRepositoryRecord(queue, flowFileRecord);
        this.requireFlowFileQueue(repoRecord, queueId);
        return repoRecord;
    }

    private void requireFlowFileQueue(StandardRepositoryRecord repoRecord, String queueId) {
        if (queueId == null || queueId.trim().isEmpty()) {
            logger.warn("{} does not have a Queue associated with it; this record will be discarded", (Object)repoRecord.getCurrent());
            repoRecord.markForAbort();
        } else if (repoRecord.getOriginalQueue() == null) {
            logger.warn("{} maps to unknown Queue {}; this record will be discarded", (Object)repoRecord.getCurrent(), (Object)queueId);
            repoRecord.markForAbort();
        }
    }

    private void populateContentClaim(StandardFlowFileRecord.Builder ffBuilder, Record record) {
        Object claimMap = record.getFieldValue("Content Claim");
        if (claimMap == null) {
            return;
        }
        Record claimRecord = (Record)claimMap;
        ContentClaim contentClaim = ContentClaimFieldMap.getContentClaim(claimRecord, this.resourceClaimManager);
        Long offset = ContentClaimFieldMap.getContentClaimOffset(claimRecord);
        ffBuilder.contentClaim(contentClaim);
        ffBuilder.contentClaimOffset(offset);
    }

    private RepositoryRecord updateRecord(Record record) {
        return this.createRecord(record);
    }

    private RepositoryRecord deleteRecord(Record record) {
        Long recordId = (Long)record.getFieldValue(RepositoryRecordSchema.RECORD_ID_FIELD);
        StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder().id(recordId);
        FlowFileRecord flowFileRecord = ffBuilder.build();
        StandardRepositoryRecord repoRecord = new StandardRepositoryRecord(null, flowFileRecord);
        repoRecord.markForDelete();
        return repoRecord;
    }

    private RepositoryRecord swapInRecord(Record record) {
        StandardRepositoryRecord repoRecord = this.createRecord(record);
        String swapLocation = (String)record.getFieldValue((RecordField)new SimpleRecordField("Swap Location", FieldType.STRING, Repetition.EXACTLY_ONE));
        repoRecord.setSwapLocation(swapLocation);
        String queueId = (String)record.getFieldValue("Queue Identifier");
        this.requireFlowFileQueue(repoRecord, queueId);
        return repoRecord;
    }

    private RepositoryRecord swapOutRecord(Record record) {
        Long recordId = (Long)record.getFieldValue(RepositoryRecordSchema.RECORD_ID_FIELD);
        String queueId = (String)record.getFieldValue((RecordField)new SimpleRecordField("Queue Identifier", FieldType.STRING, Repetition.EXACTLY_ONE));
        String swapLocation = (String)record.getFieldValue((RecordField)new SimpleRecordField("Swap Location", FieldType.STRING, Repetition.EXACTLY_ONE));
        FlowFileQueue queue = this.getFlowFileQueue(queueId);
        FlowFileRecord flowFileRecord = new StandardFlowFileRecord.Builder().id(recordId).build();
        return new StandardRepositoryRecord(queue, flowFileRecord, swapLocation);
    }

    public int getVersion() {
        return 1;
    }
}

