/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.schema.ContentClaimFieldMap;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;

public class RepositoryRecordFieldMap
implements Record {
    private final RepositoryRecord record;
    private final FlowFileRecord flowFile;
    private final RecordSchema schema;
    private final RecordSchema contentClaimSchema;

    public RepositoryRecordFieldMap(RepositoryRecord record, RecordSchema repoRecordSchema, RecordSchema contentClaimSchema) {
        this.schema = repoRecordSchema;
        this.contentClaimSchema = contentClaimSchema;
        this.record = record;
        this.flowFile = record.getCurrent();
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Action": {
                return this.record.getType().name();
            }
            case "Record ID": {
                return this.record.getCurrent().getId();
            }
            case "Swap Location": {
                return this.record.getSwapLocation();
            }
            case "Attributes": {
                return this.flowFile.getAttributes();
            }
            case "Entry Date": {
                return this.flowFile.getEntryDate();
            }
            case "FlowFile Size": {
                return this.flowFile.getSize();
            }
            case "Lineage Start Date": {
                return this.flowFile.getLineageStartDate();
            }
            case "Lineage Start Index": {
                return this.flowFile.getLineageStartIndex();
            }
            case "Queued Date": {
                return this.flowFile.getLastQueueDate();
            }
            case "Queued Date Index": {
                return this.flowFile.getQueueDateIndex();
            }
            case "Content Claim": {
                ContentClaimFieldMap contentClaimFieldMap = this.record.getCurrentClaim() == null ? null : new ContentClaimFieldMap(this.record.getCurrentClaim(), this.record.getCurrentClaimOffset(), this.contentClaimSchema);
                return contentClaimFieldMap;
            }
            case "Queue Identifier": {
                FlowFileQueue queue = this.record.getDestination() == null ? this.record.getOriginalQueue() : this.record.getDestination();
                return queue == null ? null : queue.getIdentifier();
            }
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        return "RepositoryRecordFieldMap[" + this.record + "]";
    }
}

