/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import org.apache.nifi.controller.repository.schema.RepositoryRecordFieldMap;
import org.apache.nifi.repository.schema.NamedValue;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.wali.UpdateType;

public class RepositoryRecordUpdate
implements Record {
    private final RecordSchema schema;
    private final RepositoryRecordFieldMap fieldMap;

    public RepositoryRecordUpdate(RepositoryRecordFieldMap fieldMap, RecordSchema schema) {
        this.schema = schema;
        this.fieldMap = fieldMap;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public Object getFieldValue(String fieldName) {
        if ("Repository Record Update".equals(fieldName)) {
            String actionName;
            String actionType = (String)this.fieldMap.getFieldValue("Action");
            UpdateType updateType = UpdateType.valueOf((String)actionType);
            switch (updateType) {
                case CREATE: 
                case UPDATE: {
                    actionName = "Create or Update";
                    break;
                }
                case DELETE: {
                    actionName = "Delete";
                    break;
                }
                case SWAP_IN: {
                    actionName = "Swap In";
                    break;
                }
                case SWAP_OUT: {
                    actionName = "Swap Out";
                    break;
                }
                default: {
                    return null;
                }
            }
            return new NamedValue(actionName, (Object)this.fieldMap);
        }
        return null;
    }
}

