/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.ValueReducer;

public enum ProcessorStatusDescriptor {
    BYTES_READ(new StandardMetricDescriptor<ProcessorStatus>("bytesRead", "Bytes Read (5 mins)", "The total number of bytes read from the Content Repository by this Processor in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getBytesRead())),
    BYTES_WRITTEN(new StandardMetricDescriptor<ProcessorStatus>("bytesWritten", "Bytes Written (5 mins)", "The total number of bytes written to the Content Repository by this Processor in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getBytesWritten())),
    BYTES_TRANSFERRED(new StandardMetricDescriptor<ProcessorStatus>("bytesTransferred", "Bytes Transferred (5 mins)", "The total number of bytes read from or written to the Content Repository by this Processor in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getBytesRead() + s.getBytesWritten())),
    INPUT_BYTES(new StandardMetricDescriptor<ProcessorStatus>("inputBytes", "Bytes In (5 mins)", "The cumulative size of all FlowFiles that this Processor has pulled from its queues in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getInputBytes())),
    INPUT_COUNT(new StandardMetricDescriptor<ProcessorStatus>("inputCount", "FlowFiles In (5 mins)", "The number of FlowFiles that this Processor has pulled from its queues in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getInputCount())),
    OUTPUT_BYTES(new StandardMetricDescriptor<ProcessorStatus>("outputBytes", "Bytes Out (5 mins)", "The cumulative size of all FlowFiles that this Processor has transferred to downstream queues in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getOutputBytes())),
    OUTPUT_COUNT(new StandardMetricDescriptor<ProcessorStatus>("outputCount", "FlowFiles Out (5 mins)", "The number of FlowFiles that this Processor has transferred to downstream queues in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getOutputCount())),
    TASK_COUNT(new StandardMetricDescriptor<ProcessorStatus>("taskCount", "Tasks (5 mins)", "The number of tasks that this Processor has completed in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getInvocations())),
    TASK_MILLIS(new StandardMetricDescriptor<ProcessorStatus>("taskMillis", "Total Task Duration (5 mins)", "The total number of thread-milliseconds that the Processor has used to complete its tasks in the past 5 minutes", MetricDescriptor.Formatter.DURATION, s -> TimeUnit.MILLISECONDS.convert(s.getProcessingNanos(), TimeUnit.NANOSECONDS))),
    FLOWFILES_REMOVED(new StandardMetricDescriptor<ProcessorStatus>("flowFilesRemoved", "FlowFiles Removed (5 mins)", "The total number of FlowFiles removed by this Processor in the last 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getFlowFilesRemoved())),
    AVERAGE_LINEAGE_DURATION(new StandardMetricDescriptor<ProcessorStatus>("averageLineageDuration", "Average Lineage Duration (5 mins)", "The average amount of time that a FlowFile took to process (from receipt until this Processor finished processing it) in the past 5 minutes.", MetricDescriptor.Formatter.DURATION, s -> s.getAverageLineageDuration(TimeUnit.MILLISECONDS), new ValueReducer<StatusSnapshot, Long>(){

        public Long reduce(List<StatusSnapshot> values) {
            long millis = 0L;
            int count = 0;
            for (StatusSnapshot snapshot : values) {
                long removed = (Long)snapshot.getStatusMetrics().get(FLOWFILES_REMOVED.getDescriptor());
                count = (int)((long)count + removed);
                count = (int)((long)count + (Long)snapshot.getStatusMetrics().get(OUTPUT_COUNT.getDescriptor()));
                long avgMillis = (Long)snapshot.getStatusMetrics().get(AVERAGE_LINEAGE_DURATION.getDescriptor());
                long totalMillis = avgMillis * removed;
                millis += totalMillis;
            }
            return count == 0 ? 0L : millis / (long)count;
        }
    })),
    AVERAGE_TASK_MILLIS(new StandardMetricDescriptor<ProcessorStatus>("averageTaskMillis", "Average Task Duration", "The average duration it took this Processor to complete a task, as averaged over the past 5 minutes", MetricDescriptor.Formatter.DURATION, s -> s.getInvocations() == 0 ? 0L : TimeUnit.MILLISECONDS.convert(s.getProcessingNanos(), TimeUnit.NANOSECONDS) / (long)s.getInvocations(), new ValueReducer<StatusSnapshot, Long>(){

        public Long reduce(List<StatusSnapshot> values) {
            long procMillis = 0L;
            int invocations = 0;
            for (StatusSnapshot snapshot : values) {
                procMillis += ((Long)snapshot.getStatusMetrics().get(TASK_MILLIS.getDescriptor())).longValue();
                invocations += ((Long)snapshot.getStatusMetrics().get(TASK_COUNT.getDescriptor())).intValue();
            }
            if (invocations == 0) {
                return 0L;
            }
            return procMillis / (long)invocations;
        }
    }));

    private MetricDescriptor<ProcessorStatus> descriptor;

    private ProcessorStatusDescriptor(MetricDescriptor<ProcessorStatus> descriptor) {
        this.descriptor = descriptor;
    }

    public String getField() {
        return this.descriptor.getField();
    }

    public MetricDescriptor<ProcessorStatus> getDescriptor() {
        return this.descriptor;
    }
}

