/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.Date;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.controller.status.history.ConnectionStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessorStatusDescriptor;
import org.apache.nifi.controller.status.history.RemoteProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusHistory;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.util.ComponentStatusReport;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.RingBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolatileComponentStatusRepository
implements ComponentStatusRepository {
    public static final String NUM_DATA_POINTS_PROPERTY = "nifi.components.status.repository.buffer.size";
    public static final int DEFAULT_NUM_DATA_POINTS = 288;
    private final RingBuffer<Capture> captures;
    private final Logger logger = LoggerFactory.getLogger(VolatileComponentStatusRepository.class);
    private volatile long lastCaptureTime = 0L;

    public VolatileComponentStatusRepository() {
        this.captures = null;
    }

    public VolatileComponentStatusRepository(NiFiProperties nifiProperties) {
        int numDataPoints = nifiProperties.getIntegerProperty(NUM_DATA_POINTS_PROPERTY, Integer.valueOf(288));
        this.captures = new RingBuffer(numDataPoints);
    }

    public void capture(ProcessGroupStatus rootGroupStatus) {
        this.capture(rootGroupStatus, new Date());
    }

    public synchronized void capture(ProcessGroupStatus rootGroupStatus, Date timestamp) {
        this.captures.add((Object)new Capture(timestamp, ComponentStatusReport.fromProcessGroupStatus(rootGroupStatus, ComponentStatusReport.ComponentType.PROCESSOR, ComponentStatusReport.ComponentType.CONNECTION, ComponentStatusReport.ComponentType.PROCESS_GROUP, ComponentStatusReport.ComponentType.REMOTE_PROCESS_GROUP)));
        this.logger.debug("Captured metrics for {}", (Object)this);
        this.lastCaptureTime = Math.max(this.lastCaptureTime, timestamp.getTime());
    }

    public Date getLastCaptureDate() {
        return new Date(this.lastCaptureTime);
    }

    public StatusHistory getProcessorStatusHistory(final String processorId, Date start, Date end, int preferredDataPoints) {
        final StandardStatusHistory history = new StandardStatusHistory();
        history.setComponentDetail("Id", processorId);
        this.captures.forEach((RingBuffer.ForEachEvaluator)new RingBuffer.ForEachEvaluator<Capture>(){

            public boolean evaluate(Capture capture) {
                ComponentStatusReport statusReport = capture.getStatusReport();
                ProcessorStatus status = statusReport.getProcessorStatus(processorId);
                if (status == null) {
                    return true;
                }
                history.setComponentDetail("Group Id", status.getGroupId());
                history.setComponentDetail("Name", status.getName());
                history.setComponentDetail("Type", status.getType());
                StandardStatusSnapshot snapshot = new StandardStatusSnapshot();
                snapshot.setTimestamp(capture.getCaptureDate());
                for (ProcessorStatusDescriptor descriptor : ProcessorStatusDescriptor.values()) {
                    snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
                }
                history.addStatusSnapshot(snapshot);
                return true;
            }
        });
        return history;
    }

    public StatusHistory getConnectionStatusHistory(final String connectionId, Date start, Date end, int preferredDataPoints) {
        final StandardStatusHistory history = new StandardStatusHistory();
        history.setComponentDetail("Id", connectionId);
        this.captures.forEach((RingBuffer.ForEachEvaluator)new RingBuffer.ForEachEvaluator<Capture>(){

            public boolean evaluate(Capture capture) {
                ComponentStatusReport statusReport = capture.getStatusReport();
                ConnectionStatus status = statusReport.getConnectionStatus(connectionId);
                if (status == null) {
                    return true;
                }
                history.setComponentDetail("Group Id", status.getGroupId());
                history.setComponentDetail("Name", status.getName());
                history.setComponentDetail("Source Name", status.getSourceName());
                history.setComponentDetail("Destination Name", status.getDestinationName());
                StandardStatusSnapshot snapshot = new StandardStatusSnapshot();
                snapshot.setTimestamp(capture.getCaptureDate());
                for (ConnectionStatusDescriptor descriptor : ConnectionStatusDescriptor.values()) {
                    snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
                }
                history.addStatusSnapshot(snapshot);
                return true;
            }
        });
        return history;
    }

    public StatusHistory getProcessGroupStatusHistory(final String processGroupId, Date start, Date end, int preferredDataPoints) {
        final StandardStatusHistory history = new StandardStatusHistory();
        history.setComponentDetail("Id", processGroupId);
        this.captures.forEach((RingBuffer.ForEachEvaluator)new RingBuffer.ForEachEvaluator<Capture>(){

            public boolean evaluate(Capture capture) {
                ComponentStatusReport statusReport = capture.getStatusReport();
                ProcessGroupStatus status = statusReport.getProcessGroupStatus(processGroupId);
                if (status == null) {
                    return true;
                }
                history.setComponentDetail("Name", status.getName());
                StandardStatusSnapshot snapshot = new StandardStatusSnapshot();
                snapshot.setTimestamp(capture.getCaptureDate());
                for (ProcessGroupStatusDescriptor descriptor : ProcessGroupStatusDescriptor.values()) {
                    snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
                }
                history.addStatusSnapshot(snapshot);
                return true;
            }
        });
        return history;
    }

    public StatusHistory getRemoteProcessGroupStatusHistory(final String remoteGroupId, Date start, Date end, int preferredDataPoints) {
        final StandardStatusHistory history = new StandardStatusHistory();
        history.setComponentDetail("Id", remoteGroupId);
        this.captures.forEach((RingBuffer.ForEachEvaluator)new RingBuffer.ForEachEvaluator<Capture>(){

            public boolean evaluate(Capture capture) {
                ComponentStatusReport statusReport = capture.getStatusReport();
                RemoteProcessGroupStatus status = statusReport.getRemoteProcessGroupStatus(remoteGroupId);
                if (status == null) {
                    return true;
                }
                history.setComponentDetail("Group Id", status.getGroupId());
                history.setComponentDetail("Name", status.getName());
                history.setComponentDetail("Uri", status.getTargetUri());
                StandardStatusSnapshot snapshot = new StandardStatusSnapshot();
                snapshot.setTimestamp(capture.getCaptureDate());
                for (RemoteProcessGroupStatusDescriptor descriptor : RemoteProcessGroupStatusDescriptor.values()) {
                    snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
                }
                history.addStatusSnapshot(snapshot);
                return true;
            }
        });
        return history;
    }

    private static class Capture {
        private final Date captureDate;
        private final ComponentStatusReport statusReport;

        public Capture(Date date, ComponentStatusReport statusReport) {
            this.captureDate = date;
            this.statusReport = statusReport;
        }

        public Date getCaptureDate() {
            return this.captureDate;
        }

        public ComponentStatusReport getStatusReport() {
            return this.statusReport;
        }
    }
}

