/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.swap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.controller.repository.schema.ContentClaimSchema;
import org.apache.nifi.controller.repository.schema.FlowFileSchema;
import org.apache.nifi.repository.schema.ComplexRecordField;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.MapRecordField;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SimpleRecordField;

public class SwapSchema {
    public static final RecordSchema SWAP_SUMMARY_SCHEMA_V1;
    public static final RecordSchema SWAP_CONTENTS_SCHEMA_V1;
    public static final RecordSchema FULL_SWAP_FILE_SCHEMA_V1;
    public static final String RESOURCE_CLAIMS = "Resource Claims";
    public static final String RESOURCE_CLAIM = "Resource Claim";
    public static final String RESOURCE_CLAIM_COUNT = "Claim Count";
    public static final String QUEUE_IDENTIFIER = "Queue Identifier";
    public static final String FLOWFILE_COUNT = "FlowFile Count";
    public static final String FLOWFILE_SIZE = "FlowFile Size";
    public static final String MAX_RECORD_ID = "Max Record ID";
    public static final String SWAP_SUMMARY = "Swap Summary";
    public static final String FLOWFILE_CONTENTS = "FlowFiles";

    static {
        SimpleRecordField queueIdentifier = new SimpleRecordField(QUEUE_IDENTIFIER, FieldType.STRING, Repetition.EXACTLY_ONE);
        SimpleRecordField flowFileCount = new SimpleRecordField(FLOWFILE_COUNT, FieldType.INT, Repetition.EXACTLY_ONE);
        SimpleRecordField flowFileSize = new SimpleRecordField(FLOWFILE_SIZE, FieldType.LONG, Repetition.EXACTLY_ONE);
        SimpleRecordField maxRecordId = new SimpleRecordField(MAX_RECORD_ID, FieldType.LONG, Repetition.EXACTLY_ONE);
        ComplexRecordField resourceClaimField = new ComplexRecordField(RESOURCE_CLAIM, Repetition.EXACTLY_ONE, ContentClaimSchema.RESOURCE_CLAIM_SCHEMA_V1.getFields());
        SimpleRecordField claimCountField = new SimpleRecordField(RESOURCE_CLAIM_COUNT, FieldType.INT, Repetition.EXACTLY_ONE);
        MapRecordField resourceClaims = new MapRecordField(RESOURCE_CLAIMS, (RecordField)resourceClaimField, (RecordField)claimCountField, Repetition.EXACTLY_ONE);
        ArrayList<Object> summaryFields = new ArrayList<Object>();
        summaryFields.add(queueIdentifier);
        summaryFields.add(flowFileCount);
        summaryFields.add(flowFileSize);
        summaryFields.add(maxRecordId);
        summaryFields.add(resourceClaims);
        SWAP_SUMMARY_SCHEMA_V1 = new RecordSchema(summaryFields);
        ComplexRecordField flowFiles = new ComplexRecordField(FLOWFILE_CONTENTS, Repetition.ZERO_OR_MORE, FlowFileSchema.FLOWFILE_SCHEMA_V1.getFields());
        List<ComplexRecordField> contentsFields = Collections.singletonList(flowFiles);
        SWAP_CONTENTS_SCHEMA_V1 = new RecordSchema(contentsFields);
        ArrayList<ComplexRecordField> fullSchemaFields = new ArrayList<ComplexRecordField>();
        fullSchemaFields.add(new ComplexRecordField(SWAP_SUMMARY, Repetition.EXACTLY_ONE, summaryFields));
        fullSchemaFields.add(new ComplexRecordField(FLOWFILE_CONTENTS, Repetition.ZERO_OR_MORE, FlowFileSchema.FLOWFILE_SCHEMA_V1.getFields()));
        FULL_SWAP_FILE_SCHEMA_V1 = new RecordSchema(fullSchemaFields);
    }
}

