/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.CommunicationsException;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RemoteNiFiUtils;
import org.apache.nifi.remote.StandardRemoteGroupPort;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.protocol.http.HttpProxy;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRemoteProcessGroup
implements RemoteProcessGroup {
    private static final Logger logger = LoggerFactory.getLogger(StandardRemoteProcessGroup.class);
    private static final int UNAUTHORIZED_STATUS_CODE = ClientResponse.Status.UNAUTHORIZED.getStatusCode();
    private static final int FORBIDDEN_STATUS_CODE = ClientResponse.Status.FORBIDDEN.getStatusCode();
    private final String id;
    private final URI targetUri;
    private final URI apiUri;
    private final String host;
    private final String protocol;
    private final ProcessScheduler scheduler;
    private final EventReporter eventReporter;
    private final NiFiProperties nifiProperties;
    private final AtomicReference<String> name = new AtomicReference();
    private final AtomicReference<Position> position = new AtomicReference();
    private final AtomicReference<String> comments = new AtomicReference();
    private final AtomicReference<ProcessGroup> processGroup;
    private final AtomicBoolean transmitting = new AtomicBoolean(false);
    private final FlowController flowController;
    private final SSLContext sslContext;
    private volatile String communicationsTimeout = "30 sec";
    private volatile String targetId;
    private volatile String yieldDuration = "10 sec";
    private volatile SiteToSiteTransportProtocol transportProtocol = SiteToSiteTransportProtocol.RAW;
    private volatile String proxyHost;
    private volatile Integer proxyPort;
    private volatile String proxyUser;
    private volatile String proxyPassword;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Map<String, StandardRemoteGroupPort> inputPorts = new HashMap<String, StandardRemoteGroupPort>();
    private final Map<String, StandardRemoteGroupPort> outputPorts = new HashMap<String, StandardRemoteGroupPort>();
    private ProcessGroupCounts counts = new ProcessGroupCounts(0, 0, 0, 0, 0, 0, 0, 0);
    private Long refreshContentsTimestamp = null;
    private Boolean destinationSecure;
    private Integer listeningPort;
    private Integer listeningHttpPort;
    private volatile String authorizationIssue;
    private final ScheduledExecutorService backgroundThreadExecutor;

    public StandardRemoteProcessGroup(String id, String targetUri, ProcessGroup processGroup, FlowController flowController, SSLContext sslContext, NiFiProperties nifiProperties) {
        URI uri;
        this.nifiProperties = nifiProperties;
        this.id = Objects.requireNonNull(id);
        this.flowController = Objects.requireNonNull(flowController);
        try {
            uri = new URI(Objects.requireNonNull(targetUri.trim()));
            String apiPath = SiteToSiteRestApiClient.resolveBaseUrl((URI)uri);
            this.apiUri = new URI(apiPath);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.host = uri.getHost();
        this.protocol = uri.getAuthority();
        this.targetUri = uri;
        this.targetId = null;
        this.processGroup = new AtomicReference<ProcessGroup>(processGroup);
        this.sslContext = sslContext;
        this.scheduler = flowController.getProcessScheduler();
        this.authorizationIssue = "Establishing connection to " + targetUri;
        final BulletinRepository bulletinRepository = flowController.getBulletinRepository();
        this.eventReporter = new EventReporter(){
            private static final long serialVersionUID = 1L;

            public void reportEvent(Severity severity, String category, String message) {
                String groupId = StandardRemoteProcessGroup.this.getProcessGroup().getIdentifier();
                String sourceId = StandardRemoteProcessGroup.this.getIdentifier();
                String sourceName = StandardRemoteProcessGroup.this.getName();
                bulletinRepository.addBulletin(BulletinFactory.createBulletin((String)groupId, (String)sourceId, (ComponentType)ComponentType.REMOTE_PROCESS_GROUP, (String)sourceName, (String)category, (String)severity.name(), (String)message));
            }
        };
        InitializationTask checkAuthorizations = new InitializationTask();
        this.backgroundThreadExecutor = new FlowEngine(1, "Remote Process Group " + id + ": " + targetUri);
        this.backgroundThreadExecutor.scheduleWithFixedDelay(checkAuthorizations, 5L, 30L, TimeUnit.SECONDS);
    }

    public void reinitialize(boolean isClustered) {
        this.backgroundThreadExecutor.submit(new InitializationTask());
    }

    public void onRemove() {
        this.backgroundThreadExecutor.shutdown();
        File file = this.getPeerPersistenceFile();
        if (file.exists() && !file.delete()) {
            logger.warn("Failed to remove {}. This file should be removed manually.", (Object)file);
        }
    }

    public void shutdown() {
        this.backgroundThreadExecutor.shutdown();
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.RemoteProcessGroup, (String)this.getIdentifier(), (String)this.getName());
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    public void setProcessGroup(ProcessGroup group) {
        this.processGroup.set(group);
        for (RemoteGroupPort port : this.getInputPorts()) {
            port.setProcessGroup(group);
        }
        for (RemoteGroupPort port : this.getOutputPorts()) {
            port.setProcessGroup(group);
        }
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setTransportProtocol(SiteToSiteTransportProtocol transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public SiteToSiteTransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getName() {
        String name = this.name.get();
        return name == null ? this.targetUri.toString() : name;
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public String getCommunicationsTimeout() {
        return this.communicationsTimeout;
    }

    public void setCommunicationsTimeout(String timePeriod) throws IllegalArgumentException {
        try {
            long millis = FormatUtils.getTimeDuration((String)timePeriod, (TimeUnit)TimeUnit.MILLISECONDS);
            if (millis <= 0L) {
                throw new IllegalArgumentException("Time Period must be more than 0 milliseconds; Invalid Time Period: " + timePeriod);
            }
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout is too long; cannot be greater than 2147483647 milliseconds");
            }
            this.communicationsTimeout = timePeriod;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Time Period: " + timePeriod);
        }
    }

    public int getCommunicationsTimeout(TimeUnit timeUnit) {
        return (int)FormatUtils.getTimeDuration((String)this.communicationsTimeout, (TimeUnit)timeUnit);
    }

    public String getComments() {
        return this.comments.get();
    }

    public void setComments(String comments) {
        this.comments.set(comments);
    }

    public Position getPosition() {
        return this.position.get();
    }

    public void setPosition(Position position) {
        this.position.set(position);
    }

    public URI getTargetUri() {
        return this.targetUri;
    }

    public String getAuthorizationIssue() {
        return this.authorizationIssue;
    }

    public String getHost() {
        return this.host;
    }

    public int getInputPortCount() {
        this.readLock.lock();
        try {
            int n = this.inputPorts.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getOutputPortCount() {
        this.readLock.lock();
        try {
            int n = this.outputPorts.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsInputPort(String id) {
        this.readLock.lock();
        try {
            boolean bl = this.inputPorts.containsKey(id);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputPorts(Set<RemoteProcessGroupPortDescriptor> ports) {
        this.writeLock.lock();
        try {
            ArrayList<String> newPortIds = new ArrayList<String>();
            for (RemoteProcessGroupPortDescriptor descriptor : ports) {
                newPortIds.add(descriptor.getId());
                if (!this.inputPorts.containsKey(descriptor.getId())) {
                    this.addInputPort(descriptor);
                }
                StandardRemoteGroupPort sendPort = this.inputPorts.get(descriptor.getId());
                sendPort.setTargetExists(true);
                sendPort.setName(descriptor.getName());
                if (descriptor.isTargetRunning() != null) {
                    sendPort.setTargetRunning(descriptor.isTargetRunning().booleanValue());
                }
                sendPort.setComments(descriptor.getComments());
            }
            Iterator<Map.Entry<String, StandardRemoteGroupPort>> itr = this.inputPorts.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, StandardRemoteGroupPort> entry = itr.next();
                if (newPortIds.contains(entry.getKey())) continue;
                StandardRemoteGroupPort port = entry.getValue();
                port.setTargetExists(false);
                port.setTargetRunning(false);
                if (port.hasIncomingConnection()) continue;
                itr.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean containsOutputPort(String id) {
        this.readLock.lock();
        try {
            boolean bl = this.outputPorts.containsKey(id);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputPorts(Set<RemoteProcessGroupPortDescriptor> ports) {
        this.writeLock.lock();
        try {
            ArrayList<String> newPortIds = new ArrayList<String>();
            for (RemoteProcessGroupPortDescriptor descriptor : Objects.requireNonNull(ports)) {
                newPortIds.add(descriptor.getId());
                if (!this.outputPorts.containsKey(descriptor.getId())) {
                    this.addOutputPort(descriptor);
                }
                StandardRemoteGroupPort receivePort = this.outputPorts.get(descriptor.getId());
                receivePort.setTargetExists(true);
                receivePort.setName(descriptor.getName());
                if (descriptor.isTargetRunning() != null) {
                    receivePort.setTargetRunning(descriptor.isTargetRunning().booleanValue());
                }
                receivePort.setComments(descriptor.getComments());
            }
            Iterator<Map.Entry<String, StandardRemoteGroupPort>> itr = this.outputPorts.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, StandardRemoteGroupPort> entry = itr.next();
                if (newPortIds.contains(entry.getKey())) continue;
                StandardRemoteGroupPort port = entry.getValue();
                port.setTargetExists(false);
                port.setTargetRunning(false);
                if (!port.getConnections().isEmpty()) continue;
                itr.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeNonExistentPort(RemoteGroupPort port) {
        this.writeLock.lock();
        try {
            if (Objects.requireNonNull(port).getTargetExists()) {
                throw new IllegalStateException("Cannot remove Remote Port " + port.getIdentifier() + " because it still exists on the Remote Instance");
            }
            if (!port.getConnections().isEmpty() || port.hasIncomingConnection()) {
                throw new IllegalStateException("Cannot remove Remote Port because it is connected to other components");
            }
            this.scheduler.stopPort((Port)port);
            if (this.outputPorts.containsKey(port.getIdentifier())) {
                this.outputPorts.remove(port.getIdentifier());
            } else {
                if (!this.inputPorts.containsKey(port.getIdentifier())) {
                    throw new IllegalStateException("Cannot remove Remote Port because it does not belong to this Remote Process Group");
                }
                this.inputPorts.remove(port.getIdentifier());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNonExistentPorts() {
        this.writeLock.lock();
        try {
            RemoteGroupPort port;
            HashSet<String> inputPortIds = new HashSet<String>();
            HashSet<String> outputPortIds = new HashSet<String>();
            for (Map.Entry<String, StandardRemoteGroupPort> entry : this.inputPorts.entrySet()) {
                port = (RemoteGroupPort)entry.getValue();
                if (port.getTargetExists() || port.hasIncomingConnection()) continue;
                inputPortIds.add(entry.getKey());
            }
            for (Map.Entry<String, StandardRemoteGroupPort> entry : this.outputPorts.entrySet()) {
                port = (RemoteGroupPort)entry.getValue();
                if (port.getTargetExists() || !port.getConnections().isEmpty()) continue;
                outputPortIds.add(entry.getKey());
            }
            for (String id : inputPortIds) {
                this.inputPorts.remove(id);
            }
            for (String id : outputPortIds) {
                this.outputPorts.remove(id);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addOutputPort(RemoteProcessGroupPortDescriptor descriptor) {
        this.writeLock.lock();
        try {
            if (this.outputPorts.containsKey(Objects.requireNonNull(descriptor).getId())) {
                throw new IllegalStateException("Output Port with ID " + descriptor.getId() + " already exists");
            }
            StandardRemoteGroupPort port = new StandardRemoteGroupPort(descriptor.getId(), descriptor.getName(), this.getProcessGroup(), (RemoteProcessGroup)this, TransferDirection.RECEIVE, ConnectableType.REMOTE_OUTPUT_PORT, this.sslContext, this.scheduler, this.nifiProperties);
            this.outputPorts.put(descriptor.getId(), port);
            if (descriptor.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(descriptor.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (descriptor.getUseCompression() != null) {
                port.setUseCompression(descriptor.getUseCompression().booleanValue());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public RemoteGroupPort getInputPort(String portIdentifier) {
        this.readLock.lock();
        try {
            if (Objects.requireNonNull(portIdentifier).startsWith(this.id + "-")) {
                RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.inputPorts.get(portIdentifier.substring(this.id.length() + 1));
                return remoteGroupPort;
            }
            RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.inputPorts.get(portIdentifier);
            return remoteGroupPort;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<RemoteGroupPort> getInputPorts() {
        this.readLock.lock();
        try {
            HashSet<RemoteGroupPort> set = new HashSet<RemoteGroupPort>();
            set.addAll(this.inputPorts.values());
            HashSet<RemoteGroupPort> hashSet = set;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addInputPort(RemoteProcessGroupPortDescriptor descriptor) {
        this.writeLock.lock();
        try {
            if (this.inputPorts.containsKey(descriptor.getId())) {
                throw new IllegalStateException("Input Port with ID " + descriptor.getId() + " already exists");
            }
            StandardRemoteGroupPort port = new StandardRemoteGroupPort(descriptor.getId(), descriptor.getName(), this.getProcessGroup(), (RemoteProcessGroup)this, TransferDirection.SEND, ConnectableType.REMOTE_INPUT_PORT, this.sslContext, this.scheduler, this.nifiProperties);
            if (descriptor.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(descriptor.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (descriptor.getUseCompression() != null) {
                port.setUseCompression(descriptor.getUseCompression().booleanValue());
            }
            this.inputPorts.put(descriptor.getId(), port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public RemoteGroupPort getOutputPort(String portIdentifier) {
        this.readLock.lock();
        try {
            if (Objects.requireNonNull(portIdentifier).startsWith(this.id + "-")) {
                RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.outputPorts.get(portIdentifier.substring(this.id.length() + 1));
                return remoteGroupPort;
            }
            RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.outputPorts.get(portIdentifier);
            return remoteGroupPort;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<RemoteGroupPort> getOutputPorts() {
        this.readLock.lock();
        try {
            HashSet<RemoteGroupPort> set = new HashSet<RemoteGroupPort>();
            set.addAll(this.outputPorts.values());
            HashSet<RemoteGroupPort> hashSet = set;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return "RemoteProcessGroup[" + this.targetUri + "]";
    }

    public ProcessGroupCounts getCounts() {
        this.readLock.lock();
        try {
            ProcessGroupCounts processGroupCounts = this.counts;
            return processGroupCounts;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setCounts(ProcessGroupCounts counts) {
        this.writeLock.lock();
        try {
            this.counts = counts;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private ProcessGroup getRootGroup() {
        return this.getRootGroup(this.getProcessGroup());
    }

    private ProcessGroup getRootGroup(ProcessGroup context) {
        ProcessGroup parent = context.getParent();
        return parent == null ? context : this.getRootGroup(parent);
    }

    public Date getLastRefreshTime() {
        this.readLock.lock();
        try {
            Date date = this.refreshContentsTimestamp == null ? null : new Date(this.refreshContentsTimestamp);
            return date;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFlowContents() throws CommunicationsException {
        try {
            ControllerDTO dto;
            try (SiteToSiteRestApiClient apiClient = this.getSiteToSiteRestApiClient();){
                dto = apiClient.getController();
            }
            catch (IOException e) {
                this.writeLock.lock();
                try {
                    Iterator<StandardRemoteGroupPort> iter = this.inputPorts.values().iterator();
                    while (iter.hasNext()) {
                        StandardRemoteGroupPort inputPort = iter.next();
                        if (inputPort.hasIncomingConnection()) continue;
                        iter.remove();
                    }
                    iter = this.outputPorts.values().iterator();
                    while (iter.hasNext()) {
                        StandardRemoteGroupPort outputPort = iter.next();
                        if (!outputPort.getConnections().isEmpty()) continue;
                        iter.remove();
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
                throw new CommunicationsException("Unable to communicate with Remote NiFi at URI " + this.getApiUri() + " due to: " + e.getMessage());
            }
            this.writeLock.lock();
            try {
                if (dto.getInputPorts() != null) {
                    this.setInputPorts(this.convertRemotePort(dto.getInputPorts()));
                }
                if (dto.getOutputPorts() != null) {
                    this.setOutputPorts(this.convertRemotePort(dto.getOutputPorts()));
                }
                this.setTargetId(dto.getId());
                this.setName(dto.getName());
                this.setComments(dto.getComments());
                int inputPortCount = 0;
                if (dto.getInputPortCount() != null) {
                    inputPortCount = dto.getInputPortCount();
                }
                int outputPortCount = 0;
                if (dto.getOutputPortCount() != null) {
                    outputPortCount = dto.getOutputPortCount();
                }
                int runningCount = 0;
                if (dto.getRunningCount() != null) {
                    runningCount = dto.getRunningCount();
                }
                int stoppedCount = 0;
                if (dto.getStoppedCount() != null) {
                    stoppedCount = dto.getStoppedCount();
                }
                int invalidCount = 0;
                if (dto.getInvalidCount() != null) {
                    invalidCount = dto.getInvalidCount();
                }
                int disabledCount = 0;
                if (dto.getDisabledCount() != null) {
                    disabledCount = dto.getDisabledCount();
                }
                int activeRemotePortCount = 0;
                if (dto.getActiveRemotePortCount() != null) {
                    activeRemotePortCount = dto.getActiveRemotePortCount();
                }
                int inactiveRemotePortCount = 0;
                if (dto.getInactiveRemotePortCount() != null) {
                    inactiveRemotePortCount = dto.getInactiveRemotePortCount();
                }
                this.listeningPort = dto.getRemoteSiteListeningPort();
                this.listeningHttpPort = dto.getRemoteSiteHttpListeningPort();
                this.destinationSecure = dto.isSiteToSiteSecure();
                ProcessGroupCounts newCounts = new ProcessGroupCounts(inputPortCount, outputPortCount, runningCount, stoppedCount, invalidCount, disabledCount, activeRemotePortCount, inactiveRemotePortCount);
                this.setCounts(newCounts);
                this.refreshContentsTimestamp = System.currentTimeMillis();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (ClientHandlerException | UniformInterfaceException e) {
            throw new CommunicationsException(e);
        }
    }

    private SiteToSiteRestApiClient getSiteToSiteRestApiClient() {
        SiteToSiteRestApiClient apiClient = new SiteToSiteRestApiClient(this.sslContext, new HttpProxy(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword), this.getEventReporter());
        apiClient.setBaseUrl(this.getApiUri());
        apiClient.setConnectTimeoutMillis(this.getCommunicationsTimeout(TimeUnit.MILLISECONDS));
        apiClient.setReadTimeoutMillis(this.getCommunicationsTimeout(TimeUnit.MILLISECONDS));
        return apiClient;
    }

    protected String getApiUri() {
        return this.apiUri.toString();
    }

    private Set<RemoteProcessGroupPortDescriptor> convertRemotePort(Set<PortDTO> ports) {
        LinkedHashSet<StandardRemoteProcessGroupPortDescriptor> remotePorts = null;
        if (ports != null) {
            remotePorts = new LinkedHashSet<StandardRemoteProcessGroupPortDescriptor>(ports.size());
            for (PortDTO port : ports) {
                StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
                ScheduledState scheduledState = ScheduledState.valueOf((String)port.getState());
                descriptor.setId(port.getId());
                descriptor.setName(port.getName());
                descriptor.setComments(port.getComments());
                descriptor.setTargetRunning(ScheduledState.RUNNING.equals((Object)scheduledState));
                remotePorts.add(descriptor);
            }
        }
        return remotePorts;
    }

    private RemoteProcessGroupPortDescriptor convertPortToRemotePortDescriptor(Port port) {
        StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
        descriptor.setComments(port.getComments());
        descriptor.setExists(true);
        descriptor.setGroupId(port.getProcessGroup().getIdentifier());
        descriptor.setId(port.getIdentifier());
        descriptor.setName(port.getName());
        descriptor.setTargetRunning(port.isRunning());
        return descriptor;
    }

    public boolean isTransmitting() {
        return this.transmitting.get();
    }

    public void startTransmitting() {
        this.writeLock.lock();
        try {
            this.verifyCanStartTransmitting();
            for (Port port : this.getInputPorts()) {
                if (!port.isValid() || !port.hasIncomingConnection()) continue;
                this.scheduler.startPort(port);
            }
            for (Port port : this.getOutputPorts()) {
                if (!port.isValid() || port.getConnections().isEmpty()) continue;
                this.scheduler.startPort(port);
            }
            this.transmitting.set(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void startTransmitting(RemoteGroupPort port) {
        this.writeLock.lock();
        try {
            if (!this.inputPorts.containsValue(port) && !this.outputPorts.containsValue(port)) {
                throw new IllegalArgumentException("Port does not belong to this Remote Process Group");
            }
            port.verifyCanStart();
            this.scheduler.startPort((Port)port);
            this.transmitting.set(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTransmitting() {
        this.writeLock.lock();
        try {
            this.verifyCanStopTransmitting();
            for (RemoteGroupPort port : this.getInputPorts()) {
                this.scheduler.stopPort((Port)port);
            }
            for (RemoteGroupPort port : this.getOutputPorts()) {
                this.scheduler.stopPort((Port)port);
            }
            for (RemoteGroupPort port : this.getInputPorts()) {
                while (port.isRunning()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            for (RemoteGroupPort port : this.getOutputPorts()) {
                while (port.isRunning()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.transmitting.set(false);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTransmitting(RemoteGroupPort port) {
        this.writeLock.lock();
        try {
            if (!this.inputPorts.containsValue(port) && !this.outputPorts.containsValue(port)) {
                throw new IllegalArgumentException("Port does not belong to this Remote Process Group");
            }
            port.verifyCanStop();
            this.scheduler.stopPort((Port)port);
            while (port.isRunning()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean stillTransmitting = false;
            for (Port port2 : this.getInputPorts()) {
                if (!port2.isRunning()) continue;
                stillTransmitting = true;
                break;
            }
            if (!stillTransmitting) {
                for (Port port3 : this.getOutputPorts()) {
                    if (!port3.isRunning()) continue;
                    stillTransmitting = true;
                    break;
                }
            }
            this.transmitting.set(stillTransmitting);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecure() throws CommunicationsException {
        Boolean secure;
        this.readLock.lock();
        try {
            secure = this.destinationSecure;
            if (secure != null) {
                boolean bl = secure;
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.refreshFlowContents();
        this.readLock.lock();
        try {
            secure = this.destinationSecure;
            if (secure == null) {
                throw new CommunicationsException("Unable to determine whether or not site-to-site communications with peer should be secure");
            }
            boolean bl = secure;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Boolean getSecureFlag() {
        this.readLock.lock();
        try {
            Boolean bl = this.destinationSecure;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isWebApiSecure() {
        return this.targetUri.toString().toLowerCase().startsWith("https");
    }

    public boolean isSiteToSiteEnabled() {
        this.readLock.lock();
        try {
            boolean bl = this.listeningPort != null || this.listeningHttpPort != null;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public EventReporter getEventReporter() {
        return this.eventReporter;
    }

    public void setYieldDuration(String yieldDuration) {
        if (!FormatUtils.TIME_DURATION_PATTERN.matcher(yieldDuration).matches()) {
            throw new IllegalArgumentException("Improperly formatted Time Period; should be of syntax <number> <unit> where <number> is a positive integer and unit is one of the valid Time Units, such as nanos, millis, sec, min, hour, day");
        }
        this.yieldDuration = yieldDuration;
    }

    public String getYieldDuration() {
        return this.yieldDuration;
    }

    public void verifyCanDelete() {
        this.verifyCanDelete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(boolean ignoreConnections) {
        this.readLock.lock();
        try {
            if (this.isTransmitting()) {
                throw new IllegalStateException(this.getIdentifier() + " is transmitting");
            }
            for (Port port : this.inputPorts.values()) {
                if (!ignoreConnections && port.hasIncomingConnection()) {
                    throw new IllegalStateException(this.getIdentifier() + " is the destination of another component");
                }
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
            for (Port port : this.outputPorts.values()) {
                if (!ignoreConnections) {
                    for (Connection connection : port.getConnections()) {
                        connection.verifyCanDelete();
                    }
                }
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStartTransmitting() {
        this.readLock.lock();
        try {
            if (this.isTransmitting()) {
                throw new IllegalStateException(this.getIdentifier() + " is already transmitting");
            }
            for (StandardRemoteGroupPort port : this.inputPorts.values()) {
                if (port.isRunning()) {
                    throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
                }
                if (!port.hasIncomingConnection() || port.getTargetExists()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has a Connection to Port " + port.getIdentifier() + ", but that Port no longer exists on the remote system");
            }
            for (StandardRemoteGroupPort port : this.outputPorts.values()) {
                if (port.isRunning()) {
                    throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
                }
                if (port.getConnections().isEmpty() || port.getTargetExists()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has a Connection to Port " + port.getIdentifier() + ", but that Port no longer exists on the remote system");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStopTransmitting() {
        if (!this.isTransmitting()) {
            throw new IllegalStateException(this.getIdentifier() + " is not transmitting");
        }
    }

    public void verifyCanUpdate() {
        this.readLock.lock();
        try {
            if (this.isTransmitting()) {
                throw new IllegalStateException(this.getIdentifier() + " is currently transmitting");
            }
            for (Port port : this.inputPorts.values()) {
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
            for (Port port : this.outputPorts.values()) {
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private File getPeerPersistenceFile() {
        File stateDir = this.nifiProperties.getPersistentStateDirectory();
        return new File(stateDir, this.getIdentifier() + ".peers");
    }

    private class InitializationTask
    implements Runnable {
        private InitializationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block29: {
                try (SiteToSiteRestApiClient apiClient = StandardRemoteProcessGroup.this.getSiteToSiteRestApiClient();){
                    try {
                        ControllerDTO dto = apiClient.getController();
                        if (dto.getRemoteSiteListeningPort() == null && SiteToSiteTransportProtocol.RAW.equals((Object)StandardRemoteProcessGroup.this.transportProtocol)) {
                            StandardRemoteProcessGroup.this.authorizationIssue = "Remote instance is not configured to allow RAW Site-to-Site communications at this time.";
                        } else if (dto.getRemoteSiteHttpListeningPort() == null && SiteToSiteTransportProtocol.HTTP.equals((Object)StandardRemoteProcessGroup.this.transportProtocol)) {
                            StandardRemoteProcessGroup.this.authorizationIssue = "Remote instance is not configured to allow HTTP Site-to-Site communications at this time.";
                        } else {
                            StandardRemoteProcessGroup.this.authorizationIssue = null;
                        }
                        StandardRemoteProcessGroup.this.writeLock.lock();
                        try {
                            StandardRemoteProcessGroup.this.listeningPort = dto.getRemoteSiteListeningPort();
                            StandardRemoteProcessGroup.this.listeningHttpPort = dto.getRemoteSiteHttpListeningPort();
                            StandardRemoteProcessGroup.this.destinationSecure = dto.isSiteToSiteSecure();
                        }
                        finally {
                            StandardRemoteProcessGroup.this.writeLock.unlock();
                        }
                    }
                    catch (SiteToSiteRestApiClient.HttpGetFailedException e) {
                        if (e.getResponseCode() == UNAUTHORIZED_STATUS_CODE) {
                            block30: {
                                try {
                                    RemoteNiFiUtils utils = new RemoteNiFiUtils(StandardRemoteProcessGroup.this.isWebApiSecure() ? StandardRemoteProcessGroup.this.sslContext : null);
                                    ClientResponse requestAccountResponse = utils.issueRegistrationRequest(StandardRemoteProcessGroup.this.apiUri.toString());
                                    if (Response.Status.Family.SUCCESSFUL.equals((Object)requestAccountResponse.getStatusInfo().getFamily())) {
                                        logger.info("{} Issued a Request to communicate with remote instance", (Object)this);
                                    } else {
                                        logger.error("{} Failed to request account: got unexpected response code of {}:{}", new Object[]{this, requestAccountResponse.getStatus(), requestAccountResponse.getStatusInfo().getReasonPhrase()});
                                    }
                                }
                                catch (Exception re) {
                                    logger.error("{} Failed to request account due to {}", (Object)this, (Object)re.toString());
                                    if (!logger.isDebugEnabled()) break block30;
                                    logger.error("", (Throwable)re);
                                }
                            }
                            StandardRemoteProcessGroup.this.authorizationIssue = e.getDescription();
                            break block29;
                        }
                        if (e.getResponseCode() == FORBIDDEN_STATUS_CODE) {
                            StandardRemoteProcessGroup.this.authorizationIssue = e.getDescription();
                            break block29;
                        }
                        String message = e.getDescription();
                        logger.warn("{} When communicating with remote instance, got unexpected result. {}", new Object[]{this, message});
                        StandardRemoteProcessGroup.this.authorizationIssue = "Unable to determine Site-to-Site availability.";
                    }
                }
                catch (Exception e) {
                    logger.warn(String.format("Unable to connect to %s due to %s", StandardRemoteProcessGroup.this, e));
                    StandardRemoteProcessGroup.this.getEventReporter().reportEvent(Severity.WARNING, "Site to Site", String.format("Unable to connect to %s due to %s", StandardRemoteProcessGroup.this.getTargetUri().toString(), e));
                }
            }
        }
    }
}

