/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractConfiguredComponent;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;

public abstract class AbstractReportingTaskNode
extends AbstractConfiguredComponent
implements ReportingTaskNode {
    private final ReportingTask reportingTask;
    private final ProcessScheduler processScheduler;
    private final ControllerServiceLookup serviceLookup;
    private final AtomicReference<SchedulingStrategy> schedulingStrategy = new AtomicReference<SchedulingStrategy>(SchedulingStrategy.TIMER_DRIVEN);
    private final AtomicReference<String> schedulingPeriod = new AtomicReference<String>("5 mins");
    private volatile String comment;
    private volatile ScheduledState scheduledState = ScheduledState.STOPPED;

    public AbstractReportingTaskNode(ReportingTask reportingTask, String id, ControllerServiceProvider controllerServiceProvider, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, VariableRegistry variableRegistry, ComponentLog logger) {
        this(reportingTask, id, controllerServiceProvider, processScheduler, validationContextFactory, reportingTask.getClass().getSimpleName(), reportingTask.getClass().getCanonicalName(), variableRegistry, logger);
    }

    public AbstractReportingTaskNode(ReportingTask reportingTask, String id, ControllerServiceProvider controllerServiceProvider, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, String componentType, String componentCanonicalClass, VariableRegistry variableRegistry, ComponentLog logger) {
        super((ConfigurableComponent)reportingTask, id, validationContextFactory, controllerServiceProvider, componentType, componentCanonicalClass, variableRegistry, logger);
        this.reportingTask = reportingTask;
        this.processScheduler = processScheduler;
        this.serviceLookup = controllerServiceProvider;
    }

    public void setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy.set(schedulingStrategy);
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return this.schedulingStrategy.get();
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.schedulingPeriod.get(), (TimeUnit)timeUnit);
    }

    public void setSchedulingPeriod(String schedulingPeriod) {
        this.schedulingPeriod.set(schedulingPeriod);
    }

    public ReportingTask getReportingTask() {
        return this.reportingTask;
    }

    public boolean isRunning() {
        return this.processScheduler.isScheduled((Object)this) || this.processScheduler.getActiveThreadCount((Object)this) > 0;
    }

    public int getActiveThreadCount() {
        return this.processScheduler.getActiveThreadCount((Object)this);
    }

    public ConfigurationContext getConfigurationContext() {
        return new StandardConfigurationContext((ConfiguredComponent)this, this.serviceLookup, this.getSchedulingPeriod(), this.getVariableRegistry());
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Reporting Task while the Reporting Task is running");
        }
    }

    public ScheduledState getScheduledState() {
        return this.scheduledState;
    }

    public void setScheduledState(ScheduledState state) {
        this.scheduledState = state;
    }

    public boolean isDisabled() {
        return this.scheduledState == ScheduledState.DISABLED;
    }

    public String getComments() {
        return this.comment;
    }

    public void setComments(String comment) {
        this.comment = comment;
    }

    public void verifyCanDelete() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot delete " + this.reportingTask.getIdentifier() + " because it is currently running");
        }
    }

    public void verifyCanDisable() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot disable " + this.reportingTask.getIdentifier() + " because it is currently running");
        }
        if (this.isDisabled()) {
            throw new IllegalStateException("Cannot disable " + this.reportingTask.getIdentifier() + " because it is already disabled");
        }
    }

    public void verifyCanEnable() {
        if (!this.isDisabled()) {
            throw new IllegalStateException("Cannot enable " + this.reportingTask.getIdentifier() + " because it is not disabled");
        }
    }

    public void verifyCanStart() {
        if (this.isDisabled()) {
            throw new IllegalStateException("Cannot start " + this.reportingTask.getIdentifier() + " because it is currently disabled");
        }
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot start " + this.reportingTask.getIdentifier() + " because it is already running");
        }
    }

    public void verifyCanStop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot stop " + this.reportingTask.getIdentifier() + " because it is not running");
        }
    }

    public void verifyCanUpdate() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot update " + this.reportingTask.getIdentifier() + " because it is currently running");
        }
    }

    public void verifyCanClearState() {
        this.verifyCanUpdate();
    }

    public void verifyCanStart(Set<ControllerServiceNode> ignoredReferences) {
        switch (this.getScheduledState()) {
            case DISABLED: {
                throw new IllegalStateException(this.getIdentifier() + " cannot be started because it is disabled");
            }
            case RUNNING: {
                throw new IllegalStateException(this.getIdentifier() + " cannot be started because it is already running");
            }
        }
        int activeThreadCount = this.getActiveThreadCount();
        if (activeThreadCount > 0) {
            throw new IllegalStateException(this.getIdentifier() + " cannot be started because it has " + activeThreadCount + " active threads already");
        }
        HashSet<String> ids = new HashSet<String>();
        for (ControllerServiceNode node : ignoredReferences) {
            ids.add(node.getIdentifier());
        }
        Collection<ValidationResult> validationResults = this.getValidationErrors(ids);
        for (ValidationResult result : validationResults) {
            if (result.isValid()) continue;
            throw new IllegalStateException(this.getIdentifier() + " cannot be started because it is not valid: " + result);
        }
    }

    public String toString() {
        return "ReportingTask[id=" + this.getIdentifier() + "]";
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    public Collection<ValidationResult> getValidationErrors(Set<String> serviceIdentifiersNotToValidate) {
        Collection<Object> results = null;
        if (this.getScheduledState() == ScheduledState.STOPPED) {
            results = super.getValidationErrors(serviceIdentifiersNotToValidate);
        }
        return results != null ? results : Collections.emptySet();
    }
}

