/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Map;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.wali.SerDe;
import org.wali.UpdateType;

public abstract class RepositoryRecordSerde
implements SerDe<RepositoryRecord> {
    private Map<String, FlowFileQueue> flowFileQueueMap = null;

    protected void setQueueMap(Map<String, FlowFileQueue> queueMap) {
        this.flowFileQueueMap = queueMap;
    }

    protected Map<String, FlowFileQueue> getQueueMap() {
        return this.flowFileQueueMap;
    }

    protected FlowFileQueue getFlowFileQueue(String queueId) {
        return this.flowFileQueueMap.get(queueId);
    }

    public Long getRecordIdentifier(RepositoryRecord record) {
        return record.getCurrent().getId();
    }

    public UpdateType getUpdateType(RepositoryRecord record) {
        switch (record.getType()) {
            case CONTENTMISSING: 
            case DELETE: {
                return UpdateType.DELETE;
            }
            case CREATE: {
                return UpdateType.CREATE;
            }
            case UPDATE: {
                return UpdateType.UPDATE;
            }
            case SWAP_OUT: {
                return UpdateType.SWAP_OUT;
            }
            case SWAP_IN: {
                return UpdateType.SWAP_IN;
            }
        }
        return null;
    }

    public String getLocation(RepositoryRecord record) {
        return record.getSwapLocation();
    }
}

