/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Map;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.SchemaRepositoryRecordSerde;
import org.apache.nifi.controller.repository.WriteAheadRepositoryRecordSerde;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.wali.SerDe;
import org.wali.SerDeFactory;
import org.wali.UpdateType;

public class RepositoryRecordSerdeFactory
implements SerDeFactory<RepositoryRecord> {
    private final String LEGACY_SERDE_ENCODING_NAME = "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository$WriteAheadRecordSerde";
    private final ResourceClaimManager resourceClaimManager;
    private Map<String, FlowFileQueue> flowFileQueueMap = null;

    public RepositoryRecordSerdeFactory(ResourceClaimManager claimManager) {
        this.resourceClaimManager = claimManager;
    }

    protected void setQueueMap(Map<String, FlowFileQueue> queueMap) {
        this.flowFileQueueMap = queueMap;
    }

    protected Map<String, FlowFileQueue> getQueueMap() {
        return this.flowFileQueueMap;
    }

    public SerDe<RepositoryRecord> createSerDe(String encodingName) {
        if (encodingName == null || SchemaRepositoryRecordSerde.class.getName().equals(encodingName)) {
            SchemaRepositoryRecordSerde serde = new SchemaRepositoryRecordSerde(this.resourceClaimManager);
            serde.setQueueMap(this.flowFileQueueMap);
            return serde;
        }
        if (WriteAheadRepositoryRecordSerde.class.getName().equals(encodingName) || "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository$WriteAheadRecordSerde".equals(encodingName)) {
            WriteAheadRepositoryRecordSerde serde = new WriteAheadRepositoryRecordSerde(this.resourceClaimManager);
            serde.setQueueMap(this.flowFileQueueMap);
            return serde;
        }
        throw new IllegalArgumentException("Cannot create Deserializer for Repository Records because the encoding '" + encodingName + "' is not known");
    }

    protected FlowFileQueue getFlowFileQueue(String queueId) {
        return this.flowFileQueueMap.get(queueId);
    }

    public Long getRecordIdentifier(RepositoryRecord record) {
        return record.getCurrent().getId();
    }

    public UpdateType getUpdateType(RepositoryRecord record) {
        switch (record.getType()) {
            case CONTENTMISSING: 
            case DELETE: {
                return UpdateType.DELETE;
            }
            case CREATE: {
                return UpdateType.CREATE;
            }
            case UPDATE: {
                return UpdateType.UPDATE;
            }
            case SWAP_OUT: {
                return UpdateType.SWAP_OUT;
            }
            case SWAP_IN: {
                return UpdateType.SWAP_IN;
            }
        }
        return null;
    }

    public String getLocation(RepositoryRecord record) {
        return record.getSwapLocation();
    }
}

