/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import java.util.List;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.controller.repository.schema.ResourceClaimFieldMap;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;

public class ContentClaimFieldMap
implements Record {
    private final ContentClaim contentClaim;
    private final long contentClaimOffset;
    private final ResourceClaimFieldMap resourceClaimFieldMap;
    private final RecordSchema schema;

    public ContentClaimFieldMap(ContentClaim contentClaim, long contentClaimOffset, RecordSchema schema) {
        this.contentClaim = contentClaim;
        this.contentClaimOffset = contentClaimOffset;
        this.schema = schema;
        List resourceClaimFields = schema.getField("Resource Claim").getSubFields();
        RecordSchema resourceClaimSchema = new RecordSchema(resourceClaimFields);
        this.resourceClaimFieldMap = new ResourceClaimFieldMap(contentClaim.getResourceClaim(), resourceClaimSchema);
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Resource Claim": {
                return this.resourceClaimFieldMap;
            }
            case "Content Claim Length": {
                return this.contentClaim.getLength();
            }
            case "Content Claim Offset": {
                return this.contentClaimOffset;
            }
            case "Resource Claim Offset": {
                return this.contentClaim.getOffset();
            }
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        return "ContentClaimFieldMap[" + this.contentClaim + "]";
    }

    public static ContentClaim getContentClaim(Record claimRecord, ResourceClaimManager resourceClaimManager) {
        Record resourceClaimRecord = (Record)claimRecord.getFieldValue("Resource Claim");
        String container = (String)resourceClaimRecord.getFieldValue("Container");
        String section = (String)resourceClaimRecord.getFieldValue("Section");
        String identifier = (String)resourceClaimRecord.getFieldValue("Identifier");
        Boolean lossTolerant = (Boolean)resourceClaimRecord.getFieldValue("Loss Tolerant");
        Long length = (Long)claimRecord.getFieldValue("Content Claim Length");
        Long resourceOffset = (Long)claimRecord.getFieldValue("Resource Claim Offset");
        ResourceClaim resourceClaim = resourceClaimManager.newResourceClaim(container, section, identifier, lossTolerant.booleanValue(), false);
        StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, resourceOffset);
        contentClaim.setLength(length);
        return contentClaim;
    }

    public static Long getContentClaimOffset(Record claimRecord) {
        return (Long)claimRecord.getFieldValue("Content Claim Offset");
    }
}

