/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.nifi.controller.repository.schema.FlowFileSchema;
import org.apache.nifi.repository.schema.ComplexRecordField;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SimpleRecordField;
import org.apache.nifi.repository.schema.UnionRecordField;

public class RepositoryRecordSchema {
    public static final String REPOSITORY_RECORD_UPDATE_V1 = "Repository Record Update";
    public static final String ACTION_TYPE = "Action";
    public static final String RECORD_ID = "Record ID";
    public static final String QUEUE_IDENTIFIER = "Queue Identifier";
    public static final String SWAP_LOCATION = "Swap Location";
    public static final String CREATE_OR_UPDATE_ACTION = "Create or Update";
    public static final String DELETE_ACTION = "Delete";
    public static final String SWAP_IN_ACTION = "Swap In";
    public static final String SWAP_OUT_ACTION = "Swap Out";
    public static final RecordSchema REPOSITORY_RECORD_SCHEMA_V1;
    public static final RecordSchema CREATE_OR_UPDATE_SCHEMA_V1;
    public static final RecordSchema DELETE_SCHEMA_V1;
    public static final RecordSchema SWAP_IN_SCHEMA_V1;
    public static final RecordSchema SWAP_OUT_SCHEMA_V1;
    public static final RecordField ACTION_TYPE_FIELD;
    public static final RecordField RECORD_ID_FIELD;

    static {
        ACTION_TYPE_FIELD = new SimpleRecordField(ACTION_TYPE, FieldType.STRING, Repetition.EXACTLY_ONE);
        RECORD_ID_FIELD = new SimpleRecordField(RECORD_ID, FieldType.LONG, Repetition.EXACTLY_ONE);
        ArrayList<Object> createOrUpdateFields = new ArrayList<Object>();
        createOrUpdateFields.add(ACTION_TYPE_FIELD);
        createOrUpdateFields.addAll(FlowFileSchema.FLOWFILE_SCHEMA_V1.getFields());
        createOrUpdateFields.add(new SimpleRecordField(QUEUE_IDENTIFIER, FieldType.STRING, Repetition.EXACTLY_ONE));
        createOrUpdateFields.add(new SimpleRecordField(SWAP_LOCATION, FieldType.STRING, Repetition.ZERO_OR_ONE));
        ComplexRecordField createOrUpdate = new ComplexRecordField(CREATE_OR_UPDATE_ACTION, Repetition.EXACTLY_ONE, createOrUpdateFields);
        CREATE_OR_UPDATE_SCHEMA_V1 = new RecordSchema(createOrUpdateFields);
        ArrayList<RecordField> deleteFields = new ArrayList<RecordField>();
        deleteFields.add(ACTION_TYPE_FIELD);
        deleteFields.add(RECORD_ID_FIELD);
        ComplexRecordField delete = new ComplexRecordField(DELETE_ACTION, Repetition.EXACTLY_ONE, deleteFields);
        DELETE_SCHEMA_V1 = new RecordSchema(deleteFields);
        ArrayList<Object> swapOutFields = new ArrayList<Object>();
        swapOutFields.add(ACTION_TYPE_FIELD);
        swapOutFields.add(RECORD_ID_FIELD);
        swapOutFields.add(new SimpleRecordField(QUEUE_IDENTIFIER, FieldType.STRING, Repetition.EXACTLY_ONE));
        swapOutFields.add(new SimpleRecordField(SWAP_LOCATION, FieldType.STRING, Repetition.EXACTLY_ONE));
        ComplexRecordField swapOut = new ComplexRecordField(SWAP_OUT_ACTION, Repetition.EXACTLY_ONE, swapOutFields);
        SWAP_OUT_SCHEMA_V1 = new RecordSchema(swapOutFields);
        ArrayList<SimpleRecordField> swapInFields = new ArrayList<SimpleRecordField>(createOrUpdateFields);
        swapInFields.add(new SimpleRecordField(SWAP_LOCATION, FieldType.STRING, Repetition.EXACTLY_ONE));
        ComplexRecordField swapIn = new ComplexRecordField(SWAP_IN_ACTION, Repetition.EXACTLY_ONE, swapInFields);
        SWAP_IN_SCHEMA_V1 = new RecordSchema(swapInFields);
        UnionRecordField repoUpdateField = new UnionRecordField(REPOSITORY_RECORD_UPDATE_V1, Repetition.EXACTLY_ONE, new RecordField[]{createOrUpdate, delete, swapOut, swapIn});
        REPOSITORY_RECORD_SCHEMA_V1 = new RecordSchema(Collections.singletonList(repoUpdateField));
    }
}

