/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;

public class ResourceClaimFieldMap
implements Record {
    private final ResourceClaim resourceClaim;
    private final RecordSchema schema;

    public ResourceClaimFieldMap(ResourceClaim resourceClaim, RecordSchema schema) {
        this.resourceClaim = resourceClaim;
        this.schema = schema;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Container": {
                return this.resourceClaim.getContainer();
            }
            case "Section": {
                return this.resourceClaim.getSection();
            }
            case "Identifier": {
                return this.resourceClaim.getId();
            }
            case "Loss Tolerant": {
                return this.resourceClaim.isLossTolerant();
            }
        }
        return null;
    }

    public static ResourceClaim getResourceClaim(Record record, ResourceClaimManager claimManager) {
        String container = (String)record.getFieldValue("Container");
        String section = (String)record.getFieldValue("Section");
        String identifier = (String)record.getFieldValue("Identifier");
        Boolean lossTolerant = (Boolean)record.getFieldValue("Loss Tolerant");
        return claimManager.newResourceClaim(container, section, identifier, lossTolerant.booleanValue(), false);
    }

    public int hashCode() {
        return 41 + 91 * this.resourceClaim.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ResourceClaimFieldMap.class) {
            return false;
        }
        ResourceClaimFieldMap other = (ResourceClaimFieldMap)obj;
        return this.resourceClaim.equals(other.resourceClaim);
    }
}

