/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;

public class StandardControllerServiceReference
implements ControllerServiceReference {
    private final ControllerServiceNode referenced;
    private final Set<ConfiguredComponent> components;

    public StandardControllerServiceReference(ControllerServiceNode referencedService, Set<ConfiguredComponent> referencingComponents) {
        this.referenced = referencedService;
        this.components = new HashSet<ConfiguredComponent>(referencingComponents);
    }

    public ControllerServiceNode getReferencedComponent() {
        return this.referenced;
    }

    public Set<ConfiguredComponent> getReferencingComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    private boolean isRunning(ConfiguredComponent component) {
        if (component instanceof ReportingTaskNode) {
            return ((ReportingTaskNode)component).isRunning();
        }
        if (component instanceof ProcessorNode) {
            return ((ProcessorNode)component).isRunning();
        }
        return false;
    }

    public Set<ConfiguredComponent> getActiveReferences() {
        HashSet<ConfiguredComponent> activeReferences = new HashSet<ConfiguredComponent>();
        HashSet<ControllerServiceNode> serviceNodes = new HashSet<ControllerServiceNode>();
        for (ConfiguredComponent component : this.components) {
            if (component instanceof ControllerServiceNode) {
                serviceNodes.add((ControllerServiceNode)component);
                if (!((ControllerServiceNode)component).isActive()) continue;
                activeReferences.add(component);
                continue;
            }
            if (!this.isRunning(component)) continue;
            activeReferences.add(component);
        }
        activeReferences.addAll(this.getActiveIndirectReferences(serviceNodes));
        return activeReferences;
    }

    private Set<ConfiguredComponent> getActiveIndirectReferences(Set<ControllerServiceNode> referencingServices) {
        if (referencingServices.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ConfiguredComponent> references = new HashSet<ConfiguredComponent>();
        for (ControllerServiceNode referencingService : referencingServices) {
            HashSet<ControllerServiceNode> serviceNodes = new HashSet<ControllerServiceNode>();
            ControllerServiceReference ref = referencingService.getReferences();
            for (ConfiguredComponent component : ref.getReferencingComponents()) {
                if (component instanceof ControllerServiceNode) {
                    serviceNodes.add((ControllerServiceNode)component);
                    continue;
                }
                if (!this.isRunning(component)) continue;
                references.add(component);
            }
            references.addAll(this.getActiveIndirectReferences(serviceNodes));
        }
        return references;
    }
}

