/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.swap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.schema.FlowFileRecordFieldMap;
import org.apache.nifi.controller.repository.schema.FlowFileSchema;
import org.apache.nifi.controller.swap.StandardSwapSummary;
import org.apache.nifi.controller.swap.SwapSchema;
import org.apache.nifi.controller.swap.SwapSerializer;
import org.apache.nifi.controller.swap.SwapSummaryFieldMap;
import org.apache.nifi.repository.schema.ComplexRecordField;
import org.apache.nifi.repository.schema.FieldMapRecord;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SchemaRecordWriter;
import org.apache.nifi.repository.schema.SimpleRecordField;

public class SchemaSwapSerializer
implements SwapSerializer {
    static final String SERIALIZATION_NAME = "Schema Swap Serialization";
    private final RecordSchema schema = SwapSchema.FULL_SWAP_FILE_SCHEMA_V1;
    private final RecordSchema flowFileSchema = new RecordSchema(this.schema.getField("FlowFiles").getSubFields());

    @Override
    public void serializeFlowFiles(List<FlowFileRecord> toSwap, FlowFileQueue queue, String swapLocation, OutputStream out) throws IOException {
        this.schema.writeTo(out);
        long contentSize = 0L;
        long maxFlowFileId = -1L;
        ArrayList<ResourceClaim> resourceClaims = new ArrayList<ResourceClaim>();
        for (FlowFileRecord flowFile2 : toSwap) {
            ContentClaim contentClaim;
            contentSize += flowFile2.getSize();
            if (flowFile2.getId() > maxFlowFileId) {
                maxFlowFileId = flowFile2.getId();
            }
            if ((contentClaim = flowFile2.getContentClaim()) == null) continue;
            resourceClaims.add(contentClaim.getResourceClaim());
        }
        QueueSize queueSize = new QueueSize(toSwap.size(), contentSize);
        StandardSwapSummary swapSummary = new StandardSwapSummary(queueSize, maxFlowFileId, resourceClaims);
        SwapSummaryFieldMap summaryRecord = new SwapSummaryFieldMap(swapSummary, queue.getIdentifier(), SwapSchema.SWAP_SUMMARY_SCHEMA_V1);
        List flowFileRecords = toSwap.stream().map(flowFile -> new FlowFileRecordFieldMap((FlowFileRecord)flowFile, this.flowFileSchema)).collect(Collectors.toList());
        SimpleRecordField summaryField = new SimpleRecordField("Swap Summary", FieldType.COMPLEX, Repetition.EXACTLY_ONE);
        ComplexRecordField contentsField = new ComplexRecordField("FlowFiles", Repetition.ZERO_OR_MORE, FlowFileSchema.FLOWFILE_SCHEMA_V1.getFields());
        ArrayList<Object> fields = new ArrayList<Object>(2);
        fields.add(summaryField);
        fields.add(contentsField);
        LinkedHashMap<Object, Object> swapFileMap = new LinkedHashMap<Object, Object>();
        swapFileMap.put(summaryField, summaryRecord);
        swapFileMap.put(contentsField, flowFileRecords);
        FieldMapRecord swapFileRecord = new FieldMapRecord(swapFileMap, new RecordSchema(fields));
        SchemaRecordWriter writer = new SchemaRecordWriter();
        writer.writeRecord((Record)swapFileRecord, out);
        out.flush();
    }

    @Override
    public String getSerializationName() {
        return SERIALIZATION_NAME;
    }
}

