/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.util.NiFiProperties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

public final class StringEncryptor {
    public static final String NF_SENSITIVE_PROPS_KEY = "nifi.sensitive.props.key";
    public static final String NF_SENSITIVE_PROPS_ALGORITHM = "nifi.sensitive.props.algorithm";
    public static final String NF_SENSITIVE_PROPS_PROVIDER = "nifi.sensitive.props.provider";
    private static final String DEFAULT_SENSITIVE_PROPS_KEY = "nififtw!";
    private static final String TEST_PLAINTEXT = "this is a test";
    private final StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();

    private StringEncryptor(String aglorithm, String provider, String key) {
        this.encryptor.setAlgorithm(aglorithm);
        this.encryptor.setProviderName(provider);
        this.encryptor.setPassword(key);
        this.encryptor.setStringOutputType("hexadecimal");
        this.encryptor.initialize();
    }

    public static StringEncryptor createEncryptor(NiFiProperties niFiProperties) throws EncryptionException {
        StringEncryptor nifiEncryptor;
        Security.addProvider((Provider)new BouncyCastleProvider());
        String sensitivePropAlgorithmVal = niFiProperties.getProperty(NF_SENSITIVE_PROPS_ALGORITHM);
        String sensitivePropProviderVal = niFiProperties.getProperty(NF_SENSITIVE_PROPS_PROVIDER);
        String sensitivePropValueNifiPropVar = niFiProperties.getProperty(NF_SENSITIVE_PROPS_KEY, DEFAULT_SENSITIVE_PROPS_KEY);
        if (StringUtils.isBlank((CharSequence)sensitivePropAlgorithmVal)) {
            throw new EncryptionException("nifi.sensitive.props.algorithmmust bet set");
        }
        if (StringUtils.isBlank((CharSequence)sensitivePropProviderVal)) {
            throw new EncryptionException("nifi.sensitive.props.providermust bet set");
        }
        if (StringUtils.isBlank((CharSequence)sensitivePropValueNifiPropVar)) {
            throw new EncryptionException("nifi.sensitive.props.keymust bet set");
        }
        try {
            nifiEncryptor = new StringEncryptor(sensitivePropAlgorithmVal, sensitivePropProviderVal, sensitivePropValueNifiPropVar);
            if (!nifiEncryptor.decrypt(nifiEncryptor.encrypt(TEST_PLAINTEXT)).equals(TEST_PLAINTEXT)) {
                throw new EncryptionException("NiFi property encryptor does appear to be working - decrypt/encrypt return invalid results");
            }
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException ex) {
            throw new EncryptionException("Cannot initialize sensitive property encryptor", ex);
        }
        return nifiEncryptor;
    }

    public String encrypt(String clearText) throws EncryptionException {
        try {
            return this.encryptor.encrypt(clearText);
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException eonpe) {
            throw new EncryptionException(eonpe);
        }
    }

    public String decrypt(String cipherText) throws EncryptionException {
        try {
            return this.encryptor.decrypt(cipherText);
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException eonpe) {
            throw new EncryptionException(eonpe);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

