/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.apache.nifi.web.util.WebUtils;

public class RemoteNiFiUtils {
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;
    private final Client client;

    public RemoteNiFiUtils(SSLContext sslContext) {
        this.client = this.getClient(sslContext);
    }

    private Client getClient(SSLContext sslContext) {
        Client client = sslContext == null ? WebUtils.createClient(null) : WebUtils.createClient(null, (SSLContext)sslContext);
        client.setReadTimeout(Integer.valueOf(10000));
        client.setConnectTimeout(Integer.valueOf(10000));
        return client;
    }

    public ClientResponse issueRegistrationRequest(String baseApiUri) {
        URI uri = URI.create(String.format("%s/controller/users", baseApiUri));
        MultivaluedMapImpl entity = new MultivaluedMapImpl();
        entity.add("justification", "A Remote instance of NiFi has attempted to create a reference to this NiFi. This action must be approved first.");
        WebResource webResource = this.client.resource(uri);
        return (ClientResponse)((WebResource.Builder)webResource.type("application/x-www-form-urlencoded").entity((Object)entity)).post(ClientResponse.class);
    }
}

