/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.partition;

import com.google.common.hash.Hashing;
import org.apache.nifi.controller.queue.clustered.partition.FlowFilePartitioner;
import org.apache.nifi.controller.queue.clustered.partition.QueuePartition;
import org.apache.nifi.controller.repository.FlowFileRecord;

public class CorrelationAttributePartitioner
implements FlowFilePartitioner {
    private final String partitioningAttribute;

    public CorrelationAttributePartitioner(String partitioningAttribute) {
        this.partitioningAttribute = partitioningAttribute;
    }

    @Override
    public QueuePartition getPartition(FlowFileRecord flowFile, QueuePartition[] partitions, QueuePartition localPartition) {
        int hash = this.hash(flowFile);
        int index = partitions.length < 3 ? Math.floorMod(hash, partitions.length) : Hashing.consistentHash((long)hash, (int)partitions.length);
        return partitions[index];
    }

    protected int hash(FlowFileRecord flowFile) {
        String partitionAttributeValue = flowFile.getAttribute(this.partitioningAttribute);
        return partitionAttributeValue == null ? 0 : partitionAttributeValue.hashCode();
    }

    @Override
    public boolean isRebalanceOnClusterResize() {
        return true;
    }

    @Override
    public boolean isRebalanceOnFailure() {
        return false;
    }
}

