/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.mapping;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.flow.BatchSize;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.ComponentType;
import org.apache.nifi.registry.flow.ConnectableComponent;
import org.apache.nifi.registry.flow.ConnectableComponentType;
import org.apache.nifi.registry.flow.ControllerServiceAPI;
import org.apache.nifi.registry.flow.ExternalControllerServiceReference;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.PortType;
import org.apache.nifi.registry.flow.Position;
import org.apache.nifi.registry.flow.ScheduledState;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedConnection;
import org.apache.nifi.registry.flow.VersionedControllerService;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.VersionedFunnel;
import org.apache.nifi.registry.flow.VersionedLabel;
import org.apache.nifi.registry.flow.VersionedParameter;
import org.apache.nifi.registry.flow.VersionedParameterContext;
import org.apache.nifi.registry.flow.VersionedPort;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.VersionedProcessor;
import org.apache.nifi.registry.flow.VersionedPropertyDescriptor;
import org.apache.nifi.registry.flow.VersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.registry.flow.mapping.InstantiatedConnectableComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedConnection;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedFunnel;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedLabel;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedPort;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedRemoteProcessGroup;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;

public class NiFiRegistryFlowMapper {
    private final ExtensionManager extensionManager;
    private Map<String, String> versionedComponentIds = new HashMap<String, String>();

    public NiFiRegistryFlowMapper(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public InstantiatedVersionedProcessGroup mapProcessGroup(ProcessGroup group, ControllerServiceProvider serviceProvider, FlowRegistryClient registryClient, boolean mapDescendantVersionedFlows) {
        this.versionedComponentIds.clear();
        InstantiatedVersionedProcessGroup mapped = this.mapGroup(group, serviceProvider, registryClient, true, mapDescendantVersionedFlows);
        this.populateReferencedAncestorVariables(group, mapped);
        return mapped;
    }

    private void populateReferencedAncestorVariables(ProcessGroup group, VersionedProcessGroup versionedGroup) {
        HashSet<String> ancestorVariableNames = new HashSet<String>();
        this.populateVariableNames(group.getParent(), ancestorVariableNames);
        HashMap<String, String> implicitlyDefinedVariables = new HashMap<String, String>();
        for (String variableName : ancestorVariableNames) {
            boolean isReferenced = !group.getComponentsAffectedByVariable(variableName).isEmpty();
            if (!isReferenced) continue;
            String value = group.getVariableRegistry().getVariableValue(variableName);
            implicitlyDefinedVariables.put(variableName, value);
        }
        if (!implicitlyDefinedVariables.isEmpty()) {
            if (versionedGroup.getVariables() != null) {
                implicitlyDefinedVariables.putAll(versionedGroup.getVariables());
            }
            versionedGroup.setVariables(implicitlyDefinedVariables);
        }
    }

    private void populateVariableNames(ProcessGroup group, Set<String> variableNames) {
        if (group == null) {
            return;
        }
        group.getVariableRegistry().getVariableMap().keySet().stream().map(VariableDescriptor::getName).forEach(variableNames::add);
        this.populateVariableNames(group.getParent(), variableNames);
    }

    private InstantiatedVersionedProcessGroup mapGroup(ProcessGroup group, ControllerServiceProvider serviceProvider, FlowRegistryClient registryClient, boolean topLevel, boolean mapDescendantVersionedFlows) {
        Set<String> allIncludedGroupsIds = group.findAllProcessGroups().stream().map(ProcessGroup::getIdentifier).collect(Collectors.toSet());
        allIncludedGroupsIds.add(group.getIdentifier());
        HashMap<String, ExternalControllerServiceReference> externalControllerServiceReferences = new HashMap<String, ExternalControllerServiceReference>();
        return this.mapGroup(group, serviceProvider, registryClient, topLevel, mapDescendantVersionedFlows, allIncludedGroupsIds, externalControllerServiceReferences);
    }

    private InstantiatedVersionedProcessGroup mapGroup(ProcessGroup group, ControllerServiceProvider serviceProvider, FlowRegistryClient registryClient, boolean topLevel, boolean mapDescendantVersionedFlows, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        VersionControlInformation versionControlInfo;
        InstantiatedVersionedProcessGroup versionedGroup = new InstantiatedVersionedProcessGroup(group.getIdentifier(), group.getProcessGroupIdentifier());
        versionedGroup.setIdentifier(this.getId(group.getVersionedComponentId(), group.getIdentifier()));
        versionedGroup.setGroupIdentifier(this.getGroupId(group.getProcessGroupIdentifier()));
        versionedGroup.setName(group.getName());
        versionedGroup.setComments(group.getComments());
        versionedGroup.setPosition(this.mapPosition(group.getPosition()));
        ParameterContext parameterContext = group.getParameterContext();
        versionedGroup.setParameterContextName(parameterContext == null ? null : parameterContext.getName());
        if (!topLevel && (versionControlInfo = group.getVersionControlInformation()) != null) {
            VersionedFlowCoordinates coordinates = new VersionedFlowCoordinates();
            String registryId = versionControlInfo.getRegistryIdentifier();
            FlowRegistry registry = registryClient.getFlowRegistry(registryId);
            if (registry == null) {
                throw new IllegalStateException("Process Group refers to a Flow Registry with ID " + registryId + " but no Flow Registry exists with that ID. Cannot resolve to a URL.");
            }
            coordinates.setRegistryUrl(registry.getURL());
            coordinates.setBucketId(versionControlInfo.getBucketIdentifier());
            coordinates.setFlowId(versionControlInfo.getFlowIdentifier());
            coordinates.setVersion(versionControlInfo.getVersion());
            versionedGroup.setVersionedFlowCoordinates(coordinates);
            for (Port port : group.getInputPorts()) {
                this.getId(port.getVersionedComponentId(), port.getIdentifier());
            }
            for (Port port : group.getOutputPorts()) {
                this.getId(port.getVersionedComponentId(), port.getIdentifier());
            }
            if (!mapDescendantVersionedFlows) {
                return versionedGroup;
            }
        }
        versionedGroup.setControllerServices(group.getControllerServices(false).stream().map(service -> this.mapControllerService((ControllerServiceNode)service, serviceProvider, includedGroupIds, externalControllerServiceReferences)).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setFunnels(group.getFunnels().stream().map(this::mapFunnel).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setInputPorts(group.getInputPorts().stream().map(this::mapPort).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setOutputPorts(group.getOutputPorts().stream().map(this::mapPort).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setLabels(group.getLabels().stream().map(this::mapLabel).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setProcessors(group.getProcessors().stream().map(processor -> this.mapProcessor((ProcessorNode)processor, serviceProvider, includedGroupIds, externalControllerServiceReferences)).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setRemoteProcessGroups(group.getRemoteProcessGroups().stream().map(this::mapRemoteProcessGroup).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setProcessGroups(group.getProcessGroups().stream().map(grp -> this.mapGroup((ProcessGroup)grp, serviceProvider, registryClient, false, mapDescendantVersionedFlows, includedGroupIds, externalControllerServiceReferences)).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setConnections(group.getConnections().stream().map(this::mapConnection).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setVariables(group.getVariableRegistry().getVariableMap().entrySet().stream().collect(Collectors.toMap(entry -> ((VariableDescriptor)entry.getKey()).getName(), Map.Entry::getValue)));
        if (topLevel) {
            versionedGroup.setExternalControllerServiceReferences(externalControllerServiceReferences);
        }
        return versionedGroup;
    }

    private String getId(Optional<String> currentVersionedId, String componentId) {
        String versionedId = currentVersionedId.isPresent() ? currentVersionedId.get() : UUID.nameUUIDFromBytes(componentId.getBytes(StandardCharsets.UTF_8)).toString();
        this.versionedComponentIds.put(componentId, versionedId);
        return versionedId;
    }

    private <E extends Exception> String getIdOrThrow(Optional<String> currentVersionedId, String componentId, Supplier<E> exceptionSupplier) throws E {
        if (currentVersionedId.isPresent()) {
            return currentVersionedId.get();
        }
        String resolved = this.versionedComponentIds.get(componentId);
        if (resolved == null) {
            throw (Exception)exceptionSupplier.get();
        }
        return resolved;
    }

    private String getGroupId(String groupId) {
        return this.versionedComponentIds.get(groupId);
    }

    public VersionedConnection mapConnection(Connection connection) {
        FlowFileQueue queue = connection.getFlowFileQueue();
        InstantiatedVersionedConnection versionedConnection = new InstantiatedVersionedConnection(connection.getIdentifier(), connection.getProcessGroup().getIdentifier());
        versionedConnection.setIdentifier(this.getId(connection.getVersionedComponentId(), connection.getIdentifier()));
        versionedConnection.setGroupIdentifier(this.getGroupId(connection.getProcessGroup().getIdentifier()));
        versionedConnection.setName(connection.getName());
        versionedConnection.setBackPressureDataSizeThreshold(queue.getBackPressureDataSizeThreshold());
        versionedConnection.setBackPressureObjectThreshold(queue.getBackPressureObjectThreshold());
        versionedConnection.setFlowFileExpiration(queue.getFlowFileExpiration());
        versionedConnection.setLabelIndex(connection.getLabelIndex());
        versionedConnection.setPrioritizers(queue.getPriorities().stream().map(p -> p.getClass().getName()).collect(Collectors.toList()));
        versionedConnection.setSelectedRelationships(connection.getRelationships().stream().map(Relationship::getName).collect(Collectors.toSet()));
        versionedConnection.setzIndex(connection.getZIndex());
        FlowFileQueue flowFileQueue = connection.getFlowFileQueue();
        versionedConnection.setLoadBalanceStrategy(flowFileQueue.getLoadBalanceStrategy().name());
        versionedConnection.setPartitioningAttribute(flowFileQueue.getPartitioningAttribute());
        versionedConnection.setLoadBalanceCompression(flowFileQueue.getLoadBalanceCompression().name());
        versionedConnection.setBends(connection.getBendPoints().stream().map(this::mapPosition).collect(Collectors.toList()));
        versionedConnection.setSource(this.mapConnectable(connection.getSource()));
        versionedConnection.setDestination(this.mapConnectable(connection.getDestination()));
        return versionedConnection;
    }

    public ConnectableComponent mapConnectable(Connectable connectable) {
        String groupId;
        InstantiatedConnectableComponent component = new InstantiatedConnectableComponent(connectable.getIdentifier(), connectable.getProcessGroupIdentifier());
        String versionedId = this.getIdOrThrow(connectable.getVersionedComponentId(), connectable.getIdentifier(), () -> new IllegalArgumentException("Unable to map Connectable Component with identifier " + connectable.getIdentifier() + " to any version-controlled component"));
        component.setId(versionedId);
        component.setComments(connectable.getComments());
        if (connectable instanceof RemoteGroupPort) {
            RemoteGroupPort port = (RemoteGroupPort)connectable;
            RemoteProcessGroup rpg = port.getRemoteProcessGroup();
            Optional rpgVersionedId = rpg.getVersionedComponentId();
            groupId = this.getIdOrThrow(rpgVersionedId, rpg.getIdentifier(), () -> new IllegalArgumentException("Unable to find the Versioned Component ID for Remote Process Group that " + connectable + " belongs to"));
        } else {
            groupId = this.getIdOrThrow(connectable.getProcessGroup().getVersionedComponentId(), connectable.getProcessGroupIdentifier(), () -> new IllegalArgumentException("Unable to find the Versioned Component ID for the Process Group that " + connectable + " belongs to"));
        }
        component.setGroupId(groupId);
        component.setName(connectable.getName());
        component.setType(ConnectableComponentType.valueOf((String)connectable.getConnectableType().name()));
        return component;
    }

    public VersionedControllerService mapControllerService(ControllerServiceNode controllerService, ControllerServiceProvider serviceProvider, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        InstantiatedVersionedControllerService versionedService = new InstantiatedVersionedControllerService(controllerService.getIdentifier(), controllerService.getProcessGroupIdentifier());
        versionedService.setIdentifier(this.getId(controllerService.getVersionedComponentId(), controllerService.getIdentifier()));
        versionedService.setGroupIdentifier(this.getGroupId(controllerService.getProcessGroupIdentifier()));
        versionedService.setName(controllerService.getName());
        versionedService.setAnnotationData(controllerService.getAnnotationData());
        versionedService.setBundle(this.mapBundle(controllerService.getBundleCoordinate()));
        versionedService.setComments(controllerService.getComments());
        versionedService.setControllerServiceApis(this.mapControllerServiceApis(controllerService));
        versionedService.setProperties(this.mapProperties((ComponentNode)controllerService, serviceProvider));
        versionedService.setPropertyDescriptors(this.mapPropertyDescriptors((ComponentNode)controllerService, serviceProvider, includedGroupIds, externalControllerServiceReferences));
        versionedService.setType(controllerService.getCanonicalClassName());
        return versionedService;
    }

    private Map<String, String> mapProperties(ComponentNode component, ControllerServiceProvider serviceProvider) {
        HashMap<String, String> mapped = new HashMap<String, String>();
        component.getProperties().keySet().stream().filter(property -> this.isMappable((PropertyDescriptor)property, component.getProperty(property))).forEach(property -> {
            ControllerServiceNode controllerService;
            String value = component.getRawPropertyValue(property);
            if (value == null) {
                value = property.getDefaultValue();
            }
            if (value != null && property.getControllerServiceDefinition() != null && (controllerService = serviceProvider.getControllerServiceNode(value)) != null) {
                value = this.getId(controllerService.getVersionedComponentId(), controllerService.getIdentifier());
            }
            mapped.put(property.getName(), value);
        });
        return mapped;
    }

    private boolean isMappable(PropertyDescriptor propertyDescriptor, PropertyConfiguration propertyConfiguration) {
        if (!propertyDescriptor.isSensitive()) {
            return true;
        }
        if (propertyConfiguration == null) {
            return false;
        }
        return !propertyConfiguration.getParameterReferences().isEmpty();
    }

    private Map<String, VersionedPropertyDescriptor> mapPropertyDescriptors(ComponentNode component, ControllerServiceProvider serviceProvider, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        HashMap<String, VersionedPropertyDescriptor> descriptors = new HashMap<String, VersionedPropertyDescriptor>();
        for (PropertyDescriptor descriptor : component.getProperties().keySet()) {
            String value;
            VersionedPropertyDescriptor versionedDescriptor = new VersionedPropertyDescriptor();
            versionedDescriptor.setName(descriptor.getName());
            versionedDescriptor.setDisplayName(descriptor.getDisplayName());
            versionedDescriptor.setSensitive(descriptor.isSensitive());
            Class referencedServiceType = descriptor.getControllerServiceDefinition();
            versionedDescriptor.setIdentifiesControllerService(referencedServiceType != null);
            if (referencedServiceType != null && (value = component.getProperty(descriptor).getRawValue()) != null) {
                ControllerServiceNode serviceNode = serviceProvider.getControllerServiceNode(value);
                if (serviceNode == null) continue;
                String serviceGroupId = serviceNode.getProcessGroupIdentifier();
                if (!includedGroupIds.contains(serviceGroupId)) {
                    String serviceId = this.getId(serviceNode.getVersionedComponentId(), serviceNode.getIdentifier());
                    ExternalControllerServiceReference controllerServiceReference = new ExternalControllerServiceReference();
                    controllerServiceReference.setIdentifier(serviceId);
                    controllerServiceReference.setName(serviceNode.getName());
                    externalControllerServiceReferences.put(serviceId, controllerServiceReference);
                }
            }
            descriptors.put(descriptor.getName(), versionedDescriptor);
        }
        return descriptors;
    }

    private Bundle mapBundle(BundleCoordinate coordinate) {
        Bundle versionedBundle = new Bundle();
        versionedBundle.setGroup(coordinate.getGroup());
        versionedBundle.setArtifact(coordinate.getId());
        versionedBundle.setVersion(coordinate.getVersion());
        return versionedBundle;
    }

    private List<ControllerServiceAPI> mapControllerServiceApis(ControllerServiceNode service) {
        Class<?> serviceClass = service.getControllerServiceImplementation().getClass();
        HashSet<Class> serviceApiClasses = new HashSet<Class>();
        List interfaces = ClassUtils.getAllInterfaces(serviceClass);
        for (Class i : interfaces) {
            if (!ControllerService.class.isAssignableFrom(i) || ControllerService.class.equals((Object)i)) continue;
            serviceApiClasses.add(i);
        }
        ArrayList<ControllerServiceAPI> serviceApis = new ArrayList<ControllerServiceAPI>();
        for (Class serviceApiClass : serviceApiClasses) {
            BundleCoordinate bundleCoordinate = this.extensionManager.getBundle(serviceApiClass.getClassLoader()).getBundleDetails().getCoordinate();
            ControllerServiceAPI serviceApi = new ControllerServiceAPI();
            serviceApi.setType(serviceApiClass.getName());
            serviceApi.setBundle(this.mapBundle(bundleCoordinate));
            serviceApis.add(serviceApi);
        }
        return serviceApis;
    }

    public VersionedFunnel mapFunnel(Funnel funnel) {
        InstantiatedVersionedFunnel versionedFunnel = new InstantiatedVersionedFunnel(funnel.getIdentifier(), funnel.getProcessGroupIdentifier());
        versionedFunnel.setIdentifier(this.getId(funnel.getVersionedComponentId(), funnel.getIdentifier()));
        versionedFunnel.setGroupIdentifier(this.getGroupId(funnel.getProcessGroupIdentifier()));
        versionedFunnel.setPosition(this.mapPosition(funnel.getPosition()));
        return versionedFunnel;
    }

    public VersionedLabel mapLabel(Label label) {
        InstantiatedVersionedLabel versionedLabel = new InstantiatedVersionedLabel(label.getIdentifier(), label.getProcessGroupIdentifier());
        versionedLabel.setIdentifier(this.getId(label.getVersionedComponentId(), label.getIdentifier()));
        versionedLabel.setGroupIdentifier(this.getGroupId(label.getProcessGroupIdentifier()));
        versionedLabel.setHeight(label.getSize().getHeight());
        versionedLabel.setWidth(label.getSize().getWidth());
        versionedLabel.setLabel(label.getValue());
        versionedLabel.setPosition(this.mapPosition(label.getPosition()));
        versionedLabel.setStyle(label.getStyle());
        return versionedLabel;
    }

    public VersionedPort mapPort(Port port) {
        InstantiatedVersionedPort versionedPort = new InstantiatedVersionedPort(port.getIdentifier(), port.getProcessGroupIdentifier());
        versionedPort.setIdentifier(this.getId(port.getVersionedComponentId(), port.getIdentifier()));
        versionedPort.setGroupIdentifier(this.getGroupId(port.getProcessGroupIdentifier()));
        versionedPort.setComments(port.getComments());
        versionedPort.setConcurrentlySchedulableTaskCount(port.getMaxConcurrentTasks());
        versionedPort.setName(port.getName());
        versionedPort.setPosition(this.mapPosition(port.getPosition()));
        versionedPort.setType(PortType.valueOf((String)port.getConnectableType().name()));
        if (port instanceof PublicPort) {
            versionedPort.setAllowRemoteAccess(true);
        } else {
            versionedPort.setAllowRemoteAccess(false);
        }
        return versionedPort;
    }

    public Position mapPosition(org.apache.nifi.connectable.Position pos) {
        Position position = new Position();
        position.setX(pos.getX());
        position.setY(pos.getY());
        return position;
    }

    public VersionedProcessor mapProcessor(ProcessorNode procNode, ControllerServiceProvider serviceProvider, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        InstantiatedVersionedProcessor processor = new InstantiatedVersionedProcessor(procNode.getIdentifier(), procNode.getProcessGroupIdentifier());
        processor.setIdentifier(this.getId(procNode.getVersionedComponentId(), procNode.getIdentifier()));
        processor.setGroupIdentifier(this.getGroupId(procNode.getProcessGroupIdentifier()));
        processor.setType(procNode.getCanonicalClassName());
        processor.setAnnotationData(procNode.getAnnotationData());
        processor.setAutoTerminatedRelationships(procNode.getAutoTerminatedRelationships().stream().map(Relationship::getName).collect(Collectors.toSet()));
        processor.setBulletinLevel(procNode.getBulletinLevel().name());
        processor.setBundle(this.mapBundle(procNode.getBundleCoordinate()));
        processor.setComments(procNode.getComments());
        processor.setConcurrentlySchedulableTaskCount(procNode.getMaxConcurrentTasks());
        processor.setExecutionNode(procNode.getExecutionNode().name());
        processor.setName(procNode.getName());
        processor.setPenaltyDuration(procNode.getPenalizationPeriod());
        processor.setPosition(this.mapPosition(procNode.getPosition()));
        processor.setProperties(this.mapProperties((ComponentNode)procNode, serviceProvider));
        processor.setPropertyDescriptors(this.mapPropertyDescriptors((ComponentNode)procNode, serviceProvider, includedGroupIds, externalControllerServiceReferences));
        processor.setRunDurationMillis(procNode.getRunDuration(TimeUnit.MILLISECONDS));
        processor.setSchedulingPeriod(procNode.getSchedulingPeriod());
        processor.setSchedulingStrategy(procNode.getSchedulingStrategy().name());
        processor.setStyle(procNode.getStyle());
        processor.setYieldDuration(procNode.getYieldPeriod());
        processor.setScheduledState(procNode.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED ? ScheduledState.DISABLED : ScheduledState.ENABLED);
        return processor;
    }

    public VersionedRemoteProcessGroup mapRemoteProcessGroup(RemoteProcessGroup remoteGroup) {
        InstantiatedVersionedRemoteProcessGroup rpg = new InstantiatedVersionedRemoteProcessGroup(remoteGroup.getIdentifier(), remoteGroup.getProcessGroupIdentifier());
        rpg.setIdentifier(this.getId(remoteGroup.getVersionedComponentId(), remoteGroup.getIdentifier()));
        rpg.setGroupIdentifier(this.getGroupId(remoteGroup.getProcessGroupIdentifier()));
        rpg.setComments(remoteGroup.getComments());
        rpg.setCommunicationsTimeout(remoteGroup.getCommunicationsTimeout());
        rpg.setLocalNetworkInterface(remoteGroup.getNetworkInterface());
        rpg.setName(remoteGroup.getName());
        rpg.setInputPorts(remoteGroup.getInputPorts().stream().map(port -> this.mapRemotePort((RemoteGroupPort)port, ComponentType.REMOTE_INPUT_PORT)).collect(Collectors.toSet()));
        rpg.setOutputPorts(remoteGroup.getOutputPorts().stream().map(port -> this.mapRemotePort((RemoteGroupPort)port, ComponentType.REMOTE_OUTPUT_PORT)).collect(Collectors.toSet()));
        rpg.setPosition(this.mapPosition(remoteGroup.getPosition()));
        rpg.setProxyHost(remoteGroup.getProxyHost());
        rpg.setProxyPort(remoteGroup.getProxyPort());
        rpg.setProxyUser(remoteGroup.getProxyUser());
        rpg.setTargetUri(remoteGroup.getTargetUri());
        rpg.setTargetUris(remoteGroup.getTargetUris());
        rpg.setTransportProtocol(remoteGroup.getTransportProtocol().name());
        rpg.setYieldDuration(remoteGroup.getYieldDuration());
        return rpg;
    }

    public VersionedRemoteGroupPort mapRemotePort(RemoteGroupPort remotePort, ComponentType componentType) {
        InstantiatedVersionedRemoteGroupPort port = new InstantiatedVersionedRemoteGroupPort(remotePort.getIdentifier(), remotePort.getRemoteProcessGroup().getIdentifier());
        port.setIdentifier(this.getId(remotePort.getVersionedComponentId(), remotePort.getIdentifier()));
        port.setGroupIdentifier(this.getGroupId(remotePort.getRemoteProcessGroup().getIdentifier()));
        port.setComments(remotePort.getComments());
        port.setConcurrentlySchedulableTaskCount(remotePort.getMaxConcurrentTasks());
        port.setRemoteGroupId(this.getGroupId(remotePort.getRemoteProcessGroup().getIdentifier()));
        port.setName(remotePort.getName());
        port.setUseCompression(remotePort.isUseCompression());
        port.setBatchSize(this.mapBatchSettings(remotePort));
        port.setTargetId(remotePort.getTargetIdentifier());
        port.setComponentType(componentType);
        return port;
    }

    private BatchSize mapBatchSettings(RemoteGroupPort remotePort) {
        BatchSize batchSize = new BatchSize();
        batchSize.setCount(remotePort.getBatchCount());
        batchSize.setDuration(remotePort.getBatchDuration());
        batchSize.setSize(remotePort.getBatchSize());
        return batchSize;
    }

    public VersionedParameterContext mapParameterContext(ParameterContext context) {
        if (context == null) {
            return null;
        }
        Set parameters = context.getParameters().values().stream().map(this::mapParameter).collect(Collectors.toSet());
        VersionedParameterContext versionedContext = new VersionedParameterContext();
        versionedContext.setName(context.getName());
        versionedContext.setParameters(parameters);
        return versionedContext;
    }

    public VersionedParameter mapParameter(Parameter parameter) {
        if (parameter == null) {
            return null;
        }
        ParameterDescriptor descriptor = parameter.getDescriptor();
        VersionedParameter versionedParameter = new VersionedParameter();
        versionedParameter.setDescription(descriptor.getDescription());
        versionedParameter.setName(descriptor.getName());
        versionedParameter.setSensitive(descriptor.isSensitive());
        versionedParameter.setValue(descriptor.isSensitive() ? null : parameter.getValue());
        return versionedParameter;
    }
}

