/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.validation;

import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerValidationTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TriggerValidationTask.class);
    private final FlowManager flowManager;
    private final ValidationTrigger validationTrigger;

    public TriggerValidationTask(FlowManager flowManager, ValidationTrigger validationTrigger) {
        this.flowManager = flowManager;
        this.validationTrigger = validationTrigger;
    }

    @Override
    public void run() {
        try {
            logger.debug("Triggering validation of all components");
            for (ComponentNode node : this.flowManager.getAllControllerServices()) {
                this.validationTrigger.trigger(node);
            }
            for (ComponentNode node : this.flowManager.getAllReportingTasks()) {
                this.validationTrigger.trigger(node);
            }
            for (ComponentNode node : this.flowManager.getRootGroup().findAllProcessors()) {
                this.validationTrigger.trigger(node);
            }
        }
        catch (Throwable t) {
            logger.error("Encountered unexpected error when attempting to validate components", t);
        }
    }
}

