/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.net.URL;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardReloadComponent
implements ReloadComponent {
    private static final Logger logger = LoggerFactory.getLogger(StandardReloadComponent.class);
    private final FlowController flowController;

    public StandardReloadComponent(FlowController flowController) {
        this.flowController = flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ProcessorNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws ProcessorInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ProcessorNode cannot be null");
        }
        String id = existingNode.getProcessor().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ProcessorNode newNode = this.flowController.getFlowManager().createProcessor(newType, id, bundleCoordinate, additionalUrls, true, false);
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            StateManager stateManager = this.flowController.getStateManagerProvider().getStateManager(id);
            StandardProcessContext processContext = new StandardProcessContext(existingNode, this.flowController.getControllerServiceProvider(), this.flowController.getEncryptor(), stateManager, () -> false);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getProcessor(), processContext);
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, newNode.getProcessor());
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newProcessor = new LoggableComponent((ConfigurableComponent)newNode.getProcessor(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setProcessor(newProcessor);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to processor reload", (Object)existingNode);
        this.flowController.getValidationTrigger().trigger((ComponentNode)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ControllerServiceNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws ControllerServiceInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ControllerServiceNode cannot be null");
        }
        String id = existingNode.getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ControllerServiceNode newNode = this.flowController.getFlowManager().createControllerService(newType, id, bundleCoordinate, additionalUrls, true, false);
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)existingNode, (ControllerServiceLookup)this.flowController.getControllerServiceProvider(), null, this.flowController.getVariableRegistry());
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getControllerServiceImplementation(), configurationContext);
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        ControllerServiceInvocationHandler invocationHandler = newNode.getInvocationHandler();
        invocationHandler.setServiceNode(existingNode);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, newNode.getControllerServiceImplementation());
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent loggableProxy = new LoggableComponent((ConfigurableComponent)newNode.getProxiedControllerService(), bundleCoordinate, terminationAwareLogger);
        LoggableComponent loggableImplementation = new LoggableComponent((ConfigurableComponent)newNode.getControllerServiceImplementation(), bundleCoordinate, terminationAwareLogger);
        existingNode.setControllerServiceAndProxy(loggableImplementation, loggableProxy, invocationHandler);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to controller service reload", (Object)existingNode);
        this.flowController.getValidationTrigger().triggerAsync((ComponentNode)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ReportingTaskNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws ReportingTaskInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ReportingTaskNode cannot be null");
        }
        String id = existingNode.getReportingTask().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ReportingTaskNode newNode = this.flowController.getFlowManager().createReportingTask(newType, id, bundleCoordinate, additionalUrls, true, false);
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getReportingTask(), existingNode.getConfigurationContext());
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, existingNode.getReportingTask());
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newReportingTask = new LoggableComponent((ConfigurableComponent)newNode.getReportingTask(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setReportingTask(newReportingTask);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to reporting task reload", (Object)existingNode);
        this.flowController.getValidationTrigger().triggerAsync((ComponentNode)existingNode);
    }
}

