/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.partition;

import java.util.function.Function;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.queue.clustered.partition.FlowFilePartitioner;
import org.apache.nifi.controller.queue.clustered.partition.QueuePartition;
import org.apache.nifi.controller.repository.FlowFileRecord;

public class AvailableSeekingPartitioner
implements FlowFilePartitioner {
    private final FlowFilePartitioner partitionerDelegate;
    private final Function<QueueSize, Boolean> fullCheck;

    public AvailableSeekingPartitioner(FlowFilePartitioner partitionerDelegate, Function<QueueSize, Boolean> fullCheck) {
        this.partitionerDelegate = partitionerDelegate;
        this.fullCheck = fullCheck;
    }

    @Override
    public QueuePartition getPartition(FlowFileRecord flowFile, QueuePartition[] partitions, QueuePartition localPartition) {
        for (int attemptCounter = 0; attemptCounter < partitions.length; ++attemptCounter) {
            QueuePartition selectedPartition = this.partitionerDelegate.getPartition(flowFile, partitions, localPartition);
            if (this.fullCheck.apply(selectedPartition.size()).booleanValue()) continue;
            return selectedPartition;
        }
        return this.partitionerDelegate.getPartition(flowFile, partitions, localPartition);
    }

    @Override
    public boolean isRebalanceOnClusterResize() {
        return this.partitionerDelegate.isRebalanceOnClusterResize();
    }

    @Override
    public boolean isRebalanceOnFailure() {
        return this.partitionerDelegate.isRebalanceOnFailure();
    }

    @Override
    public boolean isPartitionStatic() {
        return this.partitionerDelegate.isPartitionStatic();
    }
}

