/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextManager;

public class StandardParameterContextManager
implements ParameterContextManager {
    private final Map<String, ParameterContext> parameterContexts = new HashMap<String, ParameterContext>();

    public synchronized ParameterContext getParameterContext(String id) {
        return this.parameterContexts.get(id);
    }

    public synchronized void addParameterContext(ParameterContext parameterContext) {
        Objects.requireNonNull(parameterContext);
        if (this.parameterContexts.containsKey(parameterContext.getIdentifier())) {
            throw new IllegalStateException("Cannot add Parameter Context because another Parameter Context already exists with the same ID");
        }
        for (ParameterContext context : this.parameterContexts.values()) {
            if (!context.getName().equals(parameterContext.getName())) continue;
            throw new IllegalStateException("Cannot add Parameter Context because another Parameter Context already exists with the name '" + parameterContext + "'");
        }
        this.parameterContexts.put(parameterContext.getIdentifier(), parameterContext);
    }

    public synchronized ParameterContext removeParameterContext(String parameterContextId) {
        Objects.requireNonNull(parameterContextId);
        return this.parameterContexts.remove(parameterContextId);
    }

    public synchronized Set<ParameterContext> getParameterContexts() {
        return new HashSet<ParameterContext>(this.parameterContexts.values());
    }
}

