/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.web.api.dto.BundleDTO;

public final class BundleUtils {
    private static BundleCoordinate findBundleForType(ExtensionManager extensionManager, String type, BundleCoordinate desiredCoordinate) {
        List bundles = extensionManager.getBundles(type);
        if (bundles.isEmpty()) {
            throw new IllegalStateException(String.format("%s is not known to this NiFi instance.", type));
        }
        if (bundles.size() > 1) {
            if (desiredCoordinate == null) {
                throw new IllegalStateException(String.format("Multiple versions of %s exist.", type));
            }
            throw new IllegalStateException(String.format("Multiple versions of %s exist. No exact match for %s.", type, desiredCoordinate));
        }
        return ((org.apache.nifi.bundle.Bundle)bundles.get(0)).getBundleDetails().getCoordinate();
    }

    private static BundleCoordinate findCompatibleBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO, boolean allowCompatibleBundle) {
        BundleCoordinate coordinate = new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
        org.apache.nifi.bundle.Bundle bundle = extensionManager.getBundle(coordinate);
        if (bundle == null) {
            if (allowCompatibleBundle) {
                return BundleUtils.findBundleForType(extensionManager, type, coordinate);
            }
            throw new IllegalStateException(String.format("%s from %s is not known to this NiFi instance.", type, coordinate));
        }
        List bundlesForType = extensionManager.getBundles(type).stream().map(b -> b.getBundleDetails().getCoordinate()).collect(Collectors.toList());
        if (bundlesForType.contains(coordinate)) {
            return coordinate;
        }
        throw new IllegalStateException(String.format("Found bundle %s but does not support %s", coordinate, type));
    }

    public static BundleCoordinate getBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(extensionManager, type, null);
        }
        return BundleUtils.findCompatibleBundle(extensionManager, type, bundleDTO, false);
    }

    public static BundleCoordinate getCompatibleBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(extensionManager, type, null);
        }
        return BundleUtils.findCompatibleBundle(extensionManager, type, bundleDTO, true);
    }

    public static void discoverCompatibleBundles(ExtensionManager extensionManager, VersionedProcessGroup versionedGroup) {
        if (versionedGroup.getProcessors() != null) {
            versionedGroup.getProcessors().forEach(processor -> {
                BundleCoordinate coordinate = BundleUtils.getCompatibleBundle(extensionManager, processor.getType(), BundleUtils.createBundleDto(processor.getBundle()));
                processor.setBundle(BundleUtils.createBundle(coordinate));
            });
        }
        if (versionedGroup.getControllerServices() != null) {
            versionedGroup.getControllerServices().forEach(controllerService -> {
                BundleCoordinate coordinate = BundleUtils.getCompatibleBundle(extensionManager, controllerService.getType(), BundleUtils.createBundleDto(controllerService.getBundle()));
                controllerService.setBundle(BundleUtils.createBundle(coordinate));
            });
        }
        if (versionedGroup.getProcessGroups() != null) {
            versionedGroup.getProcessGroups().forEach(processGroup -> BundleUtils.discoverCompatibleBundles(extensionManager, processGroup));
        }
    }

    public static BundleCoordinate discoverCompatibleBundle(ExtensionManager extensionManager, String type, Bundle bundle) {
        return BundleUtils.getCompatibleBundle(extensionManager, type, BundleUtils.createBundleDto(bundle));
    }

    private static Bundle createBundle(BundleCoordinate coordinate) {
        Bundle bundle = new Bundle();
        bundle.setArtifact(coordinate.getId());
        bundle.setGroup(coordinate.getGroup());
        bundle.setVersion(coordinate.getVersion());
        return bundle;
    }

    public static BundleDTO createBundleDto(Bundle bundle) {
        BundleDTO dto = new BundleDTO();
        dto.setArtifact(bundle.getArtifact());
        dto.setGroup(bundle.getGroup());
        dto.setVersion(bundle.getVersion());
        return dto;
    }
}

