/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.connectable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.NiFiProperties;

public class LocalPort
extends AbstractPort {
    static final String MAX_CONCURRENT_TASKS_PROP_NAME = "_nifi.funnel.max.concurrent.tasks";
    static final String MAX_TRANSFERRED_FLOWFILES_PROP_NAME = "_nifi.funnel.max.transferred.flowfiles";
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    final int maxIterations;

    public LocalPort(String id, String name, ConnectableType type, ProcessScheduler scheduler, NiFiProperties nifiProperties) {
        super(id, name, type, scheduler);
        int maxConcurrentTasks = Integer.parseInt(nifiProperties.getProperty(MAX_CONCURRENT_TASKS_PROP_NAME, "1"));
        this.setMaxConcurrentTasks(maxConcurrentTasks);
        int maxTransferredFlowFiles = Integer.parseInt(nifiProperties.getProperty(MAX_TRANSFERRED_FLOWFILES_PROP_NAME, "10000"));
        this.maxIterations = Math.max(1, (int)Math.ceil((double)maxTransferredFlowFiles / 1000.0));
    }

    private boolean[] validateConnections() {
        boolean requireInput = true;
        boolean requireOutput = true;
        return new boolean[]{true, this.hasIncomingConnection(), true, !this.getConnections(Relationship.ANONYMOUS).isEmpty()};
    }

    public boolean isValid() {
        boolean[] connectionRequirements = this.validateConnections();
        return !(connectionRequirements[0] && !connectionRequirements[1] || connectionRequirements[2] && !connectionRequirements[3]);
    }

    public Collection<ValidationResult> getValidationErrors() {
        boolean[] connectionRequirements = this.validateConnections();
        ArrayList<ValidationResult> validationErrors = new ArrayList<ValidationResult>();
        if (connectionRequirements[0] && !connectionRequirements[1]) {
            validationErrors.add(new ValidationResult.Builder().explanation("Port has no incoming connections").subject(String.format("Port '%s'", this.getName())).valid(false).build());
        }
        if (connectionRequirements[2] && !connectionRequirements[3]) {
            validationErrors.add(new ValidationResult.Builder().explanation("Port has no outgoing connections").subject(String.format("Port '%s'", this.getName())).valid(false).build());
        }
        return validationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) {
        this.readLock.lock();
        try {
            Set available = context.getAvailableRelationships();
            int iterations = 0;
            while (!available.isEmpty()) {
                List flowFiles = session.get(1000);
                if (flowFiles.isEmpty()) {
                    break;
                }
                session.transfer((Collection)flowFiles, Relationship.ANONYMOUS);
                session.commit();
                if (flowFiles.size() < 1000) break;
                if (++iterations >= this.maxIterations) {
                    break;
                }
                available = context.getAvailableRelationships();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void updateConnection(Connection connection) throws IllegalStateException {
        this.writeLock.lock();
        try {
            super.updateConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addConnection(Connection connection) throws IllegalArgumentException {
        this.writeLock.lock();
        try {
            super.addConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeConnection(Connection connection) throws IllegalArgumentException, IllegalStateException {
        this.writeLock.lock();
        try {
            super.removeConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            Set set = super.getConnections();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Connection> getConnections(Relationship relationship) {
        this.readLock.lock();
        try {
            Set set = super.getConnections(relationship);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Connection> getIncomingConnections() {
        this.readLock.lock();
        try {
            List list = super.getIncomingConnections();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasIncomingConnection() {
        this.readLock.lock();
        try {
            boolean bl = super.hasIncomingConnection();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isTriggerWhenEmpty() {
        return false;
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return SchedulingStrategy.TIMER_DRIVEN;
    }

    public boolean isSideEffectFree() {
        return true;
    }

    public String getComponentType() {
        return "Local Port";
    }
}

