/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.connectable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.queue.ConnectionEventListener;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileQueueFactory;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.scheduling.SchedulingStrategy;

public final class StandardConnection
implements Connection,
ConnectionEventListener {
    private final String id;
    private final AtomicReference<ProcessGroup> processGroup;
    private final AtomicReference<String> name;
    private final AtomicReference<List<Position>> bendPoints;
    private final Connectable source;
    private final AtomicReference<Connectable> destination;
    private final AtomicReference<Collection<Relationship>> relationships;
    private final AtomicInteger labelIndex = new AtomicInteger(1);
    private final AtomicLong zIndex = new AtomicLong(0L);
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final ProcessScheduler scheduler;
    private final FlowFileQueueFactory flowFileQueueFactory;
    private final boolean clustered;
    private final int hashCode;
    private volatile FlowFileQueue flowFileQueue;

    private StandardConnection(Builder builder) {
        this.id = builder.id;
        this.name = new AtomicReference<String>(builder.name);
        this.bendPoints = new AtomicReference(Collections.unmodifiableList(new ArrayList(builder.bendPoints)));
        this.processGroup = new AtomicReference<ProcessGroup>(builder.processGroup);
        this.source = builder.source;
        this.destination = new AtomicReference<Connectable>(builder.destination);
        this.relationships = new AtomicReference(Collections.unmodifiableCollection(builder.relationships));
        this.scheduler = builder.scheduler;
        this.flowFileQueueFactory = builder.flowFileQueueFactory;
        this.clustered = builder.clustered;
        this.flowFileQueue = this.flowFileQueueFactory.createFlowFileQueue(LoadBalanceStrategy.DO_NOT_LOAD_BALANCE, null, this);
        this.hashCode = new HashCodeBuilder(7, 67).append((Object)this.id).toHashCode();
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        return new Resource(){

            public String getIdentifier() {
                return "/connections/" + StandardConnection.this.getIdentifier();
            }

            public String getName() {
                String name = StandardConnection.this.getName();
                Collection<Relationship> relationships = StandardConnection.this.getRelationships();
                if (name == null && CollectionUtils.isNotEmpty(relationships)) {
                    name = StringUtils.join((Iterable)relationships.stream().map(relationship -> relationship.getName()).collect(Collectors.toSet()), (String)", ");
                }
                if (name == null) {
                    name = "Connection";
                }
                return name;
            }

            public String getSafeDescription() {
                return "Connection " + StandardConnection.this.getIdentifier();
            }
        };
    }

    @Override
    public void triggerDestinationEvent() {
        if (this.getDestination().getSchedulingStrategy() == SchedulingStrategy.EVENT_DRIVEN) {
            this.scheduler.registerEvent(this.getDestination());
        }
    }

    @Override
    public void triggerSourceEvent() {
        if (this.getSource().getSchedulingStrategy() == SchedulingStrategy.EVENT_DRIVEN) {
            this.scheduler.registerEvent(this.getSource());
        }
    }

    public Authorizable getSourceAuthorizable() {
        Connectable sourceConnectable = this.getSource();
        Object sourceAuthorizable = sourceConnectable instanceof RemoteGroupPort ? ((RemoteGroupPort)sourceConnectable).getRemoteProcessGroup() : sourceConnectable;
        return sourceAuthorizable;
    }

    public Authorizable getDestinationAuthorizable() {
        Connectable destinationConnectable = this.getDestination();
        Object destinationAuthorizable = destinationConnectable instanceof RemoteGroupPort ? ((RemoteGroupPort)destinationConnectable).getRemoteProcessGroup() : destinationConnectable;
        return destinationAuthorizable;
    }

    public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        if (user == null) {
            return AuthorizationResult.denied((String)"Unknown user.");
        }
        AuthorizationResult sourceResult = this.getSourceAuthorizable().checkAuthorization(authorizer, action, user, resourceContext);
        if (AuthorizationResult.Result.Denied.equals((Object)sourceResult.getResult())) {
            return sourceResult;
        }
        return this.getDestinationAuthorizable().checkAuthorization(authorizer, action, user, resourceContext);
    }

    public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException("Unknown user.");
        }
        this.getSourceAuthorizable().authorize(authorizer, action, user, resourceContext);
        this.getDestinationAuthorizable().authorize(authorizer, action, user, resourceContext);
    }

    public List<Position> getBendPoints() {
        return this.bendPoints.get();
    }

    public void setBendPoints(List<Position> position) {
        this.bendPoints.set(Collections.unmodifiableList(new ArrayList<Position>(position)));
    }

    public int getLabelIndex() {
        return this.labelIndex.get();
    }

    public void setLabelIndex(int labelIndex) {
        this.labelIndex.set(labelIndex);
    }

    public long getZIndex() {
        return this.zIndex.get();
    }

    public void setZIndex(long zIndex) {
        this.zIndex.set(zIndex);
    }

    public Connectable getSource() {
        return this.source;
    }

    public Connectable getDestination() {
        return this.destination.get();
    }

    public Collection<Relationship> getRelationships() {
        return this.relationships.get();
    }

    public FlowFileQueue getFlowFileQueue() {
        return this.flowFileQueue;
    }

    public void setProcessGroup(ProcessGroup newGroup) {
        ProcessGroup currentGroup = this.processGroup.get();
        try {
            this.processGroup.set(newGroup);
        }
        catch (RuntimeException e) {
            this.processGroup.set(currentGroup);
            throw e;
        }
    }

    public void setRelationships(Collection<Relationship> newRelationships) {
        Collection<Relationship> currentRelationships = this.relationships.get();
        if (currentRelationships.equals(newRelationships)) {
            return;
        }
        try {
            this.getSource().verifyCanUpdate();
        }
        catch (IllegalStateException ise) {
            throw new IllegalStateException("Cannot update the relationships for Connection", ise);
        }
        try {
            this.relationships.set(new ArrayList<Relationship>(newRelationships));
            this.getSource().updateConnection((Connection)this);
        }
        catch (RuntimeException e) {
            this.relationships.set(currentRelationships);
            throw e;
        }
    }

    public void setDestination(Connectable newDestination) {
        Connectable previousDestination = this.destination.get();
        if (previousDestination.equals(newDestination)) {
            return;
        }
        if (previousDestination.isRunning() && !(previousDestination instanceof Funnel) && !(previousDestination instanceof LocalPort)) {
            throw new IllegalStateException("Cannot change destination of Connection because the current destination is running");
        }
        if (this.getFlowFileQueue().isUnacknowledgedFlowFile()) {
            throw new IllegalStateException("Cannot change destination of Connection because FlowFiles from this Connection are currently held by " + previousDestination);
        }
        if (newDestination instanceof Funnel && newDestination.equals(this.source)) {
            throw new IllegalStateException("Funnels do not support self-looping connections.");
        }
        try {
            previousDestination.removeConnection((Connection)this);
            this.destination.set(newDestination);
            this.getSource().updateConnection((Connection)this);
            newDestination.addConnection((Connection)this);
            this.scheduler.registerEvent(newDestination);
        }
        catch (RuntimeException e) {
            this.destination.set(previousDestination);
            throw e;
        }
    }

    public void lock() {
        this.flowFileQueue.lock();
    }

    public void unlock() {
        this.flowFileQueue.unlock();
    }

    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords) {
        return this.flowFileQueue.poll(filter, expiredRecords);
    }

    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords) {
        return this.flowFileQueue.poll(expiredRecords);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Connection)) {
            return false;
        }
        Connection con = (Connection)other;
        return new EqualsBuilder().append((Object)this.id, (Object)con.getIdentifier()).isEquals();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Connection[ID=" + this.getIdentifier() + ", Source ID=" + this.getSource().getIdentifier() + ", Dest ID=" + this.getDestination().getIdentifier() + "]";
    }

    public void enqueue(FlowFileRecord flowFile) {
        this.flowFileQueue.put(flowFile);
    }

    public void enqueue(Collection<FlowFileRecord> flowFiles) {
        this.flowFileQueue.putAll(flowFiles);
    }

    public void verifyCanUpdate() {
    }

    public void verifyCanDelete() {
        if (!this.flowFileQueue.isEmpty()) {
            throw new IllegalStateException("Queue not empty for " + this.getIdentifier());
        }
        if (this.source.isRunning() && !ConnectableType.FUNNEL.equals((Object)this.source.getConnectableType())) {
            throw new IllegalStateException("Source of Connection (" + this.source.getIdentifier() + ") is running");
        }
        Connectable dest = this.destination.get();
        if (dest.isRunning() && !ConnectableType.FUNNEL.equals((Object)dest.getConnectableType())) {
            throw new IllegalStateException("Destination of Connection (" + dest.getIdentifier() + ") is running");
        }
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException(this + " is already under version control");
        }
    }

    public static class Builder {
        private final ProcessScheduler scheduler;
        private String id = UUID.randomUUID().toString();
        private String name;
        private List<Position> bendPoints = new ArrayList<Position>();
        private ProcessGroup processGroup;
        private Connectable source;
        private Connectable destination;
        private Collection<Relationship> relationships;
        private FlowFileQueueFactory flowFileQueueFactory;
        private boolean clustered = false;

        public Builder(ProcessScheduler scheduler) {
            this.scheduler = scheduler;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder source(Connectable source) {
            this.source = source;
            return this;
        }

        public Builder processGroup(ProcessGroup group) {
            this.processGroup = group;
            return this;
        }

        public Builder destination(Connectable destination) {
            this.destination = destination;
            return this;
        }

        public Builder relationships(Collection<Relationship> relationships) {
            this.relationships = new ArrayList<Relationship>(relationships);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder bendPoints(List<Position> bendPoints) {
            this.bendPoints.clear();
            this.bendPoints.addAll(bendPoints);
            return this;
        }

        public Builder addBendPoint(Position bendPoint) {
            this.bendPoints.add(bendPoint);
            return this;
        }

        public Builder flowFileQueueFactory(FlowFileQueueFactory flowFileQueueFactory) {
            this.flowFileQueueFactory = flowFileQueueFactory;
            return this;
        }

        public Builder clustered(boolean clustered) {
            this.clustered = clustered;
            return this;
        }

        public StandardConnection build() {
            if (this.source == null) {
                throw new IllegalStateException("Cannot build a Connection without a Source");
            }
            if (this.destination == null) {
                throw new IllegalStateException("Cannot build a Connection without a Destination");
            }
            if (this.flowFileQueueFactory == null) {
                throw new IllegalStateException("Cannot build a Connection without a FlowFileQueueFactory");
            }
            if (this.relationships == null) {
                this.relationships = new ArrayList<Relationship>();
            }
            if (this.relationships.isEmpty()) {
                if (this.source.getConnectableType() == ConnectableType.PROCESSOR) {
                    throw new IllegalStateException("Cannot build a Connection without any relationships");
                }
                this.relationships.add(Relationship.ANONYMOUS);
            }
            return new StandardConnection(this);
        }
    }
}

