/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.controller.lifecycle.TaskTermination;
import org.apache.nifi.processor.exception.TerminatedTaskException;

public class TaskTerminationOutputStream
extends OutputStream {
    private final TaskTermination taskTermination;
    private final OutputStream delegate;
    private final Runnable terminatedCallback;

    public TaskTerminationOutputStream(OutputStream delegate, TaskTermination taskTermination, Runnable terminatedCallback) {
        this.delegate = delegate;
        this.taskTermination = taskTermination;
        this.terminatedCallback = terminatedCallback;
    }

    private void verifyNotTerminated() {
        if (this.taskTermination.isTerminated()) {
            TerminatedTaskException tte = new TerminatedTaskException();
            if (this.terminatedCallback != null) {
                try {
                    this.terminatedCallback.run();
                }
                catch (Exception e) {
                    tte.addSuppressed((Throwable)e);
                }
            }
            throw tte;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.verifyNotTerminated();
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.verifyNotTerminated();
        this.delegate.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.verifyNotTerminated();
        this.delegate.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.verifyNotTerminated();
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        block5: {
            try {
                this.delegate.close();
            }
            catch (Exception e) {
                if (!this.taskTermination.isTerminated()) break block5;
                TerminatedTaskException tte = new TerminatedTaskException();
                tte.addSuppressed((Throwable)e);
                if (this.terminatedCallback != null) {
                    try {
                        this.terminatedCallback.run();
                    }
                    catch (Exception callbackException) {
                        tte.addSuppressed((Throwable)callbackException);
                    }
                }
                throw tte;
            }
        }
        this.verifyNotTerminated();
    }
}

