/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.FormatUtils;

public class StandardConfigurationContext
implements ConfigurationContext {
    private final ComponentNode component;
    private final ControllerServiceLookup serviceLookup;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final VariableRegistry variableRegistry;
    private final String schedulingPeriod;
    private final Long schedulingNanos;

    public StandardConfigurationContext(ComponentNode component, ControllerServiceLookup serviceLookup, String schedulingPeriod, VariableRegistry variableRegistry) {
        this.component = component;
        this.serviceLookup = serviceLookup;
        this.schedulingPeriod = schedulingPeriod;
        this.variableRegistry = variableRegistry;
        this.schedulingNanos = schedulingPeriod == null ? null : (FormatUtils.TIME_DURATION_PATTERN.matcher(schedulingPeriod).matches() ? Long.valueOf(FormatUtils.getTimeDuration((String)schedulingPeriod, (TimeUnit)TimeUnit.NANOSECONDS)) : null);
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry entry : component.getEffectivePropertyValues().entrySet()) {
            PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String resolvedValue;
        String configuredValue = this.component.getEffectivePropertyValue(property);
        String string = resolvedValue = configuredValue == null ? property.getDefaultValue() : configuredValue;
        if (resolvedValue == null) {
            PropertyDescriptor resolvedDescriptor = this.component.getPropertyDescriptor(property.getName());
            return new StandardPropertyValue(resolvedDescriptor.getDefaultValue(), this.serviceLookup, this.component.getParameterLookup(), this.preparedQueries.get(property), this.variableRegistry);
        }
        return new StandardPropertyValue(resolvedValue, this.serviceLookup, this.component.getParameterLookup(), this.preparedQueries.get(property), this.variableRegistry);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.component.getEffectivePropertyValues();
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public Long getSchedulingPeriod(TimeUnit timeUnit) {
        return this.schedulingNanos == null ? null : Long.valueOf(timeUnit.convert(this.schedulingNanos, TimeUnit.NANOSECONDS));
    }

    public String getName() {
        return this.component.getName();
    }
}

