/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceNotValidException;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.Severity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceProvider
implements ControllerServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardControllerServiceProvider.class);
    private final StandardProcessScheduler processScheduler;
    private final BulletinRepository bulletinRepo;
    private final FlowController flowController;
    private final FlowManager flowManager;
    private final ConcurrentMap<String, ControllerServiceNode> serviceCache = new ConcurrentHashMap<String, ControllerServiceNode>();

    public StandardControllerServiceProvider(FlowController flowController, StandardProcessScheduler scheduler, BulletinRepository bulletinRepo) {
        this.flowController = flowController;
        this.processScheduler = scheduler;
        this.bulletinRepo = bulletinRepo;
        this.flowManager = flowController.getFlowManager();
    }

    public void onControllerServiceAdded(ControllerServiceNode serviceNode) {
        this.serviceCache.putIfAbsent(serviceNode.getIdentifier(), serviceNode);
    }

    public Set<ComponentNode> disableReferencingServices(ControllerServiceNode serviceNode) {
        List toDisable = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        HashSet serviceSet = new HashSet(toDisable);
        HashSet<ComponentNode> updated = new HashSet<ComponentNode>();
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
            updated.add((ComponentNode)nodeToDisable);
        }
        Collections.reverse(toDisable);
        this.processScheduler.disableControllerServices(toDisable);
        return updated;
    }

    public Set<ComponentNode> scheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List processors = serviceNode.getReferences().findRecursiveReferences(ProcessorNode.class);
        List reportingTasks = serviceNode.getReferences().findRecursiveReferences(ReportingTaskNode.class);
        HashSet<ComponentNode> updated = new HashSet<ComponentNode>();
        for (ProcessorNode node : processors) {
            if (node.getScheduledState() == ScheduledState.DISABLED) continue;
            node.verifyCanStart();
            updated.add((ComponentNode)node);
        }
        for (ProcessorNode node : reportingTasks) {
            if (node.getScheduledState() == ScheduledState.DISABLED) continue;
            node.verifyCanStart();
            updated.add((ComponentNode)node);
        }
        for (ProcessorNode node : processors) {
            if (node.getScheduledState() == ScheduledState.DISABLED) continue;
            node.getProcessGroup().startProcessor(node, true);
            updated.add((ComponentNode)node);
        }
        for (ProcessorNode node : reportingTasks) {
            if (node.getScheduledState() == ScheduledState.DISABLED) continue;
            this.processScheduler.schedule((ReportingTaskNode)node);
            updated.add((ComponentNode)node);
        }
        return updated;
    }

    public Set<ComponentNode> unscheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List processors = serviceNode.getReferences().findRecursiveReferences(ProcessorNode.class);
        List reportingTasks = serviceNode.getReferences().findRecursiveReferences(ReportingTaskNode.class);
        HashSet<ComponentNode> updated = new HashSet<ComponentNode>();
        for (ProcessorNode node : processors) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            node.verifyCanStop();
        }
        for (ProcessorNode node : reportingTasks) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            node.verifyCanStop();
        }
        for (ProcessorNode node : processors) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            node.getProcessGroup().stopProcessor(node);
            updated.add((ComponentNode)node);
        }
        for (ProcessorNode node : reportingTasks) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            this.processScheduler.unschedule((ReportingTaskNode)node);
            updated.add((ComponentNode)node);
        }
        return updated;
    }

    public CompletableFuture<Void> enableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanEnable();
        serviceNode.reloadAdditionalResourcesIfNecessary();
        return this.processScheduler.enableControllerService(serviceNode);
    }

    public void enableControllerServices(Collection<ControllerServiceNode> serviceNodes) {
        boolean shouldStart = true;
        Iterator<ControllerServiceNode> serviceIter = serviceNodes.iterator();
        while (serviceIter.hasNext() && shouldStart) {
            ControllerServiceNode controllerServiceNode = serviceIter.next();
            List requiredServices = controllerServiceNode.getRequiredControllerServices();
            for (ControllerServiceNode requiredService : requiredServices) {
                if (requiredService.isActive() || serviceNodes.contains(requiredService)) continue;
                shouldStart = false;
                logger.debug("Will not start {} because required service {} is not active and is not part of the collection of things to start", serviceNodes, (Object)requiredService);
            }
        }
        if (shouldStart) {
            for (ControllerServiceNode controllerServiceNode : serviceNodes) {
                try {
                    if (controllerServiceNode.isActive()) continue;
                    Future<Void> future = this.enableControllerServiceDependenciesFirst(controllerServiceNode);
                    future.get(30L, TimeUnit.SECONDS);
                    logger.debug("Successfully enabled {}; service state = {}", (Object)controllerServiceNode, (Object)controllerServiceNode.getState());
                }
                catch (ControllerServiceNotValidException csnve) {
                    logger.warn("Failed to enable service {} because it is not currently valid", (Object)controllerServiceNode);
                }
                catch (Exception e) {
                    logger.error("Failed to enable " + controllerServiceNode, (Throwable)e);
                    if (this.bulletinRepo == null) continue;
                    this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not start " + controllerServiceNode + " due to " + e)));
                }
            }
        }
    }

    public Future<Void> enableControllerServicesAsync(Collection<ControllerServiceNode> serviceNodes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.processScheduler.submitFrameworkTask(() -> {
            this.enableControllerServices(serviceNodes, future);
            future.complete(null);
        });
        return future;
    }

    private void enableControllerServices(Collection<ControllerServiceNode> serviceNodes, CompletableFuture<Void> completableFuture) {
        for (ControllerServiceNode controllerServiceNode : serviceNodes) {
            List requiredServices = controllerServiceNode.getRequiredControllerServices();
            for (ControllerServiceNode requiredService : requiredServices) {
                if (requiredService.isActive() || serviceNodes.contains(requiredService)) continue;
                logger.error("Cannot enable {} because it has a dependency on {}, which is not enabled", (Object)controllerServiceNode, (Object)requiredService);
                completableFuture.completeExceptionally(new IllegalStateException("Cannot enable " + controllerServiceNode + " because it has a dependency on " + requiredService + ", which is not enabled"));
                return;
            }
        }
        block7: for (ControllerServiceNode controllerServiceNode : serviceNodes) {
            if (completableFuture.isCancelled()) {
                return;
            }
            try {
                if (controllerServiceNode.isActive()) continue;
                Future<Void> future = this.enableControllerServiceDependenciesFirst(controllerServiceNode);
                while (true) {
                    try {
                        future.get(1L, TimeUnit.SECONDS);
                        logger.debug("Successfully enabled {}; service state = {}", (Object)controllerServiceNode, (Object)controllerServiceNode.getState());
                        continue block7;
                    }
                    catch (TimeoutException e) {
                        if (!completableFuture.isCancelled()) continue;
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to enable service {}", (Object)controllerServiceNode, (Object)e);
                        completableFuture.completeExceptionally(e);
                        if (this.bulletinRepo != null) {
                            this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not enable " + controllerServiceNode + " due to " + e)));
                        }
                        return;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Failed to enable " + controllerServiceNode, (Throwable)e);
                if (this.bulletinRepo == null) continue;
                this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not start " + controllerServiceNode + " due to " + e)));
            }
        }
    }

    private Future<Void> enableControllerServiceDependenciesFirst(ControllerServiceNode serviceNode) {
        HashMap<ControllerServiceNode, Future<Void>> futures = new HashMap<ControllerServiceNode, Future<Void>>();
        for (ControllerServiceNode controllerServiceNode : serviceNode.getRequiredControllerServices()) {
            if (controllerServiceNode.isActive()) continue;
            logger.debug("Before enabling {}, will enable dependent Controller Service {}", (Object)serviceNode, (Object)controllerServiceNode);
            futures.put(controllerServiceNode, this.enableControllerServiceDependenciesFirst(controllerServiceNode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("All dependent services for {} have now begun enabling. Will wait for them to complete", (Object)serviceNode);
        }
        for (Map.Entry entry : futures.entrySet()) {
            ControllerServiceNode dependentService = (ControllerServiceNode)entry.getKey();
            Future future = (Future)entry.getValue();
            try {
                future.get(30L, TimeUnit.SECONDS);
                logger.debug("Successfully enabled dependent service {}; service state = {}", (Object)dependentService, (Object)dependentService.getState());
            }
            catch (Exception e) {
                logger.error("Failed to enable service {}, so may be unable to enable {}", new Object[]{dependentService, serviceNode, e});
            }
        }
        logger.debug("All dependent services have been enabled for {}; will now start service itself", (Object)serviceNode);
        return this.enableControllerService(serviceNode);
    }

    static List<List<ControllerServiceNode>> determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap) {
        ArrayList<List<ControllerServiceNode>> orderedNodeLists = new ArrayList<List<ControllerServiceNode>>();
        for (ControllerServiceNode node : serviceNodeMap.values()) {
            ArrayList<ControllerServiceNode> branch = new ArrayList<ControllerServiceNode>();
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, node, branch, new HashSet<ControllerServiceNode>());
            orderedNodeLists.add(branch);
        }
        return orderedNodeLists;
    }

    private static void determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap, ControllerServiceNode contextNode, List<ControllerServiceNode> orderedNodes, Set<ControllerServiceNode> visited) {
        if (visited.contains(contextNode)) {
            return;
        }
        for (Map.Entry entry : contextNode.getEffectivePropertyValues().entrySet()) {
            ControllerServiceNode referencedNode;
            String referencedServiceId;
            if (((PropertyDescriptor)entry.getKey()).getControllerServiceDefinition() == null || (referencedServiceId = (String)entry.getValue()) == null || orderedNodes.contains(referencedNode = serviceNodeMap.get(referencedServiceId))) continue;
            visited.add(contextNode);
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, referencedNode, orderedNodes, visited);
        }
        if (!orderedNodes.contains(contextNode)) {
            orderedNodes.add(contextNode);
        }
    }

    public CompletableFuture<Void> disableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanDisable();
        return this.processScheduler.disableControllerService(serviceNode);
    }

    public Future<Void> disableControllerServicesAsync(Collection<ControllerServiceNode> serviceNodes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.processScheduler.submitFrameworkTask(() -> {
            this.disableControllerServices(serviceNodes, future);
            future.complete(null);
        });
        return future;
    }

    private void disableControllerServices(Collection<ControllerServiceNode> serviceNodes, CompletableFuture<Void> future) {
        HashSet<ControllerServiceNode> serviceNodeSet = new HashSet<ControllerServiceNode>(serviceNodes);
        for (ControllerServiceNode serviceNode : serviceNodes) {
            List references = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
            for (ControllerServiceNode reference : references) {
                if (!reference.isActive()) continue;
                try {
                    reference.verifyCanDisable(serviceNodeSet);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }
        }
        block7: for (ControllerServiceNode serviceNode : serviceNodes) {
            if (!serviceNode.isActive()) continue;
            this.disableReferencingServices(serviceNode);
            CompletableFuture<Void> serviceFuture = this.disableControllerService(serviceNode);
            while (true) {
                try {
                    serviceFuture.get(1L, TimeUnit.SECONDS);
                    continue block7;
                }
                catch (TimeoutException e) {
                    if (!future.isCancelled()) continue;
                    return;
                }
                catch (Exception e) {
                    logger.error("Failed to disable {}", (Object)serviceNode, (Object)e);
                    future.completeExceptionally(e);
                    continue;
                }
                break;
            }
        }
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? null : node.getProxiedControllerService();
    }

    private ProcessGroup getRootGroup() {
        return this.flowManager.getRootGroup();
    }

    public ControllerService getControllerServiceForComponent(String serviceIdentifier, String componentId) {
        ProcessGroup groupOfInterest;
        ProcessorNode procNode = this.flowManager.getProcessorNode(componentId);
        if (procNode == null) {
            ControllerServiceNode serviceNode = this.getControllerServiceNode(componentId);
            if (serviceNode == null) {
                ReportingTaskNode taskNode = this.flowController.getReportingTaskNode(componentId);
                if (taskNode == null) {
                    throw new IllegalStateException("Could not find any Processor, Reporting Task, or Controller Service with identifier " + componentId);
                }
                ControllerServiceNode rootServiceNode = this.flowManager.getRootControllerService(serviceIdentifier);
                return rootServiceNode == null ? null : rootServiceNode.getProxiedControllerService();
            }
            groupOfInterest = serviceNode.getProcessGroup();
        } else {
            groupOfInterest = procNode.getProcessGroup();
        }
        if (groupOfInterest == null) {
            ControllerServiceNode rootServiceNode = this.flowManager.getRootControllerService(serviceIdentifier);
            return rootServiceNode == null ? null : rootServiceNode.getProxiedControllerService();
        }
        Set servicesForGroup = groupOfInterest.getControllerServices(true);
        for (ControllerServiceNode serviceNode : servicesForGroup) {
            if (!serviceIdentifier.equals(serviceNode.getIdentifier())) continue;
            return serviceNode.getProxiedControllerService();
        }
        return null;
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.isControllerServiceEnabled(service.getIdentifier());
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node != null && ControllerServiceState.ENABLED == node.getState();
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node != null && ControllerServiceState.ENABLING == node.getState();
    }

    public ControllerServiceNode getControllerServiceNode(String serviceIdentifier) {
        ControllerServiceNode rootServiceNode = this.flowManager.getRootControllerService(serviceIdentifier);
        if (rootServiceNode != null) {
            return rootServiceNode;
        }
        return (ControllerServiceNode)this.serviceCache.get(serviceIdentifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType, String groupId) {
        Set serviceNodes;
        if (groupId == null) {
            serviceNodes = this.flowManager.getRootControllerServices();
        } else {
            ProcessGroup group = this.getRootGroup();
            if (!"root".equals(groupId) && !group.getIdentifier().equals(groupId)) {
                group = group.findProcessGroup(groupId);
            }
            if (group == null) {
                return Collections.emptySet();
            }
            serviceNodes = group.getControllerServices(true);
        }
        return serviceNodes.stream().filter(service -> serviceType.isAssignableFrom(service.getProxiedControllerService().getClass())).map(ComponentNode::getIdentifier).collect(Collectors.toSet());
    }

    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? null : node.getName();
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        Objects.requireNonNull(serviceNode);
        this.serviceCache.remove(serviceNode.getIdentifier());
        ProcessGroup group = serviceNode.getProcessGroup();
        if (group == null) {
            this.flowManager.removeRootControllerService(serviceNode);
            return;
        }
        group.removeControllerService(serviceNode);
        LogRepositoryFactory.removeRepository((String)serviceNode.getIdentifier());
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        extensionManager.removeInstanceClassLoader(serviceNode.getIdentifier());
        this.serviceCache.remove(serviceNode.getIdentifier());
    }

    public Collection<ControllerServiceNode> getNonRootControllerServices() {
        return this.serviceCache.values().stream().filter(serviceNode -> serviceNode.getProcessGroup() != null).collect(Collectors.toSet());
    }

    public Set<ComponentNode> enableReferencingServices(ControllerServiceNode serviceNode) {
        List recursiveReferences = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        logger.debug("Enabling the following Referencing Services for {}: {}", (Object)serviceNode, (Object)recursiveReferences);
        return this.enableReferencingServices(serviceNode, recursiveReferences);
    }

    private Set<ComponentNode> enableReferencingServices(ControllerServiceNode serviceNode, List<ControllerServiceNode> recursiveReferences) {
        if (!serviceNode.isActive()) {
            serviceNode.verifyCanEnable(new HashSet<ControllerServiceNode>(recursiveReferences));
        }
        HashSet<ComponentNode> updated = new HashSet<ComponentNode>();
        HashSet<ControllerServiceNode> ifEnabled = new HashSet<ControllerServiceNode>();
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            nodeToEnable.verifyCanEnable(ifEnabled);
            ifEnabled.add(nodeToEnable);
        }
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            logger.debug("Enabling {} because it references {}", (Object)nodeToEnable, (Object)serviceNode);
            this.enableControllerService(nodeToEnable);
            updated.add((ComponentNode)nodeToEnable);
        }
        return updated;
    }

    public void verifyCanEnableReferencingServices(ControllerServiceNode serviceNode) {
        List referencingServices = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        HashSet referencingServiceSet = new HashSet(referencingServices);
        for (ControllerServiceNode referencingService : referencingServices) {
            referencingService.verifyCanEnable(referencingServiceSet);
        }
    }

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List referencingServices = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        List referencingReportingTasks = serviceNode.getReferences().findRecursiveReferences(ReportingTaskNode.class);
        List referencingProcessors = serviceNode.getReferences().findRecursiveReferences(ProcessorNode.class);
        HashSet referencingServiceSet = new HashSet(referencingServices);
        for (ReportingTaskNode taskNode : referencingReportingTasks) {
            if (taskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            taskNode.verifyCanStart(referencingServiceSet);
        }
        for (ProcessorNode procNode : referencingProcessors) {
            if (procNode.getScheduledState() == ScheduledState.DISABLED) continue;
            procNode.verifyCanStart(referencingServiceSet);
        }
    }

    public void verifyCanDisableReferencingServices(ControllerServiceNode serviceNode) {
        List toDisable = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        HashSet serviceSet = new HashSet(toDisable);
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
        }
    }

    public void verifyCanStopReferencingComponents(ControllerServiceNode serviceNode) {
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Cannot obtain Controller Service Identifiers for service type " + serviceType + " without providing a Process Group Identifier");
    }

    public ExtensionManager getExtensionManager() {
        return this.flowController.getExtensionManager();
    }
}

