/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.analytics;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.status.analytics.ConnectionStatusAnalytics;
import org.apache.nifi.controller.status.analytics.ConnectionStatusAnalyticsEngine;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModelMapFactory;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingConnectionStatusAnalyticsEngine
extends ConnectionStatusAnalyticsEngine {
    private volatile Cache<String, StatusAnalytics> cache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();
    private static final Logger LOG = LoggerFactory.getLogger(CachingConnectionStatusAnalyticsEngine.class);

    public CachingConnectionStatusAnalyticsEngine(FlowManager flowManager, ComponentStatusRepository statusRepository, FlowFileEventRepository flowFileEventRepository, StatusAnalyticsModelMapFactory statusAnalyticsModelMapFactory, long predictionIntervalMillis, long queryIntervalMillis, String scoreName, double scoreThreshold) {
        super(flowManager, statusRepository, flowFileEventRepository, statusAnalyticsModelMapFactory, predictionIntervalMillis, queryIntervalMillis, scoreName, scoreThreshold);
    }

    @Override
    public StatusAnalytics getStatusAnalytics(String identifier) {
        StatusAnalytics connectionStatusAnalytics = (StatusAnalytics)this.cache.getIfPresent((Object)identifier);
        if (connectionStatusAnalytics == null) {
            LOG.debug("Creating new status analytics object for connection id: {}", (Object)identifier);
            connectionStatusAnalytics = super.getStatusAnalytics(identifier);
            this.cache.put((Object)identifier, (Object)connectionStatusAnalytics);
        } else {
            LOG.debug("Pulled existing analytics from cache for connection id: {}", (Object)identifier);
            ((ConnectionStatusAnalytics)connectionStatusAnalytics).refresh();
        }
        return connectionStatusAnalytics;
    }
}

