/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.analytics;

import java.util.Map;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.status.analytics.ConnectionStatusAnalytics;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsEngine;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModel;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModelMapFactory;
import org.apache.nifi.controller.status.analytics.StatusMetricExtractFunction;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStatusAnalyticsEngine
implements StatusAnalyticsEngine {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionStatusAnalyticsEngine.class);
    protected final ComponentStatusRepository statusRepository;
    protected final FlowManager flowManager;
    protected final FlowFileEventRepository flowFileEventRepository;
    protected final StatusAnalyticsModelMapFactory statusAnalyticsModelMapFactory;
    protected final long predictionIntervalMillis;
    protected final long queryIntervalMillis;
    protected final String scoreName;
    protected final double scoreThreshold;

    public ConnectionStatusAnalyticsEngine(FlowManager flowManager, ComponentStatusRepository statusRepository, FlowFileEventRepository flowFileEventRepository, StatusAnalyticsModelMapFactory statusAnalyticsModelMapFactory, long predictionIntervalMillis, long queryIntervalMillis, String scoreName, double scoreThreshold) {
        this.flowManager = flowManager;
        this.statusRepository = statusRepository;
        this.flowFileEventRepository = flowFileEventRepository;
        this.predictionIntervalMillis = predictionIntervalMillis;
        this.statusAnalyticsModelMapFactory = statusAnalyticsModelMapFactory;
        this.queryIntervalMillis = queryIntervalMillis;
        this.scoreName = scoreName;
        this.scoreThreshold = scoreThreshold;
    }

    public StatusAnalytics getStatusAnalytics(String identifier) {
        Map<String, Tuple<StatusAnalyticsModel, StatusMetricExtractFunction>> modelMap = this.statusAnalyticsModelMapFactory.getConnectionStatusModelMap();
        ConnectionStatusAnalytics connectionStatusAnalytics = new ConnectionStatusAnalytics(this.statusRepository, this.flowManager, this.flowFileEventRepository, modelMap, identifier, false);
        connectionStatusAnalytics.setIntervalTimeMillis(this.predictionIntervalMillis);
        connectionStatusAnalytics.setQueryIntervalMillis(this.queryIntervalMillis);
        connectionStatusAnalytics.setScoreName(this.scoreName);
        connectionStatusAnalytics.setScoreThreshold(this.scoreThreshold);
        connectionStatusAnalytics.refresh();
        return connectionStatusAnalytics;
    }
}

