/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterReferenceManager;

public class StandardParameterReferenceManager
implements ParameterReferenceManager {
    private final FlowManager flowManager;

    public StandardParameterReferenceManager(FlowManager flowManager) {
        this.flowManager = flowManager;
    }

    public Set<ProcessorNode> getProcessorsReferencing(ParameterContext parameterContext, String parameterName) {
        return this.getComponentsReferencing(parameterContext, parameterName, ProcessGroup::getProcessors);
    }

    public Set<ControllerServiceNode> getControllerServicesReferencing(ParameterContext parameterContext, String parameterName) {
        return this.getComponentsReferencing(parameterContext, parameterName, group -> group.getControllerServices(false));
    }

    public Set<ProcessGroup> getProcessGroupsBound(ParameterContext parameterContext) {
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        String contextId = parameterContext.getIdentifier();
        List referencingGroups = rootGroup.findAllProcessGroups(group -> group.getParameterContext() != null && group.getParameterContext().getIdentifier().equals(contextId));
        return new HashSet<ProcessGroup>(referencingGroups);
    }

    private <T extends ComponentNode> Set<T> getComponentsReferencing(ParameterContext parameterContext, String parameterName, Function<ProcessGroup, Collection<T>> componentFunction) {
        HashSet<ComponentNode> referencingComponents = new HashSet<ComponentNode>();
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        String contextId = parameterContext.getIdentifier();
        List referencingGroups = rootGroup.findAllProcessGroups(group -> group.getParameterContext() != null && group.getParameterContext().getIdentifier().equals(contextId));
        for (ProcessGroup group2 : referencingGroups) {
            for (ComponentNode componentNode : componentFunction.apply(group2)) {
                if (!this.isComponentReferencing(componentNode, parameterName)) continue;
                referencingComponents.add(componentNode);
            }
        }
        return referencingComponents;
    }

    private boolean isComponentReferencing(ComponentNode componentNode, String parameterName) {
        for (PropertyConfiguration configuration : componentNode.getProperties().values()) {
            if (configuration == null) continue;
            for (ParameterReference reference : configuration.getParameterReferences()) {
                if (!parameterName.equals(reference.getParameterName())) continue;
                return true;
            }
        }
        return false;
    }
}

