/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.lifecycle.TaskTermination;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.TerminatedTaskException;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.util.Connectables;

public class StandardProcessContext
implements ProcessContext,
ControllerServiceLookup {
    private final ProcessorNode procNode;
    private final ControllerServiceProvider controllerServiceProvider;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final StringEncryptor encryptor;
    private final StateManager stateManager;
    private final TaskTermination taskTermination;
    private final Map<PropertyDescriptor, String> properties;

    public StandardProcessContext(ProcessorNode processorNode, ControllerServiceProvider controllerServiceProvider, StringEncryptor encryptor, StateManager stateManager, TaskTermination taskTermination) {
        this.procNode = processorNode;
        this.controllerServiceProvider = controllerServiceProvider;
        this.encryptor = encryptor;
        this.stateManager = stateManager;
        this.taskTermination = taskTermination;
        this.properties = Collections.unmodifiableMap(processorNode.getEffectivePropertyValues());
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry entry : processorNode.getRawPropertyValues().entrySet()) {
            PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            if (value == null) continue;
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    private void verifyTaskActive() {
        if (this.taskTermination.isTerminated()) {
            throw new TerminatedTaskException();
        }
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        this.verifyTaskActive();
        String setPropertyValue = this.properties.get(descriptor);
        if (setPropertyValue != null) {
            return new StandardPropertyValue(setPropertyValue, (ControllerServiceLookup)this, this.procNode.getParameterLookup(), this.preparedQueries.get(descriptor), (VariableRegistry)this.procNode.getVariableRegistry());
        }
        PropertyDescriptor canonicalDescriptor = this.procNode.getProcessor().getPropertyDescriptor(descriptor.getName());
        String defaultValue = canonicalDescriptor.getDefaultValue();
        return new StandardPropertyValue(defaultValue, (ControllerServiceLookup)this, this.procNode.getParameterLookup(), this.preparedQueries.get(descriptor), (VariableRegistry)this.procNode.getVariableRegistry());
    }

    public PropertyValue getProperty(String propertyName) {
        this.verifyTaskActive();
        Processor processor = this.procNode.getProcessor();
        PropertyDescriptor descriptor = processor.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return null;
        }
        String setPropertyValue = this.properties.get(descriptor);
        String propValue = setPropertyValue == null ? descriptor.getDefaultValue() : setPropertyValue;
        return new StandardPropertyValue(propValue, (ControllerServiceLookup)this, this.procNode.getParameterLookup(), this.preparedQueries.get(descriptor), (VariableRegistry)this.procNode.getVariableRegistry());
    }

    public PropertyValue newPropertyValue(String rawValue) {
        this.verifyTaskActive();
        return new StandardPropertyValue(rawValue, (ControllerServiceLookup)this, this.procNode.getParameterLookup(), Query.prepareWithParametersPreEvaluated((String)rawValue), (VariableRegistry)this.procNode.getVariableRegistry());
    }

    public void yield() {
        this.verifyTaskActive();
        this.procNode.yield();
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        this.verifyTaskActive();
        return this.controllerServiceProvider.getControllerServiceForComponent(serviceIdentifier, this.procNode.getIdentifier());
    }

    public int getMaxConcurrentTasks() {
        this.verifyTaskActive();
        return this.procNode.getMaxConcurrentTasks();
    }

    public ExecutionNode getExecutionNode() {
        this.verifyTaskActive();
        return this.procNode.getExecutionNode();
    }

    public String getAnnotationData() {
        this.verifyTaskActive();
        return this.procNode.getAnnotationData();
    }

    public Map<PropertyDescriptor, String> getProperties() {
        this.verifyTaskActive();
        return this.properties;
    }

    public Map<String, String> getAllProperties() {
        this.verifyTaskActive();
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String encrypt(String unencrypted) {
        this.verifyTaskActive();
        return this.encryptor.encrypt(unencrypted);
    }

    public String decrypt(String encrypted) {
        this.verifyTaskActive();
        return this.encryptor.decrypt(encrypted);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        this.verifyTaskActive();
        if (!serviceType.isInterface()) {
            throw new IllegalArgumentException("ControllerServices may be referenced only via their interfaces; " + serviceType + " is not an interface");
        }
        return this.controllerServiceProvider.getControllerServiceIdentifiers(serviceType, this.procNode.getProcessGroup().getIdentifier());
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        this.verifyTaskActive();
        return this.controllerServiceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        this.verifyTaskActive();
        return this.controllerServiceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        this.verifyTaskActive();
        return this.controllerServiceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        this.verifyTaskActive();
        return this;
    }

    public Set<Relationship> getAvailableRelationships() {
        this.verifyTaskActive();
        HashSet<Relationship> set = new HashSet<Relationship>();
        for (Relationship relationship : this.procNode.getRelationships()) {
            Set connections = this.procNode.getConnections(relationship);
            if (connections.isEmpty()) {
                set.add(relationship);
                continue;
            }
            boolean available = true;
            for (Connection connection : connections) {
                if (!connection.getFlowFileQueue().isFull()) continue;
                available = false;
            }
            if (!available) continue;
            set.add(relationship);
        }
        return set;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        this.verifyTaskActive();
        return this.controllerServiceProvider.getControllerServiceName(serviceIdentifier);
    }

    public boolean hasIncomingConnection() {
        this.verifyTaskActive();
        return this.procNode.hasIncomingConnection();
    }

    public boolean hasNonLoopConnection() {
        this.verifyTaskActive();
        return Connectables.hasNonLoopConnection((Connectable)this.procNode);
    }

    public boolean hasConnection(Relationship relationship) {
        this.verifyTaskActive();
        Set connections = this.procNode.getConnections(relationship);
        return connections != null && !connections.isEmpty();
    }

    public boolean isExpressionLanguagePresent(PropertyDescriptor property) {
        this.verifyTaskActive();
        if (property == null || !property.isExpressionLanguageSupported()) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.getProperty(property).getValue());
        return elRanges != null && !elRanges.isEmpty();
    }

    public StateManager getStateManager() {
        this.verifyTaskActive();
        return this.stateManager;
    }

    public String getName() {
        this.verifyTaskActive();
        return this.procNode.getName();
    }
}

