/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.impl.JerseyNiFiRegistryClient;
import org.apache.nifi.registry.flow.ExternalControllerServiceReference;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.VersionedParameterContext;
import org.apache.nifi.registry.flow.VersionedProcessGroup;

public class RestBasedFlowRegistry
implements FlowRegistry {
    public static final String FLOW_ENCODING_VERSION = "1.0";
    private final FlowRegistryClient flowRegistryClient;
    private final String identifier;
    private final SSLContext sslContext;
    private volatile String description;
    private volatile String url;
    private volatile String name;
    private NiFiRegistryClient registryClient;

    public RestBasedFlowRegistry(FlowRegistryClient flowRegistryClient, String identifier, String url, SSLContext sslContext, String name) {
        this.flowRegistryClient = flowRegistryClient;
        this.identifier = identifier;
        this.url = url;
        this.name = name;
        this.sslContext = sslContext;
    }

    private synchronized NiFiRegistryClient getRegistryClient() {
        if (this.registryClient != null) {
            return this.registryClient;
        }
        NiFiRegistryClientConfig config = new NiFiRegistryClientConfig.Builder().connectTimeout(Integer.valueOf(30000)).readTimeout(Integer.valueOf(30000)).sslContext(this.sslContext).baseUrl(this.url).build();
        this.registryClient = new JerseyNiFiRegistryClient.Builder().config(config).build();
        return this.registryClient;
    }

    private synchronized void invalidateClient() {
        this.registryClient = null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized void setURL(String url) {
        this.url = url;
        this.invalidateClient();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String getIdentity(NiFiUser user) {
        return user == null || user.isAnonymous() ? null : user.getIdentity();
    }

    private BucketClient getBucketClient(NiFiUser user) {
        String identity = this.getIdentity(user);
        NiFiRegistryClient registryClient = this.getRegistryClient();
        BucketClient bucketClient = identity == null ? registryClient.getBucketClient() : registryClient.getBucketClient(new String[]{identity});
        return bucketClient;
    }

    private FlowSnapshotClient getFlowSnapshotClient(NiFiUser user) {
        String identity = this.getIdentity(user);
        NiFiRegistryClient registryClient = this.getRegistryClient();
        FlowSnapshotClient snapshotClient = identity == null ? registryClient.getFlowSnapshotClient() : registryClient.getFlowSnapshotClient(new String[]{identity});
        return snapshotClient;
    }

    private FlowClient getFlowClient(NiFiUser user) {
        String identity = this.getIdentity(user);
        NiFiRegistryClient registryClient = this.getRegistryClient();
        FlowClient flowClient = identity == null ? registryClient.getFlowClient() : registryClient.getFlowClient(new String[]{identity});
        return flowClient;
    }

    public Set<Bucket> getBuckets(NiFiUser user) throws IOException, NiFiRegistryException {
        BucketClient bucketClient = this.getBucketClient(user);
        return new HashSet<Bucket>(bucketClient.getAll());
    }

    public Bucket getBucket(String bucketId, NiFiUser user) throws IOException, NiFiRegistryException {
        BucketClient bucketClient = this.getBucketClient(user);
        return bucketClient.get(bucketId);
    }

    public Set<VersionedFlow> getFlows(String bucketId, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowClient flowClient = this.getFlowClient(user);
        return new HashSet<VersionedFlow>(flowClient.getByBucket(bucketId));
    }

    public Set<VersionedFlowSnapshotMetadata> getFlowVersions(String bucketId, String flowId, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowSnapshotClient snapshotClient = this.getFlowSnapshotClient(user);
        return new HashSet<VersionedFlowSnapshotMetadata>(snapshotClient.getSnapshotMetadata(bucketId, flowId));
    }

    public VersionedFlow registerVersionedFlow(VersionedFlow flow, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowClient flowClient = this.getFlowClient(user);
        return flowClient.create(flow);
    }

    public VersionedFlow deleteVersionedFlow(String bucketId, String flowId, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowClient flowClient = this.getFlowClient(user);
        return flowClient.delete(bucketId, flowId);
    }

    public VersionedFlowSnapshot registerVersionedFlowSnapshot(VersionedFlow flow, VersionedProcessGroup snapshot, Map<String, ExternalControllerServiceReference> externalControllerServices, Map<String, VersionedParameterContext> parameterContexts, String comments, int expectedVersion, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowSnapshotClient snapshotClient = this.getFlowSnapshotClient(user);
        VersionedFlowSnapshot versionedFlowSnapshot = new VersionedFlowSnapshot();
        versionedFlowSnapshot.setFlowContents(snapshot);
        versionedFlowSnapshot.setExternalControllerServices(externalControllerServices);
        versionedFlowSnapshot.setParameterContexts(parameterContexts);
        versionedFlowSnapshot.setFlowEncodingVersion(FLOW_ENCODING_VERSION);
        VersionedFlowSnapshotMetadata metadata = new VersionedFlowSnapshotMetadata();
        metadata.setBucketIdentifier(flow.getBucketIdentifier());
        metadata.setFlowIdentifier(flow.getIdentifier());
        metadata.setAuthor(this.getIdentity(user));
        metadata.setTimestamp(System.currentTimeMillis());
        metadata.setVersion(expectedVersion);
        metadata.setComments(comments);
        versionedFlowSnapshot.setSnapshotMetadata(metadata);
        return snapshotClient.create(versionedFlowSnapshot);
    }

    public int getLatestVersion(String bucketId, String flowId, NiFiUser user) throws IOException, NiFiRegistryException {
        return (int)this.getFlowClient(user).get(bucketId, flowId).getVersionCount();
    }

    public VersionedFlowSnapshot getFlowContents(String bucketId, String flowId, int version, boolean fetchRemoteFlows, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowSnapshotClient snapshotClient = this.getFlowSnapshotClient(user);
        VersionedFlowSnapshot flowSnapshot = snapshotClient.get(bucketId, flowId, version);
        if (fetchRemoteFlows) {
            VersionedProcessGroup contents = flowSnapshot.getFlowContents();
            for (VersionedProcessGroup child : contents.getProcessGroups()) {
                this.populateVersionedContentsRecursively(child, user);
            }
        }
        return flowSnapshot;
    }

    public VersionedFlowSnapshot getFlowContents(String bucketId, String flowId, int version, boolean fetchRemoteFlows) throws IOException, NiFiRegistryException {
        return this.getFlowContents(bucketId, flowId, version, fetchRemoteFlows, null);
    }

    private void populateVersionedContentsRecursively(VersionedProcessGroup group, NiFiUser user) throws NiFiRegistryException, IOException {
        if (group == null) {
            return;
        }
        VersionedFlowCoordinates coordinates = group.getVersionedFlowCoordinates();
        if (coordinates != null) {
            String registryUrl = coordinates.getRegistryUrl();
            String bucketId = coordinates.getBucketId();
            String flowId = coordinates.getFlowId();
            int version = coordinates.getVersion();
            String registryId = this.flowRegistryClient.getFlowRegistryId(registryUrl);
            if (registryId == null) {
                throw new NiFiRegistryException("Flow contains a reference to another Versioned Flow located at URL " + registryUrl + " but NiFi is not configured to communicate with a Flow Registry at that URL");
            }
            FlowRegistry flowRegistry = this.flowRegistryClient.getFlowRegistry(registryId);
            VersionedFlowSnapshot snapshot = flowRegistry.getFlowContents(bucketId, flowId, version, true, user);
            VersionedProcessGroup contents = snapshot.getFlowContents();
            group.setComments(contents.getComments());
            group.setConnections(contents.getConnections());
            group.setControllerServices(contents.getControllerServices());
            group.setFunnels(contents.getFunnels());
            group.setInputPorts(contents.getInputPorts());
            group.setLabels(contents.getLabels());
            group.setOutputPorts(contents.getOutputPorts());
            group.setProcessGroups(contents.getProcessGroups());
            group.setProcessors(contents.getProcessors());
            group.setRemoteProcessGroups(contents.getRemoteProcessGroups());
            group.setVariables(contents.getVariables());
            coordinates.setLatest(Boolean.valueOf(snapshot.isLatest()));
        }
        for (VersionedProcessGroup child : group.getProcessGroups()) {
            this.populateVersionedContentsRecursively(child, user);
        }
    }

    public VersionedFlow getVersionedFlow(String bucketId, String flowId, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowClient flowClient = this.getFlowClient(user);
        return flowClient.get(bucketId, flowId);
    }

    public VersionedFlow getVersionedFlow(String bucketId, String flowId) throws IOException, NiFiRegistryException {
        FlowClient flowClient = this.getRegistryClient().getFlowClient();
        return flowClient.get(bucketId, flowId);
    }
}

