/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.controller.repository.metrics.EmptyFlowFileEvent;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.RunStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.controller.status.analytics.ConnectionStatusPredictions;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsEngine;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.history.History;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.reporting.UserAwareEventAccess;

public class StandardEventAccess
implements UserAwareEventAccess {
    private final FlowFileEventRepository flowFileEventRepository;
    private final FlowController flowController;
    private final StatusAnalyticsEngine statusAnalyticsEngine;

    public StandardEventAccess(FlowController flowController, FlowFileEventRepository flowFileEventRepository) {
        this.flowController = flowController;
        this.flowFileEventRepository = flowFileEventRepository;
        this.statusAnalyticsEngine = flowController.getStatusAnalyticsEngine();
    }

    public ProcessGroupStatus getControllerStatus() {
        return this.getGroupStatus(this.flowController.getFlowManager().getRootGroupId());
    }

    public ProcessGroupStatus getGroupStatus(String groupId) {
        RepositoryStatusReport repoStatusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(groupId, repoStatusReport);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport) {
        ProcessGroup group = this.flowController.getFlowManager().getGroup(groupId);
        return this.getGroupStatus(group, statusReport, (Predicate<Authorizable>)((Predicate)authorizable -> true), Integer.MAX_VALUE, 1);
    }

    public List<ProvenanceEventRecord> getProvenanceEvents(long firstEventId, int maxRecords) throws IOException {
        return new ArrayList<ProvenanceEventRecord>(this.getProvenanceRepository().getEvents(firstEventId, maxRecords));
    }

    public List<Action> getFlowChanges(int firstActionId, int maxActions) {
        History history = this.flowController.getAuditService().getActions(firstActionId, maxActions);
        return new ArrayList<Action>(history.getActions());
    }

    public ProvenanceRepository getProvenanceRepository() {
        return this.flowController.getProvenanceRepository();
    }

    private RepositoryStatusReport generateRepositoryStatusReport() {
        return this.flowFileEventRepository.reportTransferEvents(System.currentTimeMillis());
    }

    public ProcessGroupStatus getGroupStatus(String groupId, NiFiUser user, int recursiveStatusDepth) {
        RepositoryStatusReport repoStatusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(groupId, repoStatusReport, user, recursiveStatusDepth);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport, NiFiUser user) {
        ProcessGroup group = this.flowController.getFlowManager().getGroup(groupId);
        return this.getGroupStatus(group, statusReport, (Predicate<Authorizable>)((Predicate)authorizable -> authorizable.isAuthorized(this.flowController.getAuthorizer(), RequestAction.READ, user)), Integer.MAX_VALUE, 1);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, NiFiUser user) {
        RepositoryStatusReport repoStatusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(groupId, repoStatusReport, user);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport, NiFiUser user, int recursiveStatusDepth) {
        ProcessGroup group = this.flowController.getFlowManager().getGroup(groupId);
        return this.getGroupStatus(group, statusReport, (Predicate<Authorizable>)((Predicate)authorizable -> authorizable.isAuthorized(this.flowController.getAuthorizer(), RequestAction.READ, user)), recursiveStatusDepth, 1);
    }

    ProcessGroupStatus getGroupStatus(ProcessGroup group, RepositoryStatusReport statusReport, Predicate<Authorizable> isAuthorized, int recursiveStatusDepth, int currentDepth) {
        if (group == null) {
            return null;
        }
        StandardProcessScheduler processScheduler = this.flowController.getProcessScheduler();
        ProcessGroupStatus status = new ProcessGroupStatus();
        status.setId(group.getIdentifier());
        status.setName(isAuthorized.evaluate((Object)group) ? group.getName() : group.getIdentifier());
        int activeGroupThreads = 0;
        int terminatedGroupThreads = 0;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        int queuedCount = 0;
        long queuedContentSize = 0L;
        int flowFilesIn = 0;
        long bytesIn = 0L;
        int flowFilesOut = 0;
        long bytesOut = 0L;
        int flowFilesReceived = 0;
        long bytesReceived = 0L;
        int flowFilesSent = 0;
        long bytesSent = 0L;
        int flowFilesTransferred = 0;
        long bytesTransferred = 0L;
        boolean populateChildStatuses = currentDepth <= recursiveStatusDepth;
        ArrayList<ProcessorStatus> processorStatusCollection = new ArrayList<ProcessorStatus>();
        status.setProcessorStatus(processorStatusCollection);
        for (Object procNode : group.getProcessors()) {
            ProcessorStatus procStat = this.getProcessorStatus(statusReport, (ProcessorNode)procNode, isAuthorized);
            if (populateChildStatuses) {
                processorStatusCollection.add(procStat);
            }
            activeGroupThreads += procStat.getActiveThreadCount();
            terminatedGroupThreads += procStat.getTerminatedThreadCount();
            bytesRead += procStat.getBytesRead();
            bytesWritten += procStat.getBytesWritten();
            flowFilesReceived += procStat.getFlowFilesReceived();
            bytesReceived += procStat.getBytesReceived();
            flowFilesSent += procStat.getFlowFilesSent();
            bytesSent += procStat.getBytesSent();
        }
        ArrayList<ProcessGroupStatus> localChildGroupStatusCollection = new ArrayList<ProcessGroupStatus>();
        status.setProcessGroupStatus(localChildGroupStatusCollection);
        for (Object childGroup : group.getProcessGroups()) {
            ProcessGroupStatus childGroupStatus;
            if (populateChildStatuses) {
                childGroupStatus = this.getGroupStatus((ProcessGroup)childGroup, statusReport, isAuthorized, recursiveStatusDepth, currentDepth + 1);
                localChildGroupStatusCollection.add(childGroupStatus);
            } else {
                childGroupStatus = this.getGroupStatus((ProcessGroup)childGroup, statusReport, (Predicate<Authorizable>)((Predicate)authorizable -> false), recursiveStatusDepth, currentDepth + 1);
            }
            activeGroupThreads += childGroupStatus.getActiveThreadCount().intValue();
            terminatedGroupThreads += childGroupStatus.getTerminatedThreadCount().intValue();
            bytesRead += childGroupStatus.getBytesRead().longValue();
            bytesWritten += childGroupStatus.getBytesWritten().longValue();
            queuedCount += childGroupStatus.getQueuedCount().intValue();
            queuedContentSize += childGroupStatus.getQueuedContentSize().longValue();
            flowFilesReceived += childGroupStatus.getFlowFilesReceived();
            bytesReceived += childGroupStatus.getBytesReceived();
            flowFilesSent += childGroupStatus.getFlowFilesSent();
            bytesSent += childGroupStatus.getBytesSent();
            flowFilesTransferred += childGroupStatus.getFlowFilesTransferred();
            bytesTransferred += childGroupStatus.getBytesTransferred();
        }
        ArrayList<RemoteProcessGroupStatus> remoteProcessGroupStatusCollection = new ArrayList<RemoteProcessGroupStatus>();
        status.setRemoteProcessGroupStatus(remoteProcessGroupStatusCollection);
        for (Object remoteGroup : group.getRemoteProcessGroups()) {
            RemoteProcessGroupStatus remoteStatus = this.createRemoteGroupStatus((RemoteProcessGroup)remoteGroup, statusReport, isAuthorized);
            if (remoteStatus == null) continue;
            if (populateChildStatuses) {
                remoteProcessGroupStatusCollection.add(remoteStatus);
            }
            flowFilesReceived += remoteStatus.getReceivedCount().intValue();
            bytesReceived += remoteStatus.getReceivedContentSize().longValue();
            flowFilesSent += remoteStatus.getSentCount().intValue();
            bytesSent += remoteStatus.getSentContentSize().longValue();
        }
        ArrayList<ConnectionStatus> connectionStatusCollection = new ArrayList<ConnectionStatus>();
        status.setConnectionStatus(connectionStatusCollection);
        for (Connection conn : group.getConnections()) {
            Connectable destination;
            boolean isConnectionAuthorized = isAuthorized.evaluate((Object)conn);
            boolean isSourceAuthorized = isAuthorized.evaluate((Object)conn.getSource());
            boolean isDestinationAuthorized = isAuthorized.evaluate((Object)conn.getDestination());
            ConnectionStatus connStatus = new ConnectionStatus();
            connStatus.setId(conn.getIdentifier());
            connStatus.setGroupId(conn.getProcessGroup().getIdentifier());
            connStatus.setSourceId(conn.getSource().getIdentifier());
            connStatus.setSourceName(isSourceAuthorized ? conn.getSource().getName() : conn.getSource().getIdentifier());
            connStatus.setDestinationId(conn.getDestination().getIdentifier());
            connStatus.setDestinationName(isDestinationAuthorized ? conn.getDestination().getName() : conn.getDestination().getIdentifier());
            connStatus.setBackPressureDataSizeThreshold(conn.getFlowFileQueue().getBackPressureDataSizeThreshold());
            connStatus.setBackPressureObjectThreshold(conn.getFlowFileQueue().getBackPressureObjectThreshold());
            FlowFileEvent connectionStatusReport = statusReport.getReportEntry(conn.getIdentifier());
            if (connectionStatusReport != null) {
                connStatus.setInputBytes(connectionStatusReport.getContentSizeIn());
                connStatus.setInputCount(connectionStatusReport.getFlowFilesIn());
                connStatus.setOutputBytes(connectionStatusReport.getContentSizeOut());
                connStatus.setOutputCount(connectionStatusReport.getFlowFilesOut());
                flowFilesTransferred += connectionStatusReport.getFlowFilesIn() + connectionStatusReport.getFlowFilesOut();
                bytesTransferred += connectionStatusReport.getContentSizeIn() + connectionStatusReport.getContentSizeOut();
            }
            if (this.statusAnalyticsEngine != null) {
                StatusAnalytics statusAnalytics = this.statusAnalyticsEngine.getStatusAnalytics(conn.getIdentifier());
                if (statusAnalytics != null) {
                    Map predictionValues = statusAnalytics.getPredictions();
                    ConnectionStatusPredictions predictions = new ConnectionStatusPredictions();
                    connStatus.setPredictions(predictions);
                    predictions.setPredictedTimeToBytesBackpressureMillis(((Long)predictionValues.get("timeToBytesBackpressureMillis")).longValue());
                    predictions.setPredictedTimeToCountBackpressureMillis(((Long)predictionValues.get("timeToCountBackpressureMillis")).longValue());
                    predictions.setNextPredictedQueuedBytes(((Long)predictionValues.get("nextIntervalBytes")).longValue());
                    predictions.setNextPredictedQueuedCount(((Long)predictionValues.get("nextIntervalCount")).intValue());
                    predictions.setPredictedPercentCount(((Long)predictionValues.get("nextIntervalPercentageUseCount")).intValue());
                    predictions.setPredictedPercentBytes(((Long)predictionValues.get("nextIntervalPercentageUseBytes")).intValue());
                    predictions.setPredictionIntervalMillis(((Long)predictionValues.get("intervalTimeMillis")).longValue());
                }
            } else {
                connStatus.setPredictions(null);
            }
            if (isConnectionAuthorized) {
                if (StringUtils.isNotBlank((CharSequence)conn.getName())) {
                    connStatus.setName(conn.getName());
                } else if (conn.getRelationships() != null && !conn.getRelationships().isEmpty()) {
                    ArrayList<String> relationships = new ArrayList<String>(conn.getRelationships().size());
                    for (Relationship relationship : conn.getRelationships()) {
                        relationships.add(relationship.getName());
                    }
                    connStatus.setName(StringUtils.join(relationships, (String)", "));
                }
            } else {
                connStatus.setName(conn.getIdentifier());
            }
            QueueSize queueSize = conn.getFlowFileQueue().size();
            int connectionQueuedCount = queueSize.getObjectCount();
            long connectionQueuedBytes = queueSize.getByteCount();
            if (connectionQueuedCount > 0) {
                connStatus.setQueuedBytes(connectionQueuedBytes);
                connStatus.setQueuedCount(connectionQueuedCount);
            }
            if (populateChildStatuses) {
                connectionStatusCollection.add(connStatus);
            }
            queuedCount += connectionQueuedCount;
            queuedContentSize += connectionQueuedBytes;
            Connectable source = conn.getSource();
            if (ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)source.getConnectableType())) {
                RemoteGroupPort remoteOutputPort = (RemoteGroupPort)source;
                activeGroupThreads += processScheduler.getActiveThreadCount(remoteOutputPort);
            }
            if (!ConnectableType.REMOTE_INPUT_PORT.equals((Object)(destination = conn.getDestination()).getConnectableType())) continue;
            RemoteGroupPort remoteInputPort = (RemoteGroupPort)destination;
            activeGroupThreads += processScheduler.getActiveThreadCount(remoteInputPort);
        }
        ArrayList<PortStatus> inputPortStatusCollection = new ArrayList<PortStatus>();
        status.setInputPortStatus(inputPortStatusCollection);
        Set inputPorts = group.getInputPorts();
        for (Port port : inputPorts) {
            FlowFileEvent entry;
            boolean isInputPortAuthorized = isAuthorized.evaluate((Object)port);
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(isInputPortAuthorized ? port.getName() : port.getIdentifier());
            portStatus.setActiveThreadCount(Integer.valueOf(processScheduler.getActiveThreadCount(port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof PublicPort) {
                portStatus.setTransmitting(Boolean.valueOf(((PublicPort)port).isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                flowFilesIn += port instanceof PublicPort ? entry.getFlowFilesReceived() : inputCount;
                bytesIn += port instanceof PublicPort ? entry.getBytesReceived() : inputBytes;
                bytesWritten += entry.getBytesWritten();
                flowFilesReceived += entry.getFlowFilesReceived();
                bytesReceived += entry.getBytesReceived();
            }
            if (populateChildStatuses) {
                inputPortStatusCollection.add(portStatus);
            }
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        ArrayList<PortStatus> outputPortStatusCollection = new ArrayList<PortStatus>();
        status.setOutputPortStatus(outputPortStatusCollection);
        Set outputPorts = group.getOutputPorts();
        for (Port port : outputPorts) {
            FlowFileEvent entry;
            boolean isOutputPortAuthorized = isAuthorized.evaluate((Object)port);
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(isOutputPortAuthorized ? port.getName() : port.getIdentifier());
            portStatus.setActiveThreadCount(Integer.valueOf(processScheduler.getActiveThreadCount(port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof PublicPort) {
                portStatus.setTransmitting(Boolean.valueOf(((PublicPort)port).isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                bytesRead += entry.getBytesRead();
                flowFilesOut += port instanceof PublicPort ? entry.getFlowFilesSent() : entry.getFlowFilesOut();
                bytesOut += port instanceof PublicPort ? entry.getBytesSent() : entry.getContentSizeOut();
                flowFilesSent = entry.getFlowFilesSent();
                bytesSent += entry.getBytesSent();
            }
            if (populateChildStatuses) {
                outputPortStatusCollection.add(portStatus);
            }
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        for (Funnel funnel : group.getFunnels()) {
            activeGroupThreads += processScheduler.getActiveThreadCount(funnel);
        }
        status.setActiveThreadCount(Integer.valueOf(activeGroupThreads));
        status.setTerminatedThreadCount(Integer.valueOf(terminatedGroupThreads));
        status.setBytesRead(Long.valueOf(bytesRead));
        status.setBytesWritten(Long.valueOf(bytesWritten));
        status.setQueuedCount(Integer.valueOf(queuedCount));
        status.setQueuedContentSize(Long.valueOf(queuedContentSize));
        status.setInputContentSize(Long.valueOf(bytesIn));
        status.setInputCount(Integer.valueOf(flowFilesIn));
        status.setOutputContentSize(Long.valueOf(bytesOut));
        status.setOutputCount(Integer.valueOf(flowFilesOut));
        status.setFlowFilesReceived(flowFilesReceived);
        status.setBytesReceived(bytesReceived);
        status.setFlowFilesSent(flowFilesSent);
        status.setBytesSent(bytesSent);
        status.setFlowFilesTransferred(flowFilesTransferred);
        status.setBytesTransferred(bytesTransferred);
        VersionControlInformation vci = group.getVersionControlInformation();
        if (vci != null && vci.getStatus() != null && vci.getStatus().getState() != null) {
            status.setVersionedFlowState(vci.getStatus().getState());
        }
        return status;
    }

    private RemoteProcessGroupStatus createRemoteGroupStatus(RemoteProcessGroup remoteGroup, RepositoryStatusReport statusReport, Predicate<Authorizable> isAuthorized) {
        FlowFileEvent portEvent;
        boolean isConnected;
        boolean isRemoteProcessGroupAuthorized = isAuthorized.evaluate((Object)remoteGroup);
        StandardProcessScheduler processScheduler = this.flowController.getProcessScheduler();
        int receivedCount = 0;
        long receivedContentSize = 0L;
        int sentCount = 0;
        long sentContentSize = 0L;
        int activeThreadCount = 0;
        int activePortCount = 0;
        int inactivePortCount = 0;
        RemoteProcessGroupStatus status = new RemoteProcessGroupStatus();
        status.setGroupId(remoteGroup.getProcessGroup().getIdentifier());
        status.setName(isRemoteProcessGroupAuthorized ? remoteGroup.getName() : remoteGroup.getIdentifier());
        status.setTargetUri(isRemoteProcessGroupAuthorized ? remoteGroup.getTargetUri() : null);
        long lineageMillis = 0L;
        int flowFilesRemoved = 0;
        int flowFilesTransferred = 0;
        for (Port port : remoteGroup.getInputPorts()) {
            isConnected = port.hasIncomingConnection();
            if (!isConnected) continue;
            if (port.isRunning()) {
                ++activePortCount;
            } else {
                ++inactivePortCount;
            }
            activeThreadCount += processScheduler.getActiveThreadCount(port);
            portEvent = statusReport.getReportEntry(port.getIdentifier());
            if (portEvent == null) continue;
            lineageMillis += portEvent.getAggregateLineageMillis();
            flowFilesRemoved += portEvent.getFlowFilesRemoved();
            flowFilesTransferred += portEvent.getFlowFilesOut();
            sentCount += portEvent.getFlowFilesSent();
            sentContentSize += portEvent.getBytesSent();
        }
        for (Port port : remoteGroup.getOutputPorts()) {
            isConnected = !port.getConnections().isEmpty();
            if (!isConnected) continue;
            if (port.isRunning()) {
                ++activePortCount;
            } else {
                ++inactivePortCount;
            }
            activeThreadCount += processScheduler.getActiveThreadCount(port);
            portEvent = statusReport.getReportEntry(port.getIdentifier());
            if (portEvent == null) continue;
            receivedCount += portEvent.getFlowFilesReceived();
            receivedContentSize += portEvent.getBytesReceived();
        }
        status.setId(remoteGroup.getIdentifier());
        status.setTransmissionStatus(remoteGroup.isTransmitting() ? TransmissionStatus.Transmitting : TransmissionStatus.NotTransmitting);
        status.setActiveThreadCount(Integer.valueOf(activeThreadCount));
        status.setReceivedContentSize(Long.valueOf(receivedContentSize));
        status.setReceivedCount(Integer.valueOf(receivedCount));
        status.setSentContentSize(Long.valueOf(sentContentSize));
        status.setSentCount(Integer.valueOf(sentCount));
        status.setActiveRemotePortCount(Integer.valueOf(activePortCount));
        status.setInactiveRemotePortCount(Integer.valueOf(inactivePortCount));
        int flowFilesOutOrRemoved = flowFilesTransferred + flowFilesRemoved;
        status.setAverageLineageDuration(flowFilesOutOrRemoved == 0 ? 0L : lineageMillis / (long)flowFilesOutOrRemoved, TimeUnit.MILLISECONDS);
        return status;
    }

    private ProcessorStatus getProcessorStatus(RepositoryStatusReport report, ProcessorNode procNode, Predicate<Authorizable> isAuthorized) {
        boolean isProcessorAuthorized = isAuthorized.evaluate((Object)procNode);
        StandardProcessScheduler processScheduler = this.flowController.getProcessScheduler();
        ProcessorStatus status = new ProcessorStatus();
        status.setId(procNode.getIdentifier());
        status.setGroupId(procNode.getProcessGroup().getIdentifier());
        status.setName(isProcessorAuthorized ? procNode.getName() : procNode.getIdentifier());
        status.setType(isProcessorAuthorized ? procNode.getComponentType() : "Processor");
        FlowFileEvent entry = (FlowFileEvent)report.getReportEntries().get(procNode.getIdentifier());
        if (entry != null && entry != EmptyFlowFileEvent.INSTANCE) {
            int processedCount = entry.getFlowFilesOut();
            long numProcessedBytes = entry.getContentSizeOut();
            status.setOutputBytes(numProcessedBytes);
            status.setOutputCount(processedCount);
            int inputCount = entry.getFlowFilesIn();
            long inputBytes = entry.getContentSizeIn();
            status.setInputBytes(inputBytes);
            status.setInputCount(inputCount);
            long readBytes = entry.getBytesRead();
            status.setBytesRead(readBytes);
            long writtenBytes = entry.getBytesWritten();
            status.setBytesWritten(writtenBytes);
            status.setProcessingNanos(entry.getProcessingNanoseconds());
            status.setInvocations(entry.getInvocations());
            status.setAverageLineageDuration(entry.getAverageLineageMillis());
            status.setFlowFilesReceived(entry.getFlowFilesReceived());
            status.setBytesReceived(entry.getBytesReceived());
            status.setFlowFilesSent(entry.getFlowFilesSent());
            status.setBytesSent(entry.getBytesSent());
            status.setFlowFilesRemoved(entry.getFlowFilesRemoved());
            if (isProcessorAuthorized) {
                status.setCounters(entry.getCounters());
            }
        }
        if (ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Disabled);
        } else if (ScheduledState.RUNNING.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Running);
        } else if (procNode.getValidationStatus() == ValidationStatus.VALIDATING) {
            status.setRunStatus(RunStatus.Validating);
        } else if (procNode.getValidationStatus() == ValidationStatus.INVALID) {
            status.setRunStatus(RunStatus.Invalid);
        } else {
            status.setRunStatus(RunStatus.Stopped);
        }
        status.setExecutionNode(procNode.getExecutionNode());
        status.setTerminatedThreadCount(procNode.getTerminatedThreadCount());
        status.setActiveThreadCount(processScheduler.getActiveThreadCount(procNode));
        return status;
    }
}

