/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.persistence.TemplateDeserializer;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.w3c.dom.Element;

public class TemplateUtils {
    public static TemplateDTO parseDto(Element templateElement) {
        try {
            DOMSource domSource = new DOMSource(templateElement);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(baos);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(domSource, streamResult);
            return TemplateUtils.parseDto(baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse XML as a valid template", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TemplateDTO parseDto(byte[] bytes) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            TemplateDTO templateDTO = TemplateDeserializer.deserialize(in);
            return templateDTO;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not parse bytes as template", ioe);
        }
    }

    public static void escapeParameterReferences(TemplateDTO templateDto) {
        String encodingVersion = templateDto.getEncodingVersion();
        if (encodingVersion == null) {
            TemplateUtils.escapeParameterReferences(templateDto.getSnippet());
        } else {
            switch (encodingVersion) {
                case "1.0": 
                case "1.1": 
                case "1.2": {
                    TemplateUtils.escapeParameterReferences(templateDto.getSnippet());
                }
            }
        }
    }

    private static void escapeParameterReferences(FlowSnippetDTO flowSnippetDTO) {
        flowSnippetDTO.getProcessors().forEach(TemplateUtils::escapeParameterReferences);
        flowSnippetDTO.getControllerServices().forEach(TemplateUtils::escapeParameterReferences);
        for (ProcessGroupDTO groupDto : flowSnippetDTO.getProcessGroups()) {
            TemplateUtils.escapeParameterReferences(groupDto.getContents());
        }
    }

    private static void escapeParameterReferences(ProcessorDTO processorDto) {
        ProcessorConfigDTO config = processorDto.getConfig();
        if (config == null) {
            return;
        }
        ExpressionLanguageAwareParameterParser parameterParser = new ExpressionLanguageAwareParameterParser();
        HashMap escapedPropertyValues = new HashMap();
        for (Map.Entry entry : config.getProperties().entrySet()) {
            ParameterTokenList references = parameterParser.parseTokens((String)entry.getValue());
            String escaped = references.escape();
            escapedPropertyValues.put(entry.getKey(), escaped);
        }
        config.setProperties(escapedPropertyValues);
    }

    private static void escapeParameterReferences(ControllerServiceDTO controllerServiceDTO) {
        ExpressionLanguageAwareParameterParser parameterParser = new ExpressionLanguageAwareParameterParser();
        HashMap escapedPropertyValues = new HashMap();
        for (Map.Entry entry : controllerServiceDTO.getProperties().entrySet()) {
            ParameterTokenList references = parameterParser.parseTokens((String)entry.getValue());
            String escaped = references.escape();
            escapedPropertyValues.put(entry.getKey(), escaped);
        }
        controllerServiceDTO.setProperties(escapedPropertyValues);
    }

    public static void scrubTemplate(TemplateDTO templateDto) {
        TemplateUtils.scrubSnippet(templateDto.getSnippet());
    }

    private static void scrubSnippet(FlowSnippetDTO snippet) {
        if (snippet != null) {
            if (snippet.getProcessors() != null) {
                TemplateUtils.scrubProcessors(snippet.getProcessors());
            }
            if (snippet.getConnections() != null) {
                TemplateUtils.scrubConnections(snippet.getConnections());
            }
            if (snippet.getRemoteProcessGroups() != null) {
                TemplateUtils.scrubRemoteProcessGroups(snippet.getRemoteProcessGroups());
            }
            if (snippet.getProcessGroups() != null) {
                TemplateUtils.scrubProcessGroups(snippet.getProcessGroups());
            }
            if (snippet.getControllerServices() != null) {
                TemplateUtils.scrubControllerServices(snippet.getControllerServices());
            }
        }
    }

    private static void scrubProcessGroups(Set<ProcessGroupDTO> processGroups) {
        for (ProcessGroupDTO processGroupDTO : processGroups) {
            processGroupDTO.setActiveRemotePortCount(null);
            processGroupDTO.setDisabledCount(null);
            processGroupDTO.setInactiveRemotePortCount(null);
            processGroupDTO.setLocalInputPortCount(null);
            processGroupDTO.setPublicInputPortCount(null);
            processGroupDTO.setInvalidCount(null);
            processGroupDTO.setLocalOutputPortCount(null);
            processGroupDTO.setPublicOutputPortCount(null);
            processGroupDTO.setRunningCount(null);
            processGroupDTO.setStoppedCount(null);
            processGroupDTO.setUpToDateCount(null);
            processGroupDTO.setLocallyModifiedCount(null);
            processGroupDTO.setStaleCount(null);
            processGroupDTO.setLocallyModifiedAndStaleCount(null);
            processGroupDTO.setSyncFailureCount(null);
            processGroupDTO.setVersionControlInformation(null);
            processGroupDTO.setParameterContext(null);
            TemplateUtils.scrubSnippet(processGroupDTO.getContents());
        }
    }

    private static void scrubProcessors(Set<ProcessorDTO> processors) {
        for (ProcessorDTO processorDTO : processors) {
            ProcessorConfigDTO processorConfig = processorDTO.getConfig();
            if (processorConfig != null) {
                if (processorConfig.getProperties() != null) {
                    Map processorProperties = processorConfig.getProperties();
                    if (processorConfig.getDescriptors() != null) {
                        Collection descriptors = processorConfig.getDescriptors().values();
                        for (PropertyDescriptorDTO descriptor : descriptors) {
                            if (Boolean.TRUE.equals(descriptor.isSensitive())) {
                                processorProperties.put(descriptor.getName(), null);
                            }
                            TemplateUtils.scrubPropertyDescriptor(descriptor);
                        }
                    }
                }
                processorConfig.setCustomUiUrl(null);
                processorConfig.setDefaultConcurrentTasks(null);
                processorConfig.setDefaultSchedulingPeriod(null);
                processorConfig.setAutoTerminatedRelationships(null);
            }
            if (processorDTO.getRelationships() != null) {
                for (RelationshipDTO relationship : processorDTO.getRelationships()) {
                    relationship.setDescription(null);
                }
            }
            processorDTO.setExtensionMissing(null);
            processorDTO.setMultipleVersionsAvailable(null);
            processorDTO.setValidationErrors(null);
            processorDTO.setValidationStatus(null);
            processorDTO.setInputRequirement(null);
            processorDTO.setDescription(null);
            processorDTO.setInputRequirement(null);
            processorDTO.setPersistsState(null);
            processorDTO.setSupportsBatching(null);
            processorDTO.setSupportsEventDriven(null);
            processorDTO.setSupportsParallelProcessing(null);
        }
    }

    private static void scrubPropertyDescriptor(PropertyDescriptorDTO descriptor) {
        descriptor.setAllowableValues(null);
        descriptor.setDefaultValue(null);
        descriptor.setDescription(null);
        descriptor.setDisplayName(null);
        descriptor.setDynamic(null);
        descriptor.setRequired(null);
        descriptor.setSensitive(null);
        descriptor.setSupportsEl(null);
        descriptor.setExpressionLanguageScope(null);
        descriptor.setIdentifiesControllerServiceBundle(null);
    }

    private static void scrubControllerServices(Set<ControllerServiceDTO> controllerServices) {
        for (ControllerServiceDTO serviceDTO : controllerServices) {
            Map properties = serviceDTO.getProperties();
            Map descriptors = serviceDTO.getDescriptors();
            if (properties != null && descriptors != null) {
                for (PropertyDescriptorDTO descriptor : descriptors.values()) {
                    if (Boolean.TRUE.equals(descriptor.isSensitive())) {
                        properties.put(descriptor.getName(), null);
                    }
                    TemplateUtils.scrubPropertyDescriptor(descriptor);
                }
            }
            serviceDTO.setControllerServiceApis(null);
            serviceDTO.setExtensionMissing(null);
            serviceDTO.setMultipleVersionsAvailable(null);
            serviceDTO.setCustomUiUrl(null);
            serviceDTO.setValidationErrors(null);
            serviceDTO.setValidationStatus(null);
        }
    }

    private static void scrubConnections(Set<ConnectionDTO> connections) {
        for (ConnectionDTO connectionDTO : connections) {
            connectionDTO.setAvailableRelationships(null);
            TemplateUtils.scrubConnectable(connectionDTO.getSource());
            TemplateUtils.scrubConnectable(connectionDTO.getDestination());
        }
    }

    private static void scrubConnectable(ConnectableDTO connectable) {
        if (connectable != null) {
            connectable.setComments(null);
            connectable.setExists(null);
            connectable.setRunning(null);
            connectable.setTransmitting(null);
            connectable.setName(null);
        }
    }

    private static void scrubRemoteProcessGroups(Set<RemoteProcessGroupDTO> remoteGroups) {
        for (RemoteProcessGroupDTO remoteProcessGroupDTO : remoteGroups) {
            remoteProcessGroupDTO.setFlowRefreshed(null);
            remoteProcessGroupDTO.setInputPortCount(null);
            remoteProcessGroupDTO.setOutputPortCount(null);
            remoteProcessGroupDTO.setTransmitting(null);
            remoteProcessGroupDTO.setProxyPassword(null);
            remoteProcessGroupDTO.setActiveRemoteInputPortCount(null);
            remoteProcessGroupDTO.setInactiveRemoteInputPortCount(null);
            remoteProcessGroupDTO.setActiveRemoteOutputPortCount(null);
            remoteProcessGroupDTO.setInactiveRemoteOutputPortCount(null);
            remoteProcessGroupDTO.setAuthorizationIssues(null);
            remoteProcessGroupDTO.setFlowRefreshed(null);
            remoteProcessGroupDTO.setName(null);
            remoteProcessGroupDTO.setTargetSecure(null);
            remoteProcessGroupDTO.setTransmitting(null);
        }
    }
}

